/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.annotation.Default;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.CacheControl;
import zipkin2.Call;
import zipkin2.Span;
import zipkin2.codec.DependencyLinkBytesEncoder;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.internal.Buffer;
import zipkin2.internal.JsonCodec;
import zipkin2.storage.QueryRequest;
import zipkin2.storage.StorageComponent;

@ConditionalOnProperty(name={"zipkin.query.enabled"}, matchIfMissing=true)
public class ZipkinQueryApiV2 {
    final String storageType;
    final StorageComponent storage;
    final long defaultLookback;
    final int namesMaxAge;
    final List<String> autocompleteKeys;
    volatile int serviceCount;
    static final Buffer.Writer<String> QUOTED_STRING_WRITER = new Buffer.Writer<String>(){

        public int sizeInBytes(String value) {
            return Buffer.utf8SizeInBytes((CharSequence)value) + 2;
        }

        public void write(String value, Buffer buffer) {
            buffer.writeByte(34);
            buffer.writeUtf8((CharSequence)value);
            buffer.writeByte(34);
        }
    };

    ZipkinQueryApiV2(StorageComponent storage, @Value(value="${zipkin.storage.type:mem}") String storageType, @Value(value="${zipkin.query.lookback:86400000}") long defaultLookback, @Value(value="${zipkin.query.names-max-age:300}") int namesMaxAge, @Value(value="${zipkin.storage.autocomplete-keys:}") List<String> autocompleteKeys) {
        this.storage = storage;
        this.storageType = storageType;
        this.defaultLookback = defaultLookback;
        this.namesMaxAge = namesMaxAge;
        this.autocompleteKeys = autocompleteKeys;
    }

    @Get(value="/api/v2/dependencies")
    public AggregatedHttpMessage getDependencies(@Param(value="endTs") long endTs, @Param(value="lookback") Optional<Long> lookback) throws IOException {
        Call call = this.storage.spanStore().getDependencies(endTs, lookback.orElse(this.defaultLookback).longValue());
        return ZipkinQueryApiV2.jsonResponse(DependencyLinkBytesEncoder.JSON_V1.encodeList((List)call.execute()));
    }

    @Get(value="/api/v2/services")
    public AggregatedHttpMessage getServiceNames() throws IOException {
        List serviceNames = (List)this.storage.spanStore().getServiceNames().execute();
        this.serviceCount = serviceNames.size();
        return this.maybeCacheNames(this.serviceCount > 3, serviceNames);
    }

    @Get(value="/api/v2/spans")
    public AggregatedHttpMessage getSpanNames(@Param(value="serviceName") String serviceName) throws IOException {
        List spanNames = (List)this.storage.spanStore().getSpanNames(serviceName).execute();
        return this.maybeCacheNames(this.serviceCount > 3, spanNames);
    }

    @Get(value="/api/v2/traces")
    public AggregatedHttpMessage getTraces(@Param(value="serviceName") Optional<String> serviceName, @Param(value="spanName") Optional<String> spanName, @Param(value="annotationQuery") Optional<String> annotationQuery, @Param(value="minDuration") Optional<Long> minDuration, @Param(value="maxDuration") Optional<Long> maxDuration, @Param(value="endTs") Optional<Long> endTs, @Param(value="lookback") Optional<Long> lookback, @Default(value="10") @Param(value="limit") int limit) throws IOException {
        QueryRequest queryRequest = QueryRequest.newBuilder().serviceName((String)serviceName.orElse(null)).spanName((String)spanName.orElse(null)).parseAnnotationQuery((String)annotationQuery.orElse(null)).minDuration((Long)minDuration.orElse(null)).maxDuration((Long)maxDuration.orElse(null)).endTs(endTs.orElse(System.currentTimeMillis()).longValue()).lookback(lookback.orElse(this.defaultLookback).longValue()).limit(limit).build();
        List traces = (List)this.storage.spanStore().getTraces(queryRequest).execute();
        return ZipkinQueryApiV2.jsonResponse(ZipkinQueryApiV2.writeTraces(SpanBytesEncoder.JSON_V2, traces));
    }

    @Get(value="/api/v2/trace/{traceIdHex}")
    public AggregatedHttpMessage getTrace(@Param(value="traceIdHex") String traceIdHex) throws IOException {
        List trace = (List)this.storage.spanStore().getTrace(traceIdHex).execute();
        if (trace == null) {
            return AggregatedHttpMessage.of((HttpStatus)HttpStatus.NOT_FOUND, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)(traceIdHex + " not found"));
        }
        return ZipkinQueryApiV2.jsonResponse(SpanBytesEncoder.JSON_V2.encodeList(trace));
    }

    static AggregatedHttpMessage jsonResponse(byte[] body) {
        return AggregatedHttpMessage.of((HttpHeaders)((HttpHeaders)HttpHeaders.of((int)200).contentType(MediaType.JSON).setInt((Object)HttpHeaderNames.CONTENT_LENGTH, body.length)), (HttpData)HttpData.of((byte[])body));
    }

    @Get(value="/api/v2/autocompleteKeys")
    public AggregatedHttpMessage getAutocompleteKeys() {
        return this.maybeCacheNames(true, this.autocompleteKeys);
    }

    @Get(value="/api/v2/autocompleteValues")
    public AggregatedHttpMessage getAutocompleteValues(@Param(value="key") String key) throws IOException {
        List values = (List)this.storage.autocompleteTags().getValues(key).execute();
        return this.maybeCacheNames(values.size() > 3, values);
    }

    AggregatedHttpMessage maybeCacheNames(boolean shouldCacheControl, List<String> values) {
        Collections.sort(values);
        byte[] body = JsonCodec.writeList(QUOTED_STRING_WRITER, values);
        HttpHeaders headers = (HttpHeaders)HttpHeaders.of((int)200).contentType(MediaType.JSON).setInt((Object)HttpHeaderNames.CONTENT_LENGTH, body.length);
        if (shouldCacheControl) {
            headers = (HttpHeaders)headers.add((Object)HttpHeaderNames.CACHE_CONTROL, (Object)CacheControl.maxAge((long)this.namesMaxAge, (TimeUnit)TimeUnit.SECONDS).mustRevalidate().getHeaderValue());
        }
        return AggregatedHttpMessage.of((HttpHeaders)headers, (HttpData)HttpData.of((byte[])body));
    }

    static byte[] writeTraces(SpanBytesEncoder codec, List<List<Span>> traces) {
        int length = traces.size();
        int sizeInBytes = 2;
        if (length > 1) {
            sizeInBytes += length - 1;
        }
        for (int i = 0; i < length; ++i) {
            List<Span> spans = traces.get(i);
            int jLength = spans.size();
            sizeInBytes += 2;
            if (jLength > 1) {
                sizeInBytes += jLength - 1;
            }
            for (int j = 0; j < jLength; ++j) {
                sizeInBytes += codec.sizeInBytes((Object)spans.get(j));
            }
        }
        byte[] out = new byte[sizeInBytes];
        int pos = 0;
        out[pos++] = 91;
        for (int i = 0; i < length; ++i) {
            pos += codec.encodeList(traces.get(i), out, pos);
            if (i + 1 >= length) continue;
            out[pos++] = 44;
        }
        out[pos] = 93;
        return out;
    }
}

