/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlOperator;
import org.apache.commons.jexl3.internal.Interpreter;
import org.apache.commons.jexl3.introspection.JexlMethod;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.apache.commons.jexl3.parser.JexlNode;

public class Operators {
    protected final Interpreter interpreter;
    protected final JexlArithmetic.Uberspect operators;

    protected Operators(Interpreter owner) {
        JexlArithmetic arithmetic = owner.arithmetic;
        JexlUberspect uberspect = owner.uberspect;
        this.interpreter = owner;
        this.operators = uberspect.getArithmetic(arithmetic);
    }

    private boolean returnsBoolean(JexlMethod vm) {
        if (vm != null) {
            Class<?> rc = vm.getReturnType();
            return Boolean.TYPE.equals(rc) || Boolean.class.equals(rc);
        }
        return false;
    }

    protected Object tryOverload(JexlNode node, JexlOperator operator, Object ... args) {
        if (this.operators != null && this.operators.overloads(operator)) {
            Object eval;
            JexlMethod me;
            Object cached;
            JexlArithmetic arithmetic = this.interpreter.arithmetic;
            boolean cache = this.interpreter.cache;
            if (cache && (cached = node.jjtGetValue()) instanceof JexlMethod && !(me = (JexlMethod)cached).tryFailed(eval = me.tryInvoke(operator.getMethodName(), arithmetic, args))) {
                return eval;
            }
            try {
                JexlMethod vm = this.operators.getOperator(operator, args);
                if (vm != null) {
                    Object result = vm.invoke(arithmetic, args);
                    if (cache) {
                        node.jjtSetValue(vm);
                    }
                    return result;
                }
            }
            catch (Exception xany) {
                this.interpreter.operatorError(node, operator, xany);
            }
        }
        return JexlEngine.TRY_FAILED;
    }

    protected Object tryAssignOverload(JexlNode node, JexlOperator operator, Object ... args) {
        JexlArithmetic arithmetic = this.interpreter.arithmetic;
        if (args.length != operator.getArity()) {
            return JexlEngine.TRY_FAILED;
        }
        Object result = this.tryOverload(node, operator, args);
        if (result != JexlEngine.TRY_FAILED) {
            return result;
        }
        JexlOperator base = operator.getBaseOperator();
        if (base == null) {
            throw new IllegalArgumentException("must be called with a side-effect operator");
        }
        if (this.operators != null && this.operators.overloads(base)) {
            try {
                JexlMethod vm = this.operators.getOperator(base, args);
                if (vm != null && (result = vm.invoke(arithmetic, args)) != JexlEngine.TRY_FAILED) {
                    return result;
                }
            }
            catch (Exception xany) {
                this.interpreter.operatorError(node, base, xany);
            }
        }
        switch (operator) {
            case SELF_ADD: {
                return arithmetic.add(args[0], args[1]);
            }
            case SELF_SUBTRACT: {
                return arithmetic.subtract(args[0], args[1]);
            }
            case SELF_MULTIPLY: {
                return arithmetic.multiply(args[0], args[1]);
            }
            case SELF_DIVIDE: {
                return arithmetic.divide(args[0], args[1]);
            }
            case SELF_MOD: {
                return arithmetic.mod(args[0], args[1]);
            }
            case SELF_AND: {
                return arithmetic.and(args[0], args[1]);
            }
            case SELF_OR: {
                return arithmetic.or(args[0], args[1]);
            }
            case SELF_XOR: {
                return arithmetic.xor(args[0], args[1]);
            }
        }
        throw new JexlException.Operator(node, operator.getOperatorSymbol(), null);
    }

    protected boolean startsWith(JexlNode node, String operator, Object left, Object right) {
        JexlArithmetic arithmetic = this.interpreter.arithmetic;
        JexlUberspect uberspect = this.interpreter.uberspect;
        try {
            Object result = this.tryOverload(node, JexlOperator.STARTSWITH, left, right);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            Boolean matched = arithmetic.startsWith(left, right);
            if (matched != null) {
                return matched;
            }
            try {
                Object[] argv = new Object[]{right};
                JexlMethod vm = uberspect.getMethod(left, "startsWith", argv);
                if (this.returnsBoolean(vm)) {
                    return (Boolean)vm.invoke(left, argv);
                }
                if (arithmetic.narrowArguments(argv) && this.returnsBoolean(vm = uberspect.getMethod(left, "startsWith", argv))) {
                    return (Boolean)vm.invoke(left, argv);
                }
            }
            catch (Exception e) {
                throw new JexlException(node, operator + " error", (Throwable)e);
            }
            return arithmetic.equals(left, right) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, operator + " error", (Throwable)xrt);
        }
    }

    protected boolean endsWith(JexlNode node, String operator, Object left, Object right) {
        JexlArithmetic arithmetic = this.interpreter.arithmetic;
        JexlUberspect uberspect = this.interpreter.uberspect;
        try {
            Object result = this.tryOverload(node, JexlOperator.ENDSWITH, left, right);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            Boolean matched = arithmetic.endsWith(left, right);
            if (matched != null) {
                return matched;
            }
            try {
                Object[] argv = new Object[]{right};
                JexlMethod vm = uberspect.getMethod(left, "endsWith", argv);
                if (this.returnsBoolean(vm)) {
                    return (Boolean)vm.invoke(left, argv);
                }
                if (arithmetic.narrowArguments(argv) && this.returnsBoolean(vm = uberspect.getMethod(left, "endsWith", argv))) {
                    return (Boolean)vm.invoke(left, argv);
                }
            }
            catch (Exception e) {
                throw new JexlException(node, operator + " error", (Throwable)e);
            }
            return arithmetic.equals(left, right) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, operator + " error", (Throwable)xrt);
        }
    }

    protected boolean contains(JexlNode node, String op, Object left, Object right) {
        JexlArithmetic arithmetic = this.interpreter.arithmetic;
        JexlUberspect uberspect = this.interpreter.uberspect;
        try {
            Object result = this.tryOverload(node, JexlOperator.CONTAINS, left, right);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            Boolean matched = arithmetic.contains(left, right);
            if (matched != null) {
                return matched;
            }
            try {
                Object[] argv = new Object[]{right};
                JexlMethod vm = uberspect.getMethod(left, "contains", argv);
                if (this.returnsBoolean(vm)) {
                    return (Boolean)vm.invoke(left, argv);
                }
                if (arithmetic.narrowArguments(argv) && this.returnsBoolean(vm = uberspect.getMethod(left, "contains", argv))) {
                    return (Boolean)vm.invoke(left, argv);
                }
            }
            catch (Exception e) {
                throw new JexlException(node, op + " error", (Throwable)e);
            }
            return arithmetic.equals(left, right);
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, op + " error", (Throwable)xrt);
        }
    }

    protected Object empty(JexlNode node, Object object) {
        if (object == null) {
            return Boolean.TRUE;
        }
        JexlArithmetic arithmetic = this.interpreter.arithmetic;
        JexlUberspect uberspect = this.interpreter.uberspect;
        Object result = this.tryOverload(node, JexlOperator.EMPTY, object);
        if (result != JexlEngine.TRY_FAILED) {
            return result;
        }
        result = arithmetic.isEmpty(object);
        if (result == null) {
            result = false;
            JexlMethod vm = uberspect.getMethod(object, "isEmpty", Interpreter.EMPTY_PARAMS);
            if (this.returnsBoolean(vm)) {
                try {
                    result = (Boolean)vm.invoke(object, Interpreter.EMPTY_PARAMS);
                }
                catch (Exception xany) {
                    this.interpreter.operatorError(node, JexlOperator.EMPTY, xany);
                }
            }
        }
        return result;
    }

    protected Object size(JexlNode node, Object object) {
        JexlMethod vm;
        if (object == null) {
            return 0;
        }
        JexlArithmetic arithmetic = this.interpreter.arithmetic;
        JexlUberspect uberspect = this.interpreter.uberspect;
        Object result = this.tryOverload(node, JexlOperator.SIZE, object);
        if (result != JexlEngine.TRY_FAILED) {
            return result;
        }
        result = arithmetic.size(object);
        if (result == null && (vm = uberspect.getMethod(object, "size", Interpreter.EMPTY_PARAMS)) != null && (Integer.TYPE.equals(vm.getReturnType()) || Integer.class.equals(vm.getReturnType()))) {
            try {
                result = (Integer)vm.invoke(object, Interpreter.EMPTY_PARAMS);
            }
            catch (Exception xany) {
                this.interpreter.operatorError(node, JexlOperator.SIZE, xany);
            }
        }
        return result;
    }
}

