/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin.baseline;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.felix.bundleplugin.baseline.AbstractBaselinePlugin;
import org.apache.felix.bundleplugin.baseline.DiffMessage;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BaselineReport
extends AbstractBaselinePlugin
implements MavenReport {
    private File outputDirectory;
    private Sink sink;
    private Locale locale;
    private int currentDepth = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void init() {
        this.failOnError = false;
        this.failOnWarning = false;
        File baselineImagesDirectory = new File(this.outputDirectory, "images/baseline");
        baselineImagesDirectory.mkdirs();
        for (String resourceName : new String[]{"access.gif", "annotated.gif", "annotation.gif", "bundle.gif", "class.gif", "constant.gif", "enum.gif", "error.gif", "extends.gif", "field.gif", "implements.gif", "info.gif", "interface.gif", "method.gif", "package.gif", "resource.gif", "return.gif", "version.gif", "warning.gif"}) {
            InputStream source = ((Object)((Object)this)).getClass().getResourceAsStream(resourceName);
            FileOutputStream target = null;
            File targetFile = new File(baselineImagesDirectory, resourceName);
            try {
                target = new FileOutputStream(targetFile);
                IOUtil.copy((InputStream)source, (OutputStream)target);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Impossible to copy " + resourceName + " image, maybe the site won't be properly rendered."));
            }
            finally {
                IOUtil.close((InputStream)source);
                IOUtil.close((OutputStream)target);
            }
        }
    }

    @Override
    protected void startBaseline(String generationDate, String bundleName, String currentVersion, String previousVersion) {
        this.sink.head();
        this.sink.title();
        String title = this.getBundle(this.locale).getString("report.baseline.title");
        this.sink.text(title);
        this.sink.title_();
        this.sink.head_();
        this.sink.body();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(title);
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.getBundle(this.locale).getString("report.baseline.bndlink") + " ");
        this.sink.link("http://www.aqute.biz/Bnd/Bnd");
        this.sink.text("Bnd");
        this.sink.link_();
        this.sink.text(".");
        this.sink.paragraph_();
        this.sink.paragraph();
        this.sink.text(this.getBundle(this.locale).getString("report.baseline.bundle") + " ");
        this.sink.figure();
        this.sink.figureGraphics("images/baseline/bundle.gif");
        this.sink.figure_();
        this.sink.text(" ");
        this.sink.bold();
        this.sink.text(bundleName);
        this.sink.bold_();
        this.sink.listItem_();
        this.sink.paragraph();
        this.sink.text(this.getBundle(this.locale).getString("report.baseline.version.current") + " ");
        this.sink.bold();
        this.sink.text(currentVersion);
        this.sink.bold_();
        this.sink.paragraph_();
        this.sink.paragraph();
        this.sink.text(this.getBundle(this.locale).getString("report.baseline.version.comparison") + " ");
        this.sink.bold();
        this.sink.text(this.comparisonVersion);
        this.sink.bold_();
        this.sink.paragraph_();
        this.sink.paragraph();
        this.sink.text(this.getBundle(this.locale).getString("report.baseline.generationdate") + " ");
        this.sink.bold();
        this.sink.text(generationDate);
        this.sink.bold_();
        this.sink.paragraph_();
        this.sink.section1_();
    }

    @Override
    protected void startPackage(boolean mismatch, String packageName, String shortDelta, String delta, String newerVersion, String olderVersion, String suggestedVersion, DiffMessage diffMessage, Map<String, String> attributes) {
        this.sink.list();
        this.sink.listItem();
        this.sink.figure();
        this.sink.figureGraphics("./images/baseline/package.gif");
        this.sink.figure_();
        this.sink.text(" ");
        this.sink.monospaced();
        this.sink.text(packageName);
        this.sink.monospaced_();
        if (diffMessage != null) {
            this.sink.text(" ");
            this.sink.figure();
            this.sink.figureGraphics("./images/baseline/" + diffMessage.getType().name() + ".gif");
            this.sink.figure_();
            this.sink.text(" ");
            this.sink.italic();
            this.sink.text(diffMessage.getMessage());
            this.sink.italic_();
            this.sink.text(" (newer version: ");
            this.sink.monospaced();
            this.sink.text(newerVersion);
            this.sink.monospaced_();
            this.sink.text(", older version: ");
            this.sink.monospaced();
            this.sink.text(olderVersion);
            this.sink.monospaced_();
            this.sink.text(", suggested version: ");
            this.sink.monospaced();
            this.sink.text(suggestedVersion);
            this.sink.monospaced_();
            this.sink.text(")");
        }
    }

    @Override
    protected void startDiff(int depth, String type, String name, String delta, String shortDelta) {
        if (this.currentDepth < depth) {
            this.sink.list();
        }
        this.currentDepth = depth;
        this.sink.listItem();
        this.sink.figure();
        this.sink.figureGraphics("images/baseline/" + type + ".gif");
        this.sink.figure_();
        this.sink.text(" ");
        this.sink.monospaced();
        this.sink.text(name);
        this.sink.monospaced_();
        this.sink.text(" ");
        this.sink.italic();
        this.sink.text(delta);
        this.sink.italic_();
    }

    @Override
    protected void endDiff(int depth) {
        this.sink.listItem_();
        if (this.currentDepth > depth) {
            this.sink.list_();
        }
        this.currentDepth = depth;
    }

    @Override
    protected void endPackage() {
        if (this.currentDepth > 0) {
            this.sink.list_();
            this.currentDepth = 0;
        }
        this.sink.listItem_();
        this.sink.list_();
    }

    @Override
    protected void endBaseline() {
        this.sink.body_();
        this.sink.flush();
        this.sink.close();
    }

    public boolean canGenerateReport() {
        return !this.skip && this.outputDirectory != null;
    }

    public void generate(org.codehaus.doxia.sink.Sink sink, Locale locale) throws MavenReportException {
        this.sink = sink;
        this.locale = locale;
        try {
            this.execute();
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"An error occurred while producing the report page, see nested exceptions", (Throwable)e);
        }
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.baseline.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.baseline.name");
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("baseline-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public String getOutputName() {
        return "baseline-report";
    }

    public File getReportOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isExternalReport() {
        return false;
    }

    public void setReportOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }
}

