/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.api.connector.sink.GlobalCommitter;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.api.connector.sink.SinkWriter;
import org.apache.flink.connector.file.sink.FileSinkCommittable;
import org.apache.flink.connector.file.sink.FileSinkCommittableSerializer;
import org.apache.flink.connector.file.sink.committer.FileCommitter;
import org.apache.flink.connector.file.sink.writer.DefaultFileWriterBucketFactory;
import org.apache.flink.connector.file.sink.writer.FileWriter;
import org.apache.flink.connector.file.sink.writer.FileWriterBucketFactory;
import org.apache.flink.connector.file.sink.writer.FileWriterBucketState;
import org.apache.flink.connector.file.sink.writer.FileWriterBucketStateSerializer;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.BulkBucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputFileConfig;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.RowWiseBucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.DateTimeBucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.CheckpointRollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.DefaultRollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.OnCheckpointRollingPolicy;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

@Experimental
public class FileSink<IN>
implements Sink<IN, FileSinkCommittable, FileWriterBucketState, Void> {
    private final BucketsBuilder<IN, ? extends BucketsBuilder<IN, ?>> bucketsBuilder;

    private FileSink(BucketsBuilder<IN, ? extends BucketsBuilder<IN, ?>> bucketsBuilder) {
        this.bucketsBuilder = (BucketsBuilder)Preconditions.checkNotNull(bucketsBuilder);
    }

    public SinkWriter<IN, FileSinkCommittable, FileWriterBucketState> createWriter(Sink.InitContext context, List<FileWriterBucketState> states) throws IOException {
        FileWriter<IN> writer = this.bucketsBuilder.createWriter(context);
        writer.initializeState(states);
        return writer;
    }

    public Optional<SimpleVersionedSerializer<FileWriterBucketState>> getWriterStateSerializer() {
        try {
            return Optional.of(this.bucketsBuilder.getWriterStateSerializer());
        }
        catch (IOException e) {
            throw new FlinkRuntimeException("Could not create writer state serializer.", (Throwable)e);
        }
    }

    public Optional<Committer<FileSinkCommittable>> createCommitter() throws IOException {
        return Optional.of(this.bucketsBuilder.createCommitter());
    }

    public Optional<SimpleVersionedSerializer<FileSinkCommittable>> getCommittableSerializer() {
        try {
            return Optional.of(this.bucketsBuilder.getCommittableSerializer());
        }
        catch (IOException e) {
            throw new FlinkRuntimeException("Could not create committable serializer.", (Throwable)e);
        }
    }

    public Optional<GlobalCommitter<FileSinkCommittable, Void>> createGlobalCommitter() {
        return Optional.empty();
    }

    public Optional<SimpleVersionedSerializer<Void>> getGlobalCommittableSerializer() {
        return Optional.empty();
    }

    public Collection<String> getCompatibleStateNames() {
        return Collections.singleton("bucket-states");
    }

    public static <IN> DefaultRowFormatBuilder<IN> forRowFormat(Path basePath, Encoder<IN> encoder) {
        return new DefaultRowFormatBuilder(basePath, encoder, (BucketAssigner)new DateTimeBucketAssigner());
    }

    public static <IN> DefaultBulkFormatBuilder<IN> forBulkFormat(Path basePath, BulkWriter.Factory<IN> bulkWriterFactory) {
        return new DefaultBulkFormatBuilder(basePath, bulkWriterFactory, (BucketAssigner)new DateTimeBucketAssigner());
    }

    public static final class DefaultBulkFormatBuilder<IN>
    extends BulkFormatBuilder<IN, DefaultBulkFormatBuilder<IN>> {
        private static final long serialVersionUID = 7493169281036370228L;

        private DefaultBulkFormatBuilder(Path basePath, BulkWriter.Factory<IN> writerFactory, BucketAssigner<IN, String> assigner) {
            super(basePath, writerFactory, assigner);
        }
    }

    @PublicEvolving
    public static class BulkFormatBuilder<IN, T extends BulkFormatBuilder<IN, T>>
    extends BucketsBuilder<IN, T> {
        private static final long serialVersionUID = 1L;
        private final Path basePath;
        private long bucketCheckInterval;
        private final BulkWriter.Factory<IN> writerFactory;
        private final FileWriterBucketFactory<IN> bucketFactory;
        private BucketAssigner<IN, String> bucketAssigner;
        private CheckpointRollingPolicy<IN, String> rollingPolicy;
        private OutputFileConfig outputFileConfig;

        protected BulkFormatBuilder(Path basePath, BulkWriter.Factory<IN> writerFactory, BucketAssigner<IN, String> assigner) {
            this(basePath, 60000L, writerFactory, assigner, (CheckpointRollingPolicy<IN, String>)OnCheckpointRollingPolicy.build(), new DefaultFileWriterBucketFactory(), OutputFileConfig.builder().build());
        }

        protected BulkFormatBuilder(Path basePath, long bucketCheckInterval, BulkWriter.Factory<IN> writerFactory, BucketAssigner<IN, String> assigner, CheckpointRollingPolicy<IN, String> policy, FileWriterBucketFactory<IN> bucketFactory, OutputFileConfig outputFileConfig) {
            this.basePath = (Path)Preconditions.checkNotNull((Object)basePath);
            this.bucketCheckInterval = bucketCheckInterval;
            this.writerFactory = writerFactory;
            this.bucketAssigner = (BucketAssigner)Preconditions.checkNotNull(assigner);
            this.rollingPolicy = (CheckpointRollingPolicy)Preconditions.checkNotNull(policy);
            this.bucketFactory = (FileWriterBucketFactory)Preconditions.checkNotNull(bucketFactory);
            this.outputFileConfig = (OutputFileConfig)Preconditions.checkNotNull((Object)outputFileConfig);
        }

        public T withBucketCheckInterval(long interval) {
            this.bucketCheckInterval = interval;
            return (T)((BulkFormatBuilder)this.self());
        }

        public T withBucketAssigner(BucketAssigner<IN, String> assigner) {
            this.bucketAssigner = (BucketAssigner)Preconditions.checkNotNull(assigner);
            return (T)((BulkFormatBuilder)this.self());
        }

        public T withRollingPolicy(CheckpointRollingPolicy<IN, String> rollingPolicy) {
            this.rollingPolicy = (CheckpointRollingPolicy)Preconditions.checkNotNull(rollingPolicy);
            return (T)((BulkFormatBuilder)this.self());
        }

        public T withOutputFileConfig(OutputFileConfig outputFileConfig) {
            this.outputFileConfig = outputFileConfig;
            return (T)((BulkFormatBuilder)this.self());
        }

        public BulkFormatBuilder<IN, ? extends BulkFormatBuilder<IN, ?>> withNewBucketAssigner(BucketAssigner<IN, String> assigner) {
            Preconditions.checkState((this.bucketFactory.getClass() == DefaultFileWriterBucketFactory.class ? 1 : 0) != 0, (Object)"newBuilderWithBucketAssigner() cannot be called after specifying a customized bucket factory");
            return new BulkFormatBuilder<IN, T>(this.basePath, this.bucketCheckInterval, this.writerFactory, (BucketAssigner)Preconditions.checkNotNull(assigner), this.rollingPolicy, this.bucketFactory, this.outputFileConfig);
        }

        public FileSink<IN> build() {
            return new FileSink(this);
        }

        @Override
        FileWriter<IN> createWriter(Sink.InitContext context) throws IOException {
            return new FileWriter<IN>(this.basePath, this.bucketAssigner, this.bucketFactory, this.createBucketWriter(), this.rollingPolicy, this.outputFileConfig, context.getProcessingTimeService(), this.bucketCheckInterval);
        }

        @Override
        FileCommitter createCommitter() throws IOException {
            return new FileCommitter(this.createBucketWriter());
        }

        @Override
        SimpleVersionedSerializer<FileWriterBucketState> getWriterStateSerializer() throws IOException {
            BucketWriter<IN, String> bucketWriter = this.createBucketWriter();
            return new FileWriterBucketStateSerializer((SimpleVersionedSerializer<InProgressFileWriter.InProgressFileRecoverable>)bucketWriter.getProperties().getInProgressFileRecoverableSerializer(), (SimpleVersionedSerializer<InProgressFileWriter.PendingFileRecoverable>)bucketWriter.getProperties().getPendingFileRecoverableSerializer());
        }

        @Override
        SimpleVersionedSerializer<FileSinkCommittable> getCommittableSerializer() throws IOException {
            BucketWriter<IN, String> bucketWriter = this.createBucketWriter();
            return new FileSinkCommittableSerializer((SimpleVersionedSerializer<InProgressFileWriter.PendingFileRecoverable>)bucketWriter.getProperties().getPendingFileRecoverableSerializer(), (SimpleVersionedSerializer<InProgressFileWriter.InProgressFileRecoverable>)bucketWriter.getProperties().getInProgressFileRecoverableSerializer());
        }

        private BucketWriter<IN, String> createBucketWriter() throws IOException {
            return new BulkBucketWriter(FileSystem.get((URI)this.basePath.toUri()).createRecoverableWriter(), this.writerFactory);
        }
    }

    public static final class DefaultRowFormatBuilder<IN>
    extends RowFormatBuilder<IN, DefaultRowFormatBuilder<IN>> {
        private static final long serialVersionUID = -8503344257202146718L;

        private DefaultRowFormatBuilder(Path basePath, Encoder<IN> encoder, BucketAssigner<IN, String> bucketAssigner) {
            super(basePath, encoder, bucketAssigner);
        }
    }

    public static class RowFormatBuilder<IN, T extends RowFormatBuilder<IN, T>>
    extends BucketsBuilder<IN, T> {
        private static final long serialVersionUID = 1L;
        private final Path basePath;
        private long bucketCheckInterval;
        private final Encoder<IN> encoder;
        private final FileWriterBucketFactory<IN> bucketFactory;
        private BucketAssigner<IN, String> bucketAssigner;
        private RollingPolicy<IN, String> rollingPolicy;
        private OutputFileConfig outputFileConfig;

        protected RowFormatBuilder(Path basePath, Encoder<IN> encoder, BucketAssigner<IN, String> bucketAssigner) {
            this(basePath, 60000L, encoder, bucketAssigner, (RollingPolicy<IN, String>)DefaultRollingPolicy.builder().build(), new DefaultFileWriterBucketFactory(), OutputFileConfig.builder().build());
        }

        protected RowFormatBuilder(Path basePath, long bucketCheckInterval, Encoder<IN> encoder, BucketAssigner<IN, String> assigner, RollingPolicy<IN, String> policy, FileWriterBucketFactory<IN> bucketFactory, OutputFileConfig outputFileConfig) {
            this.basePath = (Path)Preconditions.checkNotNull((Object)basePath);
            this.bucketCheckInterval = bucketCheckInterval;
            this.encoder = (Encoder)Preconditions.checkNotNull(encoder);
            this.bucketAssigner = (BucketAssigner)Preconditions.checkNotNull(assigner);
            this.rollingPolicy = (RollingPolicy)Preconditions.checkNotNull(policy);
            this.bucketFactory = (FileWriterBucketFactory)Preconditions.checkNotNull(bucketFactory);
            this.outputFileConfig = (OutputFileConfig)Preconditions.checkNotNull((Object)outputFileConfig);
        }

        public T withBucketCheckInterval(long interval) {
            this.bucketCheckInterval = interval;
            return (T)((RowFormatBuilder)this.self());
        }

        public T withBucketAssigner(BucketAssigner<IN, String> assigner) {
            this.bucketAssigner = (BucketAssigner)Preconditions.checkNotNull(assigner);
            return (T)((RowFormatBuilder)this.self());
        }

        public T withRollingPolicy(RollingPolicy<IN, String> policy) {
            this.rollingPolicy = (RollingPolicy)Preconditions.checkNotNull(policy);
            return (T)((RowFormatBuilder)this.self());
        }

        public T withOutputFileConfig(OutputFileConfig outputFileConfig) {
            this.outputFileConfig = outputFileConfig;
            return (T)((RowFormatBuilder)this.self());
        }

        public FileSink<IN> build() {
            return new FileSink(this);
        }

        @Override
        FileWriter<IN> createWriter(Sink.InitContext context) throws IOException {
            return new FileWriter<IN>(this.basePath, this.bucketAssigner, this.bucketFactory, this.createBucketWriter(), this.rollingPolicy, this.outputFileConfig, context.getProcessingTimeService(), this.bucketCheckInterval);
        }

        @Override
        FileCommitter createCommitter() throws IOException {
            return new FileCommitter(this.createBucketWriter());
        }

        @Override
        SimpleVersionedSerializer<FileWriterBucketState> getWriterStateSerializer() throws IOException {
            BucketWriter<IN, String> bucketWriter = this.createBucketWriter();
            return new FileWriterBucketStateSerializer((SimpleVersionedSerializer<InProgressFileWriter.InProgressFileRecoverable>)bucketWriter.getProperties().getInProgressFileRecoverableSerializer(), (SimpleVersionedSerializer<InProgressFileWriter.PendingFileRecoverable>)bucketWriter.getProperties().getPendingFileRecoverableSerializer());
        }

        @Override
        SimpleVersionedSerializer<FileSinkCommittable> getCommittableSerializer() throws IOException {
            BucketWriter<IN, String> bucketWriter = this.createBucketWriter();
            return new FileSinkCommittableSerializer((SimpleVersionedSerializer<InProgressFileWriter.PendingFileRecoverable>)bucketWriter.getProperties().getPendingFileRecoverableSerializer(), (SimpleVersionedSerializer<InProgressFileWriter.InProgressFileRecoverable>)bucketWriter.getProperties().getInProgressFileRecoverableSerializer());
        }

        private BucketWriter<IN, String> createBucketWriter() throws IOException {
            return new RowWiseBucketWriter(FileSystem.get((URI)this.basePath.toUri()).createRecoverableWriter(), this.encoder);
        }
    }

    @Internal
    private static abstract class BucketsBuilder<IN, T extends BucketsBuilder<IN, T>>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected static final long DEFAULT_BUCKET_CHECK_INTERVAL = 60000L;

        private BucketsBuilder() {
        }

        protected T self() {
            return (T)this;
        }

        @Internal
        abstract FileWriter<IN> createWriter(Sink.InitContext var1) throws IOException;

        @Internal
        abstract FileCommitter createCommitter() throws IOException;

        @Internal
        abstract SimpleVersionedSerializer<FileWriterBucketState> getWriterStateSerializer() throws IOException;

        @Internal
        abstract SimpleVersionedSerializer<FileSinkCommittable> getCommittableSerializer() throws IOException;
    }
}

