/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.enumerable.EnumerableFilter;
import org.apache.calcite.adapter.enumerable.EnumerableProject;
import org.apache.calcite.adapter.enumerable.EnumerableSort;
import org.apache.calcite.adapter.enumerable.EnumerableTableScan;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.validate.SqlValidatorUtil;

public class EnumerableRelFactories {
    public static final RelFactories.TableScanFactory ENUMERABLE_TABLE_SCAN_FACTORY = new TableScanFactoryImpl();
    public static final RelFactories.ProjectFactory ENUMERABLE_PROJECT_FACTORY = new ProjectFactoryImpl();
    public static final RelFactories.FilterFactory ENUMERABLE_FILTER_FACTORY = new FilterFactoryImpl();
    public static final RelFactories.SortFactory ENUMERABLE_SORT_FACTORY = new SortFactoryImpl();

    private EnumerableRelFactories() {
    }

    private static class SortFactoryImpl
    implements RelFactories.SortFactory {
        private SortFactoryImpl() {
        }

        @Override
        public RelNode createSort(RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
            return EnumerableSort.create(input, collation, offset, fetch);
        }
    }

    private static class FilterFactoryImpl
    implements RelFactories.FilterFactory {
        private FilterFactoryImpl() {
        }

        @Override
        public RelNode createFilter(RelNode input, RexNode condition, Set<CorrelationId> variablesSet) {
            return EnumerableFilter.create(input, condition);
        }
    }

    private static class ProjectFactoryImpl
    implements RelFactories.ProjectFactory {
        private ProjectFactoryImpl() {
        }

        @Override
        public RelNode createProject(RelNode input, List<RelHint> hints, List<? extends RexNode> childExprs, List<String> fieldNames) {
            RelDataType rowType = RexUtil.createStructType(input.getCluster().getTypeFactory(), childExprs, fieldNames, SqlValidatorUtil.F_SUGGESTER);
            return EnumerableProject.create(input, childExprs, rowType);
        }
    }

    private static class TableScanFactoryImpl
    implements RelFactories.TableScanFactory {
        private TableScanFactoryImpl() {
        }

        @Override
        public RelNode createScan(RelOptTable.ToRelContext toRelContext, RelOptTable table) {
            return EnumerableTableScan.create(toRelContext.getCluster(), table);
        }
    }
}

