/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.config;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.calcite.avatica.ConnectionConfigImpl;
import org.apache.calcite.avatica.ConnectionProperty;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.config.Lex;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.model.JsonSchema;
import org.apache.calcite.sql.validate.SqlConformanceEnum;

public enum CalciteConnectionProperty implements ConnectionProperty
{
    APPROXIMATE_DISTINCT_COUNT("approximateDistinctCount", ConnectionProperty.Type.BOOLEAN, false, false),
    APPROXIMATE_TOP_N("approximateTopN", ConnectionProperty.Type.BOOLEAN, false, false),
    APPROXIMATE_DECIMAL("approximateDecimal", ConnectionProperty.Type.BOOLEAN, false, false),
    NULL_EQUAL_TO_EMPTY("nullEqualToEmpty", ConnectionProperty.Type.BOOLEAN, true, false),
    AUTO_TEMP("autoTemp", ConnectionProperty.Type.BOOLEAN, false, false),
    MATERIALIZATIONS_ENABLED("materializationsEnabled", ConnectionProperty.Type.BOOLEAN, true, false),
    CREATE_MATERIALIZATIONS("createMaterializations", ConnectionProperty.Type.BOOLEAN, true, false),
    DEFAULT_NULL_COLLATION("defaultNullCollation", ConnectionProperty.Type.ENUM, (Object)((Object)NullCollation.HIGH), true, NullCollation.class),
    DRUID_FETCH("druidFetch", ConnectionProperty.Type.NUMBER, 16384, false),
    MODEL("model", ConnectionProperty.Type.STRING, null, false),
    LEX("lex", ConnectionProperty.Type.ENUM, (Object)((Object)Lex.ORACLE), false),
    FUN("fun", ConnectionProperty.Type.STRING, "standard", true),
    QUOTING("quoting", ConnectionProperty.Type.ENUM, null, false, Quoting.class),
    QUOTED_CASING("quotedCasing", ConnectionProperty.Type.ENUM, null, false, Casing.class),
    UNQUOTED_CASING("unquotedCasing", ConnectionProperty.Type.ENUM, null, false, Casing.class),
    CASE_SENSITIVE("caseSensitive", ConnectionProperty.Type.BOOLEAN, null, false),
    PARSER_FACTORY("parserFactory", ConnectionProperty.Type.PLUGIN, null, false),
    SCHEMA("schema", ConnectionProperty.Type.STRING, null, false),
    SCHEMA_FACTORY("schemaFactory", ConnectionProperty.Type.PLUGIN, null, false),
    SCHEMA_TYPE("schemaType", ConnectionProperty.Type.ENUM, null, false, JsonSchema.Type.class),
    SPARK("spark", ConnectionProperty.Type.BOOLEAN, false, false),
    TIME_ZONE("timeZone", ConnectionProperty.Type.STRING, TimeZone.getDefault().getID(), false),
    LOCALE("locale", ConnectionProperty.Type.STRING, Locale.ROOT.toString(), false),
    FORCE_DECORRELATE("forceDecorrelate", ConnectionProperty.Type.BOOLEAN, true, false),
    TYPE_SYSTEM("typeSystem", ConnectionProperty.Type.PLUGIN, null, false),
    CONFORMANCE("conformance", ConnectionProperty.Type.ENUM, SqlConformanceEnum.DEFAULT, false),
    TYPE_COERCION("typeCoercion", ConnectionProperty.Type.BOOLEAN, true, false),
    LENIENT_OPERATOR_LOOKUP("lenientOperatorLookup", ConnectionProperty.Type.BOOLEAN, false, false),
    TOPDOWN_OPT("topDownOpt", ConnectionProperty.Type.BOOLEAN, CalciteSystemProperty.TOPDOWN_OPT.value(), false);

    private final String camelName;
    private final ConnectionProperty.Type type;
    private final Object defaultValue;
    private final boolean required;
    private final Class valueClass;
    private static final Map<String, CalciteConnectionProperty> NAME_TO_PROPS;
    @Deprecated
    public static final CalciteConnectionProperty TIMEZONE;

    private CalciteConnectionProperty(String camelName, ConnectionProperty.Type type, Object defaultValue, boolean required) {
        this(camelName, type, defaultValue, required, null);
    }

    private CalciteConnectionProperty(String camelName, ConnectionProperty.Type type, Object defaultValue, boolean required, Class valueClass) {
        this.camelName = camelName;
        this.type = type;
        this.defaultValue = defaultValue;
        this.required = required;
        this.valueClass = type.deduceValueClass(defaultValue, valueClass);
        if (!type.valid(defaultValue, this.valueClass)) {
            throw new AssertionError((Object)camelName);
        }
    }

    @Override
    public String camelName() {
        return this.camelName;
    }

    @Override
    public Object defaultValue() {
        return this.defaultValue;
    }

    @Override
    public ConnectionProperty.Type type() {
        return this.type;
    }

    @Override
    public Class valueClass() {
        return this.valueClass;
    }

    @Override
    public boolean required() {
        return this.required;
    }

    @Override
    public ConnectionConfigImpl.PropEnv wrap(Properties properties) {
        return new ConnectionConfigImpl.PropEnv(ConnectionConfigImpl.parse(properties, NAME_TO_PROPS), this);
    }

    static {
        TIMEZONE = TIME_ZONE;
        NAME_TO_PROPS = new HashMap<String, CalciteConnectionProperty>();
        for (CalciteConnectionProperty p : CalciteConnectionProperty.values()) {
            NAME_TO_PROPS.put(p.camelName.toUpperCase(Locale.ROOT), p);
            NAME_TO_PROPS.put(p.name(), p);
        }
    }
}

