/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.mutable;

import java.util.Objects;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.mutable.MutableRel;
import org.apache.calcite.rel.mutable.MutableRelType;
import org.apache.calcite.rel.mutable.MutableSingleRel;
import org.apache.calcite.rex.RexNode;

public class MutableSort
extends MutableSingleRel {
    public final RelCollation collation;
    public final RexNode offset;
    public final RexNode fetch;

    private MutableSort(MutableRel input, RelCollation collation, RexNode offset, RexNode fetch) {
        super(MutableRelType.SORT, input.rowType, input);
        this.collation = collation;
        this.offset = offset;
        this.fetch = fetch;
    }

    public static MutableSort of(MutableRel input, RelCollation collation, RexNode offset, RexNode fetch) {
        return new MutableSort(input, collation, offset, fetch);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof MutableSort && this.collation.equals(((MutableSort)obj).collation) && Objects.equals(this.offset, ((MutableSort)obj).offset) && Objects.equals(this.fetch, ((MutableSort)obj).fetch) && this.input.equals(((MutableSort)obj).input);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.collation, this.offset, this.fetch);
    }

    @Override
    public StringBuilder digest(StringBuilder buf) {
        buf.append("Sort(collation: ").append(this.collation);
        if (this.offset != null) {
            buf.append(", offset: ").append(this.offset);
        }
        if (this.fetch != null) {
            buf.append(", fetch: ").append(this.fetch);
        }
        return buf.append(")");
    }

    @Override
    public MutableRel clone() {
        return MutableSort.of(this.input.clone(), this.collation, this.offset, this.fetch);
    }
}

