/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;

public class AggregateExtractProjectRule
extends RelRule<Config>
implements TransformationRule {
    public static final AggregateExtractProjectRule SCAN = Config.DEFAULT.toRule();

    protected AggregateExtractProjectRule(Config config) {
        super(config);
    }

    @Deprecated
    public AggregateExtractProjectRule(Class<? extends Aggregate> aggregateClass, Class<? extends RelNode> inputClass, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(aggregateClass, inputClass));
    }

    @Deprecated
    public AggregateExtractProjectRule(RelOptRuleOperand operand, RelBuilderFactory builderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(builderFactory).withOperandSupplier(b -> b.exactly(operand)).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        Object input = call.rel(1);
        ImmutableBitSet.Builder inputFieldsUsed = aggregate.getGroupSet().rebuild();
        for (AggregateCall aggCall2 : aggregate.getAggCallList()) {
            for (int i : aggCall2.getArgList()) {
                inputFieldsUsed.set(i);
            }
            if (aggCall2.filterArg < 0) continue;
            inputFieldsUsed.set(aggCall2.filterArg);
        }
        RelBuilder relBuilder = call.builder().push((RelNode)input);
        ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, aggregate.getInput().getRowType().getFieldCount(), inputFieldsUsed.cardinality());
        int j = 0;
        for (int i : inputFieldsUsed.build()) {
            projects.add(relBuilder.field(i));
            mapping.set(i, j++);
        }
        relBuilder.project(projects);
        ImmutableBitSet newGroupSet = Mappings.apply(mapping, aggregate.getGroupSet());
        List newGroupSets = aggregate.getGroupSets().stream().map(bitSet -> Mappings.apply(mapping, bitSet)).collect(Util.toImmutableList());
        List newAggCallList = aggregate.getAggCallList().stream().map(aggCall -> relBuilder.aggregateCall((AggregateCall)aggCall, mapping)).collect(Util.toImmutableList());
        RelBuilder.GroupKey groupKey = relBuilder.groupKey(newGroupSet, newGroupSets);
        relBuilder.aggregate(groupKey, newAggCallList);
        call.transformTo(relBuilder.build());
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = EMPTY.as(Config.class).withOperandFor(Aggregate.class, LogicalTableScan.class);

        @Override
        default public AggregateExtractProjectRule toRule() {
            return new AggregateExtractProjectRule(this);
        }

        default public Config withOperandFor(Class<? extends Aggregate> aggregateClass, Class<? extends RelNode> inputClass) {
            return this.withOperandSupplier(b0 -> b0.operand(aggregateClass).oneInput(b1 -> b1.operand(inputClass).predicate(r -> !(r instanceof Project)).anyInputs())).as(Config.class);
        }
    }
}

