/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBeans;

public class CoerceInputsRule
extends RelRule<Config>
implements TransformationRule {
    protected CoerceInputsRule(Config config) {
        super(config);
    }

    @Deprecated
    public CoerceInputsRule(Class<? extends RelNode> consumerRelClass, boolean coerceNames) {
        this(Config.DEFAULT.withCoerceNames(coerceNames).withOperandFor(consumerRelClass));
    }

    @Deprecated
    public CoerceInputsRule(Class<? extends RelNode> consumerRelClass, boolean coerceNames, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withCoerceNames(coerceNames).withConsumerRelClass(consumerRelClass));
    }

    @Override
    public Convention getOutConvention() {
        return Convention.NONE;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Object consumerRel = call.rel(0);
        if (consumerRel.getClass() != ((Config)this.config).consumerRelClass()) {
            return;
        }
        List<RelNode> inputs = consumerRel.getInputs();
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>(inputs);
        boolean coerce = false;
        for (int i = 0; i < inputs.size(); ++i) {
            RelDataType expectedType = consumerRel.getExpectedInputRowType(i);
            RelNode input = inputs.get(i);
            RelNode newInput = RelOptUtil.createCastRel(input, expectedType, ((Config)this.config).isCoerceNames());
            if (newInput != input) {
                newInputs.set(i, newInput);
                coerce = true;
            }
            assert (RelOptUtil.areRowTypesEqual(((RelNode)newInputs.get(i)).getRowType(), expectedType, ((Config)this.config).isCoerceNames()));
        }
        if (!coerce) {
            return;
        }
        RelNode newConsumerRel = consumerRel.copy(consumerRel.getTraitSet(), newInputs);
        call.transformTo(newConsumerRel);
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = EMPTY.as(Config.class).withCoerceNames(false).withOperandFor(RelNode.class);

        @Override
        default public CoerceInputsRule toRule() {
            return new CoerceInputsRule(this);
        }

        @ImmutableBeans.Property
        @ImmutableBeans.BooleanDefault(value=false)
        public boolean isCoerceNames();

        public Config withCoerceNames(boolean var1);

        @ImmutableBeans.Property
        public Class<? extends RelNode> consumerRelClass();

        public Config withConsumerRelClass(Class<? extends RelNode> var1);

        default public Config withOperandFor(Class<? extends RelNode> consumerRelClass) {
            return this.withConsumerRelClass(consumerRelClass).withOperandSupplier(b -> b.operand(consumerRelClass).anyInputs()).withDescription("CoerceInputsRule:" + consumerRelClass.getName()).as(Config.class);
        }
    }
}

