/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.validate.AggVisitor;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.util.Util;

class AggFinder
extends AggVisitor {
    AggFinder(SqlOperatorTable opTab, boolean over, boolean aggregate, boolean group, AggFinder delegate, SqlNameMatcher nameMatcher) {
        super(opTab, over, aggregate, group, delegate, nameMatcher);
    }

    public SqlCall findAgg(SqlNode node) {
        try {
            node.accept(this);
            return null;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return (SqlCall)e.getNode();
        }
    }

    public SqlCall findAgg(List<SqlNode> nodes) {
        try {
            for (SqlNode node : nodes) {
                node.accept(this);
            }
            return null;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return (SqlCall)e.getNode();
        }
    }

    @Override
    protected Void found(SqlCall call) {
        throw new Util.FoundOne(call);
    }

    Iterable<SqlCall> findAll(Iterable<SqlNode> nodes) {
        AggIterable aggIterable = new AggIterable(this.opTab, this.over, this.aggregate, this.group, this.delegate, this.nameMatcher);
        for (SqlNode node : nodes) {
            node.accept(aggIterable);
        }
        return aggIterable.calls;
    }

    static class AggIterable
    extends AggVisitor
    implements Iterable<SqlCall> {
        private final List<SqlCall> calls = new ArrayList<SqlCall>();

        AggIterable(SqlOperatorTable opTab, boolean over, boolean aggregate, boolean group, AggFinder delegate, SqlNameMatcher nameMatcher) {
            super(opTab, over, aggregate, group, delegate, nameMatcher);
        }

        @Override
        protected Void found(SqlCall call) {
            this.calls.add(call);
            return null;
        }

        @Override
        @Nonnull
        public Iterator<SqlCall> iterator() {
            return this.calls.iterator();
        }
    }
}

