/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.hive.ddl;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.ddl.SqlAddPartitions;
import org.apache.flink.sql.parser.hive.ddl.HiveDDLUtils;

public class SqlAddHivePartitions
extends SqlAddPartitions {
    private final List<SqlCharStringLiteral> partLocations;

    public SqlAddHivePartitions(SqlParserPos pos, SqlIdentifier tableName, boolean ifNotExists, List<SqlNodeList> partSpecs, List<SqlCharStringLiteral> partLocations) {
        super(pos, tableName, ifNotExists, partSpecs, SqlAddHivePartitions.toProps(partLocations));
        for (SqlNodeList spec : partSpecs) {
            HiveDDLUtils.unescapePartitionSpec(spec);
        }
        this.partLocations = partLocations;
    }

    private static List<SqlNodeList> toProps(List<SqlCharStringLiteral> partLocations) {
        ArrayList<SqlNodeList> res = new ArrayList<SqlNodeList>(partLocations.size());
        for (SqlCharStringLiteral partLocation : partLocations) {
            SqlNodeList prop = null;
            if (partLocation != null) {
                prop = new SqlNodeList(partLocation.getParserPosition());
                prop.add(HiveDDLUtils.toTableOption("hive.location-uri", partLocation, partLocation.getParserPosition()));
            }
            res.add(prop);
        }
        return res;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ALTER TABLE");
        this.tableIdentifier.unparse(writer, leftPrec, rightPrec);
        writer.newlineAndIndent();
        writer.keyword("ADD");
        if (this.ifNotExists()) {
            writer.keyword("IF NOT EXISTS");
        }
        int opLeftPrec = this.getOperator().getLeftPrec();
        int opRightPrec = this.getOperator().getRightPrec();
        for (int i = 0; i < this.getPartSpecs().size(); ++i) {
            writer.newlineAndIndent();
            SqlNodeList partSpec = this.getPartSpecs().get(i);
            writer.keyword("PARTITION");
            partSpec.unparse(writer, opLeftPrec, opRightPrec);
            SqlCharStringLiteral location = this.partLocations.get(i);
            if (location == null) continue;
            writer.keyword("LOCATION");
            location.unparse(writer, opLeftPrec, opRightPrec);
        }
    }
}

