/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;

@Internal
public final class PlannerConfiguration
implements ReadableConfig {
    private final ReadableConfig tableConfig;
    private final ReadableConfig executorConfig;

    PlannerConfiguration(ReadableConfig tableConfig, ReadableConfig executorConfig) {
        this.tableConfig = tableConfig;
        this.executorConfig = executorConfig;
    }

    public <T> T get(ConfigOption<T> option) {
        return (T)this.tableConfig.getOptional(option).orElseGet(() -> this.executorConfig.get(option));
    }

    public <T> Optional<T> getOptional(ConfigOption<T> option) {
        Optional tableValue = this.tableConfig.getOptional(option);
        if (tableValue.isPresent()) {
            return tableValue;
        }
        return this.executorConfig.getOptional(option);
    }
}

