/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.hint.HintStrategyTable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.sql.parser.ddl.SqlAddJar;
import org.apache.flink.sql.parser.ddl.SqlAddPartitions;
import org.apache.flink.sql.parser.ddl.SqlAddReplaceColumns;
import org.apache.flink.sql.parser.ddl.SqlAlterDatabase;
import org.apache.flink.sql.parser.ddl.SqlAlterFunction;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;
import org.apache.flink.sql.parser.ddl.SqlAlterTableAddConstraint;
import org.apache.flink.sql.parser.ddl.SqlAlterTableDropConstraint;
import org.apache.flink.sql.parser.ddl.SqlAlterTableOptions;
import org.apache.flink.sql.parser.ddl.SqlAlterTableRename;
import org.apache.flink.sql.parser.ddl.SqlAlterTableReset;
import org.apache.flink.sql.parser.ddl.SqlAlterView;
import org.apache.flink.sql.parser.ddl.SqlAlterViewAs;
import org.apache.flink.sql.parser.ddl.SqlAlterViewProperties;
import org.apache.flink.sql.parser.ddl.SqlAlterViewRename;
import org.apache.flink.sql.parser.ddl.SqlChangeColumn;
import org.apache.flink.sql.parser.ddl.SqlCreateCatalog;
import org.apache.flink.sql.parser.ddl.SqlCreateDatabase;
import org.apache.flink.sql.parser.ddl.SqlCreateFunction;
import org.apache.flink.sql.parser.ddl.SqlCreateTable;
import org.apache.flink.sql.parser.ddl.SqlCreateView;
import org.apache.flink.sql.parser.ddl.SqlDropCatalog;
import org.apache.flink.sql.parser.ddl.SqlDropDatabase;
import org.apache.flink.sql.parser.ddl.SqlDropFunction;
import org.apache.flink.sql.parser.ddl.SqlDropPartitions;
import org.apache.flink.sql.parser.ddl.SqlDropTable;
import org.apache.flink.sql.parser.ddl.SqlDropView;
import org.apache.flink.sql.parser.ddl.SqlRemoveJar;
import org.apache.flink.sql.parser.ddl.SqlReset;
import org.apache.flink.sql.parser.ddl.SqlSet;
import org.apache.flink.sql.parser.ddl.SqlTableOption;
import org.apache.flink.sql.parser.ddl.SqlUseCatalog;
import org.apache.flink.sql.parser.ddl.SqlUseDatabase;
import org.apache.flink.sql.parser.ddl.SqlUseModules;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.sql.parser.dml.RichSqlInsert;
import org.apache.flink.sql.parser.dml.SqlBeginStatementSet;
import org.apache.flink.sql.parser.dml.SqlEndStatementSet;
import org.apache.flink.sql.parser.dql.SqlLoadModule;
import org.apache.flink.sql.parser.dql.SqlRichDescribeTable;
import org.apache.flink.sql.parser.dql.SqlRichExplain;
import org.apache.flink.sql.parser.dql.SqlShowCatalogs;
import org.apache.flink.sql.parser.dql.SqlShowCreateTable;
import org.apache.flink.sql.parser.dql.SqlShowCurrentCatalog;
import org.apache.flink.sql.parser.dql.SqlShowCurrentDatabase;
import org.apache.flink.sql.parser.dql.SqlShowDatabases;
import org.apache.flink.sql.parser.dql.SqlShowFunctions;
import org.apache.flink.sql.parser.dql.SqlShowJars;
import org.apache.flink.sql.parser.dql.SqlShowModules;
import org.apache.flink.sql.parser.dql.SqlShowPartitions;
import org.apache.flink.sql.parser.dql.SqlShowTables;
import org.apache.flink.sql.parser.dql.SqlShowViews;
import org.apache.flink.sql.parser.dql.SqlUnloadModule;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.CatalogViewImpl;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.operations.BeginStatementSetOperation;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.DescribeTableOperation;
import org.apache.flink.table.operations.EndStatementSetOperation;
import org.apache.flink.table.operations.ExplainOperation;
import org.apache.flink.table.operations.LoadModuleOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ShowCatalogsOperation;
import org.apache.flink.table.operations.ShowCreateTableOperation;
import org.apache.flink.table.operations.ShowCurrentCatalogOperation;
import org.apache.flink.table.operations.ShowCurrentDatabaseOperation;
import org.apache.flink.table.operations.ShowDatabasesOperation;
import org.apache.flink.table.operations.ShowFunctionsOperation;
import org.apache.flink.table.operations.ShowModulesOperation;
import org.apache.flink.table.operations.ShowPartitionsOperation;
import org.apache.flink.table.operations.ShowTablesOperation;
import org.apache.flink.table.operations.ShowViewsOperation;
import org.apache.flink.table.operations.UnloadModuleOperation;
import org.apache.flink.table.operations.UseCatalogOperation;
import org.apache.flink.table.operations.UseDatabaseOperation;
import org.apache.flink.table.operations.UseModulesOperation;
import org.apache.flink.table.operations.command.AddJarOperation;
import org.apache.flink.table.operations.command.RemoveJarOperation;
import org.apache.flink.table.operations.command.ResetOperation;
import org.apache.flink.table.operations.command.SetOperation;
import org.apache.flink.table.operations.command.ShowJarsOperation;
import org.apache.flink.table.operations.ddl.AddPartitionsOperation;
import org.apache.flink.table.operations.ddl.AlterCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.AlterDatabaseOperation;
import org.apache.flink.table.operations.ddl.AlterPartitionPropertiesOperation;
import org.apache.flink.table.operations.ddl.AlterTableAddConstraintOperation;
import org.apache.flink.table.operations.ddl.AlterTableDropConstraintOperation;
import org.apache.flink.table.operations.ddl.AlterTableOptionsOperation;
import org.apache.flink.table.operations.ddl.AlterTableRenameOperation;
import org.apache.flink.table.operations.ddl.AlterViewAsOperation;
import org.apache.flink.table.operations.ddl.AlterViewPropertiesOperation;
import org.apache.flink.table.operations.ddl.AlterViewRenameOperation;
import org.apache.flink.table.operations.ddl.CreateCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateCatalogOperation;
import org.apache.flink.table.operations.ddl.CreateDatabaseOperation;
import org.apache.flink.table.operations.ddl.CreateTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateViewOperation;
import org.apache.flink.table.operations.ddl.DropCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.DropCatalogOperation;
import org.apache.flink.table.operations.ddl.DropDatabaseOperation;
import org.apache.flink.table.operations.ddl.DropPartitionsOperation;
import org.apache.flink.table.operations.ddl.DropTableOperation;
import org.apache.flink.table.operations.ddl.DropTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.DropViewOperation;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.hint.FlinkHints;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.operations.SqlCreateTableConverter;
import org.apache.flink.table.planner.utils.Expander;
import org.apache.flink.table.planner.utils.OperationConverterUtils;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.util.StringUtils;

public class SqlToOperationConverter {
    private final FlinkPlannerImpl flinkPlanner;
    private final CatalogManager catalogManager;
    private final SqlCreateTableConverter createTableConverter;

    private SqlToOperationConverter(FlinkPlannerImpl flinkPlanner, CatalogManager catalogManager) {
        this.flinkPlanner = flinkPlanner;
        this.catalogManager = catalogManager;
        this.createTableConverter = new SqlCreateTableConverter(flinkPlanner.getOrCreateSqlValidator(), catalogManager, this::getQuotedSqlString, this::validateTableConstraint);
    }

    public static Optional<Operation> convert(FlinkPlannerImpl flinkPlanner, CatalogManager catalogManager, SqlNode sqlNode) {
        SqlNode validated = flinkPlanner.validate(sqlNode);
        SqlToOperationConverter converter = new SqlToOperationConverter(flinkPlanner, catalogManager);
        if (validated instanceof SqlCreateCatalog) {
            return Optional.of(converter.convertCreateCatalog((SqlCreateCatalog)validated));
        }
        if (validated instanceof SqlDropCatalog) {
            return Optional.of(converter.convertDropCatalog((SqlDropCatalog)validated));
        }
        if (validated instanceof SqlLoadModule) {
            return Optional.of(converter.convertLoadModule((SqlLoadModule)validated));
        }
        if (validated instanceof SqlShowCatalogs) {
            return Optional.of(converter.convertShowCatalogs((SqlShowCatalogs)validated));
        }
        if (validated instanceof SqlShowCurrentCatalog) {
            return Optional.of(converter.convertShowCurrentCatalog((SqlShowCurrentCatalog)validated));
        }
        if (validated instanceof SqlShowModules) {
            return Optional.of(converter.convertShowModules((SqlShowModules)validated));
        }
        if (validated instanceof SqlUnloadModule) {
            return Optional.of(converter.convertUnloadModule((SqlUnloadModule)validated));
        }
        if (validated instanceof SqlUseCatalog) {
            return Optional.of(converter.convertUseCatalog((SqlUseCatalog)validated));
        }
        if (validated instanceof SqlUseModules) {
            return Optional.of(converter.convertUseModules((SqlUseModules)validated));
        }
        if (validated instanceof SqlCreateDatabase) {
            return Optional.of(converter.convertCreateDatabase((SqlCreateDatabase)validated));
        }
        if (validated instanceof SqlDropDatabase) {
            return Optional.of(converter.convertDropDatabase((SqlDropDatabase)validated));
        }
        if (validated instanceof SqlAlterDatabase) {
            return Optional.of(converter.convertAlterDatabase((SqlAlterDatabase)validated));
        }
        if (validated instanceof SqlShowDatabases) {
            return Optional.of(converter.convertShowDatabases((SqlShowDatabases)validated));
        }
        if (validated instanceof SqlShowCurrentDatabase) {
            return Optional.of(converter.convertShowCurrentDatabase((SqlShowCurrentDatabase)validated));
        }
        if (validated instanceof SqlUseDatabase) {
            return Optional.of(converter.convertUseDatabase((SqlUseDatabase)validated));
        }
        if (validated instanceof SqlCreateTable) {
            return Optional.of(converter.createTableConverter.convertCreateTable((SqlCreateTable)validated));
        }
        if (validated instanceof SqlDropTable) {
            return Optional.of(converter.convertDropTable((SqlDropTable)validated));
        }
        if (validated instanceof SqlAlterTable) {
            return Optional.of(converter.convertAlterTable((SqlAlterTable)validated));
        }
        if (validated instanceof SqlShowTables) {
            return Optional.of(converter.convertShowTables((SqlShowTables)validated));
        }
        if (validated instanceof SqlCreateView) {
            return Optional.of(converter.convertCreateView((SqlCreateView)validated));
        }
        if (validated instanceof SqlDropView) {
            return Optional.of(converter.convertDropView((SqlDropView)validated));
        }
        if (validated instanceof SqlAlterView) {
            return Optional.of(converter.convertAlterView((SqlAlterView)validated));
        }
        if (validated instanceof SqlShowViews) {
            return Optional.of(converter.convertShowViews((SqlShowViews)validated));
        }
        if (validated instanceof SqlCreateFunction) {
            return Optional.of(converter.convertCreateFunction((SqlCreateFunction)validated));
        }
        if (validated instanceof SqlDropFunction) {
            return Optional.of(converter.convertDropFunction((SqlDropFunction)validated));
        }
        if (validated instanceof SqlAlterFunction) {
            return Optional.of(converter.convertAlterFunction((SqlAlterFunction)validated));
        }
        if (validated instanceof SqlShowCreateTable) {
            return Optional.of(converter.convertShowCreateTable((SqlShowCreateTable)validated));
        }
        if (validated instanceof SqlShowFunctions) {
            return Optional.of(converter.convertShowFunctions((SqlShowFunctions)validated));
        }
        if (validated instanceof SqlShowPartitions) {
            return Optional.of(converter.convertShowPartitions((SqlShowPartitions)validated));
        }
        if (validated instanceof SqlRichExplain) {
            return Optional.of(converter.convertRichExplain((SqlRichExplain)validated));
        }
        if (validated instanceof SqlRichDescribeTable) {
            return Optional.of(converter.convertDescribeTable((SqlRichDescribeTable)validated));
        }
        if (validated instanceof SqlAddJar) {
            return Optional.of(converter.convertAddJar((SqlAddJar)validated));
        }
        if (validated instanceof SqlRemoveJar) {
            return Optional.of(converter.convertRemoveJar((SqlRemoveJar)validated));
        }
        if (validated instanceof SqlShowJars) {
            return Optional.of(converter.convertShowJars((SqlShowJars)validated));
        }
        if (validated instanceof RichSqlInsert) {
            return Optional.of(converter.convertSqlInsert((RichSqlInsert)validated));
        }
        if (validated instanceof SqlBeginStatementSet) {
            return Optional.of(converter.convertBeginStatementSet((SqlBeginStatementSet)validated));
        }
        if (validated instanceof SqlEndStatementSet) {
            return Optional.of(converter.convertEndStatementSet((SqlEndStatementSet)validated));
        }
        if (validated instanceof SqlSet) {
            return Optional.of(converter.convertSet((SqlSet)validated));
        }
        if (validated instanceof SqlReset) {
            return Optional.of(converter.convertReset((SqlReset)validated));
        }
        if (validated.getKind().belongsTo(SqlKind.QUERY)) {
            return Optional.of(converter.convertSqlQuery(validated));
        }
        return Optional.empty();
    }

    private Operation convertDropTable(SqlDropTable sqlDropTable) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlDropTable.fullTableName());
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new DropTableOperation(identifier, sqlDropTable.getIfExists(), sqlDropTable.isTemporary());
    }

    private Operation convertAlterView(SqlAlterView alterView) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])alterView.fullViewName());
        ObjectIdentifier viewIdentifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        Optional optionalCatalogTable = this.catalogManager.getTable(viewIdentifier);
        if (!optionalCatalogTable.isPresent() || ((CatalogManager.TableLookupResult)optionalCatalogTable.get()).isTemporary()) {
            throw new ValidationException(String.format("View %s doesn't exist or is a temporary view.", viewIdentifier.toString()));
        }
        CatalogBaseTable baseTable = ((CatalogManager.TableLookupResult)optionalCatalogTable.get()).getTable();
        if (baseTable instanceof CatalogTable) {
            throw new ValidationException("ALTER VIEW for a table is not allowed");
        }
        if (alterView instanceof SqlAlterViewRename) {
            UnresolvedIdentifier newUnresolvedIdentifier = UnresolvedIdentifier.of((String[])((SqlAlterViewRename)alterView).fullNewViewName());
            ObjectIdentifier newTableIdentifier = this.catalogManager.qualifyIdentifier(newUnresolvedIdentifier);
            return new AlterViewRenameOperation(viewIdentifier, newTableIdentifier);
        }
        if (alterView instanceof SqlAlterViewProperties) {
            SqlAlterViewProperties alterViewProperties = (SqlAlterViewProperties)alterView;
            CatalogView oldView = (CatalogView)baseTable;
            HashMap<String, String> newProperties = new HashMap<String, String>(oldView.getOptions());
            newProperties.putAll(OperationConverterUtils.extractProperties(alterViewProperties.getPropertyList()));
            CatalogViewImpl newView = new CatalogViewImpl(oldView.getOriginalQuery(), oldView.getExpandedQuery(), oldView.getSchema(), newProperties, oldView.getComment());
            return new AlterViewPropertiesOperation(viewIdentifier, (CatalogView)newView);
        }
        if (alterView instanceof SqlAlterViewAs) {
            SqlAlterViewAs alterViewAs = (SqlAlterViewAs)alterView;
            SqlNode newQuery = alterViewAs.getNewQuery();
            CatalogView oldView = (CatalogView)baseTable;
            CatalogView newView = this.convertViewQuery(newQuery, Collections.emptyList(), oldView.getOptions(), oldView.getComment());
            return new AlterViewAsOperation(viewIdentifier, newView);
        }
        throw new ValidationException(String.format("[%s] needs to implement", alterView.toSqlString(CalciteSqlDialect.DEFAULT)));
    }

    private Operation convertAlterTable(SqlAlterTable sqlAlterTable) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlAlterTable.fullTableName());
        ObjectIdentifier tableIdentifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        Optional optionalCatalogTable = this.catalogManager.getTable(tableIdentifier);
        if (!optionalCatalogTable.isPresent() || ((CatalogManager.TableLookupResult)optionalCatalogTable.get()).isTemporary()) {
            throw new ValidationException(String.format("Table %s doesn't exist or is a temporary table.", tableIdentifier.toString()));
        }
        CatalogBaseTable baseTable = ((CatalogManager.TableLookupResult)optionalCatalogTable.get()).getTable();
        if (baseTable instanceof CatalogView) {
            throw new ValidationException("ALTER TABLE for a view is not allowed");
        }
        if (sqlAlterTable instanceof SqlAlterTableRename) {
            UnresolvedIdentifier newUnresolvedIdentifier = UnresolvedIdentifier.of((String[])((SqlAlterTableRename)sqlAlterTable).fullNewTableName());
            ObjectIdentifier newTableIdentifier = this.catalogManager.qualifyIdentifier(newUnresolvedIdentifier);
            return new AlterTableRenameOperation(tableIdentifier, newTableIdentifier);
        }
        if (sqlAlterTable instanceof SqlAlterTableOptions) {
            return this.convertAlterTableOptions(tableIdentifier, (CatalogTable)baseTable, (SqlAlterTableOptions)sqlAlterTable);
        }
        if (sqlAlterTable instanceof SqlAlterTableReset) {
            return this.convertAlterTableReset(tableIdentifier, (CatalogTable)baseTable, (SqlAlterTableReset)sqlAlterTable);
        }
        if (sqlAlterTable instanceof SqlAlterTableAddConstraint) {
            SqlTableConstraint constraint = ((SqlAlterTableAddConstraint)sqlAlterTable).getConstraint();
            this.validateTableConstraint(constraint);
            TableSchema oriSchema = TableSchema.fromResolvedSchema((ResolvedSchema)baseTable.getUnresolvedSchema().resolve(this.catalogManager.getSchemaResolver()));
            TableSchema.Builder builder = TableSchemaUtils.builderWithGivenSchema((TableSchema)oriSchema);
            if (constraint.getConstraintName().isPresent()) {
                builder.primaryKey(constraint.getConstraintName().get(), constraint.getColumnNames());
            } else {
                builder.primaryKey(constraint.getColumnNames());
            }
            builder.build();
            return new AlterTableAddConstraintOperation(tableIdentifier, (String)constraint.getConstraintName().orElse(null), constraint.getColumnNames());
        }
        if (sqlAlterTable instanceof SqlAlterTableDropConstraint) {
            SqlAlterTableDropConstraint dropConstraint = (SqlAlterTableDropConstraint)sqlAlterTable;
            String constraintName = dropConstraint.getConstraintName().getSimple();
            TableSchema oriSchema = TableSchema.fromResolvedSchema((ResolvedSchema)baseTable.getUnresolvedSchema().resolve(this.catalogManager.getSchemaResolver()));
            if (!oriSchema.getPrimaryKey().filter(pk -> pk.getName().equals(constraintName)).isPresent()) {
                throw new ValidationException(String.format("CONSTRAINT [%s] does not exist", constraintName));
            }
            return new AlterTableDropConstraintOperation(tableIdentifier, constraintName);
        }
        if (sqlAlterTable instanceof SqlAddReplaceColumns) {
            return OperationConverterUtils.convertAddReplaceColumns(tableIdentifier, (SqlAddReplaceColumns)sqlAlterTable, (CatalogTable)baseTable, this.flinkPlanner.getOrCreateSqlValidator());
        }
        if (sqlAlterTable instanceof SqlChangeColumn) {
            return OperationConverterUtils.convertChangeColumn(tableIdentifier, (SqlChangeColumn)sqlAlterTable, (CatalogTable)baseTable, this.flinkPlanner.getOrCreateSqlValidator());
        }
        if (sqlAlterTable instanceof SqlAddPartitions) {
            ArrayList<CatalogPartitionSpec> specs = new ArrayList<CatalogPartitionSpec>();
            ArrayList<CatalogPartitionImpl> partitions = new ArrayList<CatalogPartitionImpl>();
            SqlAddPartitions addPartitions = (SqlAddPartitions)sqlAlterTable;
            for (int i = 0; i < addPartitions.getPartSpecs().size(); ++i) {
                specs.add(new CatalogPartitionSpec(addPartitions.getPartitionKVs(i)));
                Map<String, String> props = OperationConverterUtils.extractProperties(addPartitions.getPartProps().get(i));
                partitions.add(new CatalogPartitionImpl(props, null));
            }
            return new AddPartitionsOperation(tableIdentifier, addPartitions.ifNotExists(), specs, partitions);
        }
        if (sqlAlterTable instanceof SqlDropPartitions) {
            SqlDropPartitions dropPartitions = (SqlDropPartitions)sqlAlterTable;
            ArrayList<CatalogPartitionSpec> specs = new ArrayList<CatalogPartitionSpec>();
            for (int i = 0; i < dropPartitions.getPartSpecs().size(); ++i) {
                specs.add(new CatalogPartitionSpec(dropPartitions.getPartitionKVs(i)));
            }
            return new DropPartitionsOperation(tableIdentifier, dropPartitions.ifExists(), specs);
        }
        throw new ValidationException(String.format("[%s] needs to implement", sqlAlterTable.toSqlString(CalciteSqlDialect.DEFAULT)));
    }

    private Operation convertAlterTableOptions(ObjectIdentifier tableIdentifier, CatalogTable oldTable, SqlAlterTableOptions alterTableOptions) {
        LinkedHashMap<String, String> partitionKVs = alterTableOptions.getPartitionKVs();
        if (partitionKVs != null) {
            CatalogPartitionSpec partitionSpec = new CatalogPartitionSpec(partitionKVs);
            CatalogPartition catalogPartition = (CatalogPartition)this.catalogManager.getPartition(tableIdentifier, partitionSpec).orElseThrow(() -> new ValidationException(String.format("Partition %s of table %s doesn't exist", partitionSpec.getPartitionSpec(), tableIdentifier)));
            HashMap<String, String> newProps = new HashMap<String, String>(catalogPartition.getProperties());
            newProps.putAll(OperationConverterUtils.extractProperties(alterTableOptions.getPropertyList()));
            return new AlterPartitionPropertiesOperation(tableIdentifier, partitionSpec, (CatalogPartition)new CatalogPartitionImpl(newProps, catalogPartition.getComment()));
        }
        HashMap<String, String> newOptions = new HashMap<String, String>(oldTable.getOptions());
        newOptions.putAll(OperationConverterUtils.extractProperties(alterTableOptions.getPropertyList()));
        return new AlterTableOptionsOperation(tableIdentifier, oldTable.copy(newOptions));
    }

    private Operation convertAlterTableReset(ObjectIdentifier tableIdentifier, CatalogTable oldTable, SqlAlterTableReset alterTableReset) {
        HashMap newOptions = new HashMap(oldTable.getOptions());
        Set<String> resetKeys = alterTableReset.getResetKeys();
        if (resetKeys.isEmpty()) {
            throw new ValidationException("ALTER TABLE RESET does not support empty key");
        }
        resetKeys.forEach(newOptions::remove);
        return new AlterTableOptionsOperation(tableIdentifier, oldTable.copy(newOptions));
    }

    private Operation convertCreateFunction(SqlCreateFunction sqlCreateFunction) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlCreateFunction.getFunctionIdentifier());
        if (sqlCreateFunction.isSystemFunction()) {
            return new CreateTempSystemFunctionOperation(unresolvedIdentifier.getObjectName(), sqlCreateFunction.getFunctionClassName().getValueAs(String.class), sqlCreateFunction.isIfNotExists(), this.parseLanguage(sqlCreateFunction.getFunctionLanguage()));
        }
        FunctionLanguage language = this.parseLanguage(sqlCreateFunction.getFunctionLanguage());
        CatalogFunctionImpl catalogFunction = new CatalogFunctionImpl(sqlCreateFunction.getFunctionClassName().getValueAs(String.class), language);
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new CreateCatalogFunctionOperation(identifier, (CatalogFunction)catalogFunction, sqlCreateFunction.isIfNotExists(), sqlCreateFunction.isTemporary());
    }

    private Operation convertAlterFunction(SqlAlterFunction sqlAlterFunction) {
        if (sqlAlterFunction.isSystemFunction()) {
            throw new ValidationException("Alter temporary system function is not supported");
        }
        FunctionLanguage language = this.parseLanguage(sqlAlterFunction.getFunctionLanguage());
        CatalogFunctionImpl catalogFunction = new CatalogFunctionImpl(sqlAlterFunction.getFunctionClassName().getValueAs(String.class), language);
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlAlterFunction.getFunctionIdentifier());
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new AlterCatalogFunctionOperation(identifier, (CatalogFunction)catalogFunction, sqlAlterFunction.isIfExists(), sqlAlterFunction.isTemporary());
    }

    private Operation convertDropFunction(SqlDropFunction sqlDropFunction) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlDropFunction.getFunctionIdentifier());
        if (sqlDropFunction.isSystemFunction()) {
            return new DropTempSystemFunctionOperation(unresolvedIdentifier.getObjectName(), sqlDropFunction.getIfExists());
        }
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new DropCatalogFunctionOperation(identifier, sqlDropFunction.getIfExists(), sqlDropFunction.isTemporary());
    }

    private FunctionLanguage parseLanguage(String languageString) {
        FunctionLanguage language;
        if (StringUtils.isNullOrWhitespaceOnly((String)languageString)) {
            return FunctionLanguage.JAVA;
        }
        try {
            language = FunctionLanguage.valueOf((String)languageString);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(String.format("Unrecognized function language string %s", languageString), e);
        }
        return language;
    }

    private Operation convertSqlInsert(RichSqlInsert insert) {
        ImmutableList<String> targetTablePath = ((SqlIdentifier)insert.getTargetTableID()).names;
        HintStrategyTable hintStrategyTable = this.flinkPlanner.config().getSqlToRelConverterConfig().getHintStrategyTable();
        List<RelHint> tableHints = SqlUtil.getRelHint(hintStrategyTable, insert.getTableHints());
        Map<String, String> dynamicOptions = FlinkHints.getHintedOptions(tableHints);
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of(targetTablePath);
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        PlannerQueryOperation query = (PlannerQueryOperation)SqlToOperationConverter.convert(this.flinkPlanner, this.catalogManager, insert.getSource()).orElseThrow(() -> new TableException("Unsupported node type " + insert.getSource().getClass().getSimpleName()));
        return new CatalogSinkModifyOperation(identifier, (QueryOperation)query, insert.getStaticPartitionKVs(), insert.isOverwrite(), dynamicOptions);
    }

    private Operation convertBeginStatementSet(SqlBeginStatementSet sqlBeginStatementSet) {
        return new BeginStatementSetOperation();
    }

    private Operation convertEndStatementSet(SqlEndStatementSet sqlEndStatementSet) {
        return new EndStatementSetOperation();
    }

    private Operation convertUseCatalog(SqlUseCatalog useCatalog) {
        return new UseCatalogOperation(useCatalog.catalogName());
    }

    private Operation convertCreateCatalog(SqlCreateCatalog sqlCreateCatalog) {
        String catalogName = sqlCreateCatalog.catalogName();
        HashMap properties = new HashMap();
        sqlCreateCatalog.getPropertyList().getList().forEach(p -> properties.put(((SqlTableOption)p).getKeyString(), ((SqlTableOption)p).getValueString()));
        return new CreateCatalogOperation(catalogName, properties);
    }

    private Operation convertDropCatalog(SqlDropCatalog sqlDropCatalog) {
        String catalogName = sqlDropCatalog.catalogName();
        return new DropCatalogOperation(catalogName, sqlDropCatalog.getIfExists());
    }

    private Operation convertUseDatabase(SqlUseDatabase useDatabase) {
        String[] fullDatabaseName = useDatabase.fullDatabaseName();
        if (fullDatabaseName.length > 2) {
            throw new ValidationException("use database identifier format error");
        }
        String catalogName = fullDatabaseName.length == 2 ? fullDatabaseName[0] : this.catalogManager.getCurrentCatalog();
        String databaseName = fullDatabaseName.length == 2 ? fullDatabaseName[1] : fullDatabaseName[0];
        return new UseDatabaseOperation(catalogName, databaseName);
    }

    private Operation convertCreateDatabase(SqlCreateDatabase sqlCreateDatabase) {
        String[] fullDatabaseName = sqlCreateDatabase.fullDatabaseName();
        if (fullDatabaseName.length > 2) {
            throw new ValidationException("create database identifier format error");
        }
        String catalogName = fullDatabaseName.length == 1 ? this.catalogManager.getCurrentCatalog() : fullDatabaseName[0];
        String databaseName = fullDatabaseName.length == 1 ? fullDatabaseName[0] : fullDatabaseName[1];
        boolean ignoreIfExists = sqlCreateDatabase.isIfNotExists();
        String databaseComment = sqlCreateDatabase.getComment().map(comment -> comment.getNlsString().getValue()).orElse(null);
        HashMap properties = new HashMap();
        sqlCreateDatabase.getPropertyList().getList().forEach(p -> properties.put(((SqlTableOption)p).getKeyString(), ((SqlTableOption)p).getValueString()));
        CatalogDatabaseImpl catalogDatabase = new CatalogDatabaseImpl(properties, databaseComment);
        return new CreateDatabaseOperation(catalogName, databaseName, (CatalogDatabase)catalogDatabase, ignoreIfExists);
    }

    private Operation convertDropDatabase(SqlDropDatabase sqlDropDatabase) {
        String[] fullDatabaseName = sqlDropDatabase.fullDatabaseName();
        if (fullDatabaseName.length > 2) {
            throw new ValidationException("drop database identifier format error");
        }
        String catalogName = fullDatabaseName.length == 1 ? this.catalogManager.getCurrentCatalog() : fullDatabaseName[0];
        String databaseName = fullDatabaseName.length == 1 ? fullDatabaseName[0] : fullDatabaseName[1];
        return new DropDatabaseOperation(catalogName, databaseName, sqlDropDatabase.getIfExists(), sqlDropDatabase.isCascade());
    }

    private Operation convertAlterDatabase(SqlAlterDatabase sqlAlterDatabase) {
        HashMap properties;
        CatalogDatabase originCatalogDatabase;
        String[] fullDatabaseName = sqlAlterDatabase.fullDatabaseName();
        if (fullDatabaseName.length > 2) {
            throw new ValidationException("alter database identifier format error");
        }
        String catalogName = fullDatabaseName.length == 1 ? this.catalogManager.getCurrentCatalog() : fullDatabaseName[0];
        String databaseName = fullDatabaseName.length == 1 ? fullDatabaseName[0] : fullDatabaseName[1];
        Optional catalog = this.catalogManager.getCatalog(catalogName);
        if (catalog.isPresent()) {
            try {
                originCatalogDatabase = ((Catalog)catalog.get()).getDatabase(databaseName);
                properties = new HashMap(originCatalogDatabase.getProperties());
            }
            catch (DatabaseNotExistException e) {
                throw new ValidationException(String.format("Database %s not exists", databaseName), (Throwable)e);
            }
        } else {
            throw new ValidationException(String.format("Catalog %s not exists", catalogName));
        }
        sqlAlterDatabase.getPropertyList().getList().forEach(p -> properties.put(((SqlTableOption)p).getKeyString(), ((SqlTableOption)p).getValueString()));
        CatalogDatabaseImpl catalogDatabase = new CatalogDatabaseImpl(properties, originCatalogDatabase.getComment());
        return new AlterDatabaseOperation(catalogName, databaseName, (CatalogDatabase)catalogDatabase);
    }

    private Operation convertShowCatalogs(SqlShowCatalogs sqlShowCatalogs) {
        return new ShowCatalogsOperation();
    }

    private Operation convertShowCurrentCatalog(SqlShowCurrentCatalog sqlShowCurrentCatalog) {
        return new ShowCurrentCatalogOperation();
    }

    private Operation convertShowDatabases(SqlShowDatabases sqlShowDatabases) {
        return new ShowDatabasesOperation();
    }

    private Operation convertShowCurrentDatabase(SqlShowCurrentDatabase sqlShowCurrentDatabase) {
        return new ShowCurrentDatabaseOperation();
    }

    private Operation convertShowTables(SqlShowTables sqlShowTables) {
        return new ShowTablesOperation();
    }

    private Operation convertShowCreateTable(SqlShowCreateTable sqlShowCreateTable) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlShowCreateTable.getFullTableName());
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new ShowCreateTableOperation(identifier);
    }

    private Operation convertShowFunctions(SqlShowFunctions sqlShowFunctions) {
        return new ShowFunctionsOperation(sqlShowFunctions.requireUser() ? ShowFunctionsOperation.FunctionScope.USER : ShowFunctionsOperation.FunctionScope.ALL);
    }

    private Operation convertShowPartitions(SqlShowPartitions sqlShowPartitions) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlShowPartitions.fullTableName());
        ObjectIdentifier tableIdentifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        LinkedHashMap<String, String> partitionKVs = sqlShowPartitions.getPartitionKVs();
        if (partitionKVs != null) {
            CatalogPartitionSpec partitionSpec = new CatalogPartitionSpec(partitionKVs);
            return new ShowPartitionsOperation(tableIdentifier, partitionSpec);
        }
        return new ShowPartitionsOperation(tableIdentifier, null);
    }

    private Operation convertCreateView(SqlCreateView sqlCreateView) {
        SqlNode query = sqlCreateView.getQuery();
        SqlNodeList fieldList = sqlCreateView.getFieldList();
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlCreateView.fullViewName());
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        String comment = sqlCreateView.getComment().map(c -> c.getNlsString().getValue()).orElse(null);
        CatalogView catalogView = this.convertViewQuery(query, fieldList.getList(), OperationConverterUtils.extractProperties(sqlCreateView.getProperties().orElse(null)), comment);
        return new CreateViewOperation(identifier, catalogView, sqlCreateView.isIfNotExists(), sqlCreateView.isTemporary());
    }

    private CatalogView convertViewQuery(SqlNode query, List<SqlNode> fieldNames, Map<String, String> props, String comment) {
        String originalQuery = this.getQuotedSqlString(query);
        SqlNode validateQuery = this.flinkPlanner.validate(query);
        String expandedQuery = Expander.create(this.flinkPlanner).expanded(originalQuery).substitute(this::getQuotedSqlString);
        PlannerQueryOperation operation = this.toQueryOperation(this.flinkPlanner, validateQuery);
        ResolvedSchema schema = operation.getResolvedSchema();
        if (!fieldNames.isEmpty()) {
            List inputFieldNames = schema.getColumnNames();
            List aliasFieldNames = fieldNames.stream().map(SqlNode::toString).collect(Collectors.toList());
            if (inputFieldNames.size() != aliasFieldNames.size()) {
                throw new ValidationException(String.format("VIEW definition and input fields not match:\n\tDef fields: %s.\n\tInput fields: %s.", aliasFieldNames, inputFieldNames));
            }
            schema = ResolvedSchema.physical(aliasFieldNames, (List)schema.getColumnDataTypes());
        }
        return CatalogView.of((Schema)Schema.newBuilder().fromResolvedSchema(schema).build(), (String)comment, (String)originalQuery, (String)expandedQuery, props);
    }

    private Operation convertDropView(SqlDropView sqlDropView) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlDropView.fullViewName());
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new DropViewOperation(identifier, sqlDropView.getIfExists(), sqlDropView.isTemporary());
    }

    private Operation convertShowViews(SqlShowViews sqlShowViews) {
        return new ShowViewsOperation();
    }

    private Operation convertRichExplain(SqlRichExplain sqlExplain) {
        Operation operation;
        SqlNode sqlNode = sqlExplain.getStatement();
        Set<String> explainDetails = sqlExplain.getExplainDetails();
        if (sqlNode instanceof RichSqlInsert) {
            operation = this.convertSqlInsert((RichSqlInsert)sqlNode);
        } else if (sqlNode.getKind().belongsTo(SqlKind.QUERY)) {
            operation = this.convertSqlQuery(sqlExplain.getStatement());
        } else {
            throw new ValidationException(String.format("EXPLAIN statement doesn't support %s", sqlNode.getKind().toString()));
        }
        return new ExplainOperation(operation, explainDetails);
    }

    private Operation convertDescribeTable(SqlRichDescribeTable sqlRichDescribeTable) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlRichDescribeTable.fullTableName());
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new DescribeTableOperation(identifier, sqlRichDescribeTable.isExtended());
    }

    private Operation convertLoadModule(SqlLoadModule sqlLoadModule) {
        String moduleName = sqlLoadModule.moduleName();
        HashMap<String, String> properties = new HashMap<String, String>();
        for (SqlNode node : sqlLoadModule.getPropertyList().getList()) {
            SqlTableOption option = (SqlTableOption)node;
            properties.put(option.getKeyString(), option.getValueString());
        }
        return new LoadModuleOperation(moduleName, properties);
    }

    private Operation convertAddJar(SqlAddJar sqlAddJar) {
        return new AddJarOperation(sqlAddJar.getPath());
    }

    private Operation convertRemoveJar(SqlRemoveJar sqlRemoveJar) {
        return new RemoveJarOperation(sqlRemoveJar.getPath());
    }

    private Operation convertShowJars(SqlShowJars sqlShowJars) {
        return new ShowJarsOperation();
    }

    private Operation convertUnloadModule(SqlUnloadModule sqlUnloadModule) {
        String moduleName = sqlUnloadModule.moduleName();
        return new UnloadModuleOperation(moduleName);
    }

    private Operation convertUseModules(SqlUseModules sqlUseModules) {
        return new UseModulesOperation(sqlUseModules.moduleNames());
    }

    private Operation convertShowModules(SqlShowModules sqlShowModules) {
        return new ShowModulesOperation(sqlShowModules.requireFull());
    }

    private Operation convertSet(SqlSet sqlSet) {
        if (sqlSet.getKey() == null && sqlSet.getValue() == null) {
            return new SetOperation();
        }
        return new SetOperation(sqlSet.getKeyString(), sqlSet.getValueString());
    }

    private Operation convertReset(SqlReset sqlReset) {
        return new ResetOperation(sqlReset.getKeyString());
    }

    private Operation convertSqlQuery(SqlNode node) {
        return this.toQueryOperation(this.flinkPlanner, node);
    }

    private void validateTableConstraint(SqlTableConstraint constraint) {
        if (constraint.isUnique()) {
            throw new UnsupportedOperationException("UNIQUE constraint is not supported yet");
        }
        if (constraint.isEnforced()) {
            throw new ValidationException("Flink doesn't support ENFORCED mode for PRIMARY KEY constraint. ENFORCED/NOT ENFORCED  controls if the constraint checks are performed on the incoming/outgoing data. Flink does not own the data therefore the only supported mode is the NOT ENFORCED mode");
        }
    }

    private String getQuotedSqlString(SqlNode sqlNode) {
        SqlParser.Config parserConfig = this.flinkPlanner.config().getParserConfig();
        CalciteSqlDialect dialect = new CalciteSqlDialect(SqlDialect.EMPTY_CONTEXT.withQuotedCasing(parserConfig.unquotedCasing()).withConformance(parserConfig.conformance()).withUnquotedCasing(parserConfig.unquotedCasing()).withIdentifierQuoteString(parserConfig.quoting().string));
        return sqlNode.toSqlString(dialect).getSql();
    }

    private PlannerQueryOperation toQueryOperation(FlinkPlannerImpl planner, SqlNode validated) {
        RelRoot relational = planner.rel(validated);
        return new PlannerQueryOperation(relational.project());
    }
}

