/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.abilities.sink;

import java.util.List;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.abilities.SupportsWritingMetadata;
import org.apache.flink.table.planner.plan.abilities.sink.SinkAbilitySpec;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonSerializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.TypeConversions;

@JsonTypeName(value="WritingMetadata")
public class WritingMetadataSpec
implements SinkAbilitySpec {
    public static final String FIELD_NAME_METADATA_KEYS = "metadataKeys";
    public static final String FIELD_NAME_CONSUMED_TYPE = "consumedType";
    @JsonProperty(value="metadataKeys")
    private final List<String> metadataKeys;
    @JsonProperty(value="consumedType")
    @JsonSerialize(using=LogicalTypeJsonSerializer.class)
    @JsonDeserialize(using=LogicalTypeJsonDeserializer.class)
    private final LogicalType consumedType;

    @JsonCreator
    public WritingMetadataSpec(@JsonProperty(value="metadataKeys") List<String> metadataKeys, @JsonProperty(value="consumedType") LogicalType consumedType) {
        this.metadataKeys = metadataKeys;
        this.consumedType = consumedType;
    }

    @Override
    public void apply(DynamicTableSink tableSink) {
        if (!(tableSink instanceof SupportsWritingMetadata)) {
            throw new TableException(String.format("%s does not support SupportsWritingMetadata.", tableSink.getClass().getName()));
        }
        DataType consumedDataType = TypeConversions.fromLogicalToDataType((LogicalType)this.consumedType);
        ((SupportsWritingMetadata)tableSink).applyWritableMetadata(this.metadataKeys, consumedDataType);
    }
}

