/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.util.TimeString;
import org.apache.flink.table.planner.plan.stats.ValueInterval;
import org.apache.flink.table.planner.plan.stats.ValueInterval$;
import org.apache.flink.table.planner.plan.stats.WithLower;
import org.apache.flink.table.planner.plan.stats.WithUpper;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class SelectivityEstimator$ {
    public static SelectivityEstimator$ MODULE$;

    static {
        new SelectivityEstimator$();
    }

    public ValueInterval convertValueInterval(ValueInterval interval, RelDataType dataType) {
        Predef$.MODULE$.require(interval != null && dataType != null);
        return this.convertValueInterval(interval, dataType.getFamily());
    }

    public ValueInterval convertValueInterval(ValueInterval interval, RelDataTypeFamily typeFamily) {
        ValueInterval valueInterval;
        boolean bl;
        Predef$.MODULE$.require(interval != null && typeFamily != null);
        ValueInterval valueInterval2 = interval;
        ValueInterval valueInterval3 = ValueInterval$.MODULE$.empty();
        ValueInterval valueInterval4 = valueInterval2;
        if (!(valueInterval3 != null ? !valueInterval3.equals(valueInterval4) : valueInterval4 != null)) {
            bl = true;
        } else {
            ValueInterval valueInterval5 = ValueInterval$.MODULE$.infinite();
            ValueInterval valueInterval6 = valueInterval2;
            bl = !(valueInterval5 != null ? !valueInterval5.equals(valueInterval6) : valueInterval6 != null);
        }
        if (bl) {
            valueInterval = interval;
        } else {
            ValueInterval valueInterval7;
            Tuple2 tuple2;
            Tuple2 tuple22;
            ValueInterval valueInterval8 = interval;
            if (valueInterval8 instanceof WithLower) {
                WithLower withLower = (WithLower)valueInterval8;
                tuple22 = new Tuple2(withLower.lower(), (Object)BoxesRunTime.boxToBoolean((boolean)withLower.includeLower()));
            } else {
                tuple22 = new Tuple2(null, (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            Tuple2 tuple23 = tuple22;
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            Comparable lower = (Comparable)tuple23._1();
            boolean includeLower = tuple23._2$mcZ$sp();
            Tuple2 tuple24 = new Tuple2((Object)lower, (Object)BoxesRunTime.boxToBoolean((boolean)includeLower));
            Tuple2 tuple25 = tuple24;
            Comparable lower2 = (Comparable)tuple25._1();
            boolean includeLower2 = tuple25._2$mcZ$sp();
            ValueInterval valueInterval9 = interval;
            if (valueInterval9 instanceof WithUpper) {
                WithUpper withUpper = (WithUpper)valueInterval9;
                tuple2 = new Tuple2(withUpper.upper(), (Object)BoxesRunTime.boxToBoolean((boolean)withUpper.includeUpper()));
            } else {
                tuple2 = new Tuple2(null, (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            Tuple2 tuple26 = tuple2;
            if (tuple26 == null) {
                throw new MatchError((Object)tuple26);
            }
            Comparable upper = (Comparable)tuple26._1();
            boolean includeUpper = tuple26._2$mcZ$sp();
            Tuple2 tuple27 = new Tuple2((Object)upper, (Object)BoxesRunTime.boxToBoolean((boolean)includeUpper));
            Tuple2 tuple28 = tuple27;
            Comparable upper2 = (Comparable)tuple28._1();
            boolean includeUpper2 = tuple28._2$mcZ$sp();
            RelDataTypeFamily relDataTypeFamily = typeFamily;
            boolean bl2 = SqlTypeFamily.NUMERIC.equals(relDataTypeFamily) ? true : (SqlTypeFamily.BOOLEAN.equals(relDataTypeFamily) ? true : (SqlTypeFamily.DATE.equals(relDataTypeFamily) ? true : (SqlTypeFamily.TIME.equals(relDataTypeFamily) ? true : SqlTypeFamily.TIMESTAMP.equals(relDataTypeFamily))));
            if (bl2) {
                valueInterval7 = ValueInterval$.MODULE$.apply(this.comparableToDouble(lower2), this.comparableToDouble(upper2), includeLower2, includeUpper2);
            } else if (SqlTypeFamily.CHARACTER.equals(relDataTypeFamily)) {
                valueInterval7 = ValueInterval$.MODULE$.apply(lower2.toString(), upper2.toString(), includeLower2, includeUpper2);
            } else {
                throw new UnsupportedOperationException(new StringBuilder(24).append("Unsupported typeFamily: ").append(typeFamily).toString());
            }
            valueInterval = valueInterval7;
        }
        return valueInterval;
    }

    public Comparable<?> literalToComparable(RexLiteral literal) {
        Comparable comparable;
        if (!literal.isNull()) {
            Object object;
            RelDataTypeFamily relDataTypeFamily = literal.getType().getFamily();
            boolean bl = SqlTypeFamily.NUMERIC.equals(relDataTypeFamily) ? true : (SqlTypeFamily.BOOLEAN.equals(relDataTypeFamily) ? true : (SqlTypeFamily.DATE.equals(relDataTypeFamily) ? true : (SqlTypeFamily.TIME.equals(relDataTypeFamily) ? true : SqlTypeFamily.TIMESTAMP.equals(relDataTypeFamily))));
            if (bl) {
                object = this.literalToDouble(literal);
            } else if (SqlTypeFamily.CHARACTER.equals(relDataTypeFamily)) {
                object = literal.getValueAs(String.class);
            } else {
                throw new UnsupportedOperationException(new StringBuilder(49).append("Can't get value as comparable from literal type: ").append(literal.getType()).toString());
            }
            comparable = (Comparable)object;
        } else {
            comparable = null;
        }
        return comparable;
    }

    public Double comparableToDouble(Object value) {
        Double d;
        Object object = value;
        if (object == null) {
            d = null;
        } else if (object instanceof Number) {
            Number number2 = (Number)object;
            d = Predef$.MODULE$.double2Double(number2.doubleValue());
        } else if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            d = bl ? Predef$.MODULE$.double2Double(1.0) : Predef$.MODULE$.double2Double(0.0);
        } else if (object instanceof Date) {
            Date date = (Date)object;
            d = date.getTime() / 86400000L;
        } else if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            d = timestamp.getTime();
        } else if (object instanceof Time) {
            Time time = (Time)object;
            d = new TimeString(time.toString()).getMillisOfDay();
        } else {
            throw new UnsupportedOperationException(new StringBuilder(41).append("Can't convert comparable type: ").append(value.getClass()).append(" to Double").toString());
        }
        return d;
    }

    public Double literalToDouble(RexLiteral literal) {
        Double d;
        if (!literal.isNull()) {
            Double d2;
            RelDataTypeFamily relDataTypeFamily = literal.getType().getFamily();
            if (SqlTypeFamily.NUMERIC.equals(relDataTypeFamily)) {
                d2 = Predef$.MODULE$.double2Double(new StringOps(Predef$.MODULE$.augmentString(literal.getValue3().toString())).toDouble());
            } else if (SqlTypeFamily.BOOLEAN.equals(relDataTypeFamily)) {
                d2 = RexLiteral.booleanValue(literal) ? Predef$.MODULE$.double2Double(1.0) : Predef$.MODULE$.double2Double(0.0);
            } else {
                boolean bl = SqlTypeFamily.DATE.equals(relDataTypeFamily) ? true : (SqlTypeFamily.TIME.equals(relDataTypeFamily) ? true : SqlTypeFamily.TIMESTAMP.equals(relDataTypeFamily));
                if (bl) {
                    d2 = Predef$.MODULE$.double2Double(new StringOps(Predef$.MODULE$.augmentString(literal.getValue2().toString())).toDouble());
                } else {
                    throw new UnsupportedOperationException(new StringBuilder(45).append("Can't get value as Double from literal type: ").append(literal.getType()).toString());
                }
            }
            d = d2;
        } else {
            d = null;
        }
        return d;
    }

    public boolean lessThan(Comparable<?> left, Comparable<?> right) {
        return left == null || right == null ? false : left.compareTo(right) < 0;
    }

    public boolean lessThanOrEqualTo(Comparable<?> left, Comparable<?> right) {
        return left == null || right == null ? false : left.compareTo(right) <= 0;
    }

    public boolean greaterThan(Comparable<?> left, Comparable<?> right) {
        return left == null || right == null ? false : left.compareTo(right) > 0;
    }

    public boolean greaterThanOrEqualTo(Comparable<?> left, Comparable<?> right) {
        return left == null || right == null ? false : left.compareTo(right) >= 0;
    }

    public boolean isSupportedComparisonType(RelDataType relType) {
        RelDataTypeFamily relDataTypeFamily = relType.getFamily();
        boolean bl = SqlTypeFamily.NUMERIC.equals(relDataTypeFamily) ? true : (SqlTypeFamily.BOOLEAN.equals(relDataTypeFamily) ? true : (SqlTypeFamily.CHARACTER.equals(relDataTypeFamily) ? true : (SqlTypeFamily.DATE.equals(relDataTypeFamily) ? true : (SqlTypeFamily.TIME.equals(relDataTypeFamily) ? true : SqlTypeFamily.TIMESTAMP.equals(relDataTypeFamily)))));
        boolean bl2 = bl;
        return bl2;
    }

    public boolean canConvertToNumericType(RelDataType relType) {
        RelDataTypeFamily relDataTypeFamily = relType.getFamily();
        boolean bl = SqlTypeFamily.NUMERIC.equals(relDataTypeFamily) ? true : (SqlTypeFamily.BOOLEAN.equals(relDataTypeFamily) ? true : (SqlTypeFamily.DATE.equals(relDataTypeFamily) ? true : (SqlTypeFamily.TIME.equals(relDataTypeFamily) ? true : SqlTypeFamily.TIMESTAMP.equals(relDataTypeFamily))));
        boolean bl2 = bl;
        return bl2;
    }

    private SelectivityEstimator$() {
        MODULE$ = this;
    }
}

