/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Collections;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.runtime.operators.sort.LimitOperator;
import org.apache.flink.table.types.logical.LogicalType;

public class BatchExecLimit
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData> {
    private final long limitStart;
    private final long limitEnd;
    private final boolean isGlobal;

    public BatchExecLimit(long limitStart, long limitEnd, boolean isGlobal, InputProperty inputProperty, LogicalType outputType, String description) {
        super(Collections.singletonList(inputProperty), outputType, description);
        this.isGlobal = isGlobal;
        this.limitStart = limitStart;
        this.limitEnd = limitEnd;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        Transformation<?> inputTransform = this.getInputEdges().get(0).translateToPlan(planner);
        LimitOperator operator = new LimitOperator(this.isGlobal, this.limitStart, this.limitEnd);
        return new OneInputTransformation(inputTransform, this.getDescription(), (StreamOperatorFactory)SimpleOperatorFactory.of((StreamOperator)operator), inputTransform.getOutputType(), inputTransform.getParallelism());
    }
}

