/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.MultipleInputTransformation;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.runtime.operators.multipleinput.BatchMultipleInputStreamOperatorFactory;
import org.apache.flink.table.runtime.operators.multipleinput.TableOperatorWrapperGenerator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;

public class BatchExecMultipleInput
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    private final ExecNode<?> rootNode;

    public BatchExecMultipleInput(List<InputProperty> inputProperties, ExecNode<?> rootNode, String description) {
        super(inputProperties, rootNode.getOutputType(), description);
        this.rootNode = rootNode;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        ArrayList inputTransforms = new ArrayList();
        for (ExecEdge inputEdge : this.getInputEdges()) {
            inputTransforms.add(inputEdge.translateToPlan(planner));
        }
        Transformation outputTransform = this.rootNode.translateToPlan(planner);
        int[] readOrders = this.getInputProperties().stream().map(InputProperty::getPriority).mapToInt(i -> i).toArray();
        TableOperatorWrapperGenerator generator = new TableOperatorWrapperGenerator(inputTransforms, outputTransform, readOrders);
        generator.generate();
        List inputTransformAndInputSpecPairs = generator.getInputTransformAndInputSpecPairs();
        MultipleInputTransformation multipleInputTransform = new MultipleInputTransformation(this.getDescription(), (StreamOperatorFactory)new BatchMultipleInputStreamOperatorFactory(inputTransformAndInputSpecPairs.stream().map(Pair::getValue).collect(Collectors.toList()), generator.getHeadWrappers(), generator.getTailWrapper()), (TypeInformation)InternalTypeInfo.of((LogicalType)this.getOutputType()), generator.getParallelism());
        inputTransformAndInputSpecPairs.forEach(input -> multipleInputTransform.addInput((Transformation)input.getKey()));
        if (generator.getMaxParallelism() > 0) {
            multipleInputTransform.setMaxParallelism(generator.getMaxParallelism());
        }
        multipleInputTransform.setResources(generator.getMinResources(), generator.getPreferredResources());
        int memoryWeight = generator.getManagedMemoryWeight();
        long memoryBytes = (long)memoryWeight << 20;
        ExecNodeUtil.setManagedMemoryWeight(multipleInputTransform, memoryBytes);
        multipleInputTransform.setChainingStrategy(ChainingStrategy.HEAD_WITH_SOURCES);
        return multipleInputTransform;
    }
}

