/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.python.PythonFunctionInfo;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.CommonPythonUtil;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class BatchExecPythonGroupAggregate
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    private static final String ARROW_PYTHON_AGGREGATE_FUNCTION_OPERATOR_NAME = "org.apache.flink.table.runtime.operators.python.aggregate.arrow.batch.BatchArrowPythonGroupAggregateFunctionOperator";
    private final int[] grouping;
    private final int[] auxGrouping;
    private final AggregateCall[] aggCalls;

    public BatchExecPythonGroupAggregate(int[] grouping, int[] auxGrouping, AggregateCall[] aggCalls, InputProperty inputProperty, RowType outputType, String description) {
        super(Collections.singletonList(inputProperty), (LogicalType)outputType, description);
        this.grouping = grouping;
        this.auxGrouping = auxGrouping;
        this.aggCalls = aggCalls;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        RowType outputRowType = InternalTypeInfo.of((LogicalType)this.getOutputType()).toRowType();
        Configuration config = CommonPythonUtil.getMergedConfig(planner.getExecEnv(), planner.getTableConfig());
        OneInputTransformation<RowData, RowData> transform = this.createPythonOneInputTransformation(inputTransform, inputRowType, outputRowType, config);
        if (CommonPythonUtil.isPythonWorkerUsingManagedMemory(config)) {
            transform.declareManagedMemoryUseCaseAtSlotScope(ManagedMemoryUseCase.PYTHON);
        }
        return transform;
    }

    private OneInputTransformation<RowData, RowData> createPythonOneInputTransformation(Transformation<RowData> inputTransform, RowType inputRowType, RowType outputRowType, Configuration config) {
        Tuple2<int[], PythonFunctionInfo[]> aggInfos = CommonPythonUtil.extractPythonAggregateFunctionInfosFromAggregateCall(this.aggCalls);
        int[] pythonUdafInputOffsets = (int[])aggInfos.f0;
        PythonFunctionInfo[] pythonFunctionInfos = (PythonFunctionInfo[])aggInfos.f1;
        OneInputStreamOperator<RowData, RowData> pythonOperator = this.getPythonAggregateFunctionOperator(config, inputRowType, outputRowType, pythonUdafInputOffsets, pythonFunctionInfos);
        return new OneInputTransformation(inputTransform, this.getDescription(), pythonOperator, (TypeInformation)InternalTypeInfo.of((RowType)outputRowType), inputTransform.getParallelism());
    }

    private OneInputStreamOperator<RowData, RowData> getPythonAggregateFunctionOperator(Configuration config, RowType inputRowType, RowType outputRowType, int[] udafInputOffsets, PythonFunctionInfo[] pythonFunctionInfos) {
        Class clazz = CommonPythonUtil.loadClass(ARROW_PYTHON_AGGREGATE_FUNCTION_OPERATOR_NAME);
        try {
            Constructor ctor = clazz.getConstructor(Configuration.class, PythonFunctionInfo[].class, RowType.class, RowType.class, int[].class, int[].class, int[].class);
            return (OneInputStreamOperator)ctor.newInstance(config, pythonFunctionInfos, inputRowType, outputRowType, this.grouping, this.auxGrouping, udafInputOffsets);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TableException("Python BatchArrowPythonGroupAggregateFunctionOperator constructed failed.", (Throwable)e);
        }
    }
}

