/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Arrays;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator;
import org.apache.flink.table.planner.codegen.sort.SortCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.spec.SortSpec;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.JoinUtil;
import org.apache.flink.table.planner.plan.utils.SortUtil;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.SortMergeJoinOperator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class BatchExecSortMergeJoin
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    private final FlinkJoinType joinType;
    private final int[] leftKeys;
    private final int[] rightKeys;
    private final boolean[] filterNulls;
    @Nullable
    private final RexNode nonEquiCondition;
    private final boolean leftIsSmaller;

    public BatchExecSortMergeJoin(FlinkJoinType joinType, int[] leftKeys, int[] rightKeys, boolean[] filterNulls, @Nullable RexNode nonEquiCondition, boolean leftIsSmaller, InputProperty leftInputProperty, InputProperty rightInputProperty, RowType outputType, String description) {
        super(Arrays.asList(leftInputProperty, rightInputProperty), (LogicalType)outputType, description);
        this.joinType = (FlinkJoinType)Preconditions.checkNotNull((Object)joinType);
        this.leftKeys = (int[])Preconditions.checkNotNull((Object)leftKeys);
        this.rightKeys = (int[])Preconditions.checkNotNull((Object)rightKeys);
        this.filterNulls = (boolean[])Preconditions.checkNotNull((Object)filterNulls);
        Preconditions.checkArgument((leftKeys.length > 0 && leftKeys.length == rightKeys.length ? 1 : 0) != 0);
        Preconditions.checkArgument((leftKeys.length == filterNulls.length ? 1 : 0) != 0);
        this.nonEquiCondition = nonEquiCondition;
        this.leftIsSmaller = leftIsSmaller;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        ExecEdge leftInputEdge = this.getInputEdges().get(0);
        ExecEdge rightInputEdge = this.getInputEdges().get(1);
        RowType leftType = (RowType)leftInputEdge.getOutputType();
        RowType rightType = (RowType)rightInputEdge.getOutputType();
        LogicalType[] keyFieldTypes = (LogicalType[])IntStream.of(this.leftKeys).mapToObj(arg_0 -> ((RowType)leftType).getTypeAt(arg_0)).toArray(LogicalType[]::new);
        RowType keyType = RowType.of((LogicalType[])keyFieldTypes);
        TableConfig config = planner.getTableConfig();
        GeneratedJoinCondition condFunc = JoinUtil.generateConditionFunction(config, this.nonEquiCondition, (LogicalType)leftType, (LogicalType)rightType);
        long externalBufferMemory = ((MemorySize)config.getConfiguration().get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_EXTERNAL_BUFFER_MEMORY)).getBytes();
        long sortMemory = ((MemorySize)config.getConfiguration().get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_SORT_MEMORY)).getBytes();
        int externalBufferNum = 1;
        if (this.joinType == FlinkJoinType.FULL) {
            externalBufferNum = 2;
        }
        long managedMemory = externalBufferMemory * (long)externalBufferNum + sortMemory * 2L;
        SortCodeGenerator leftSortGen = this.newSortGen(config, this.leftKeys, leftType);
        SortCodeGenerator rightSortGen = this.newSortGen(config, this.rightKeys, rightType);
        int[] keyPositions = IntStream.range(0, this.leftKeys.length).toArray();
        SortMergeJoinOperator operator = new SortMergeJoinOperator(1.0 * (double)externalBufferMemory / (double)managedMemory, this.joinType, this.leftIsSmaller, condFunc, ProjectionCodeGenerator.generateProjection(new CodeGeneratorContext(config), "SMJProjection", leftType, keyType, this.leftKeys), ProjectionCodeGenerator.generateProjection(new CodeGeneratorContext(config), "SMJProjection", rightType, keyType, this.rightKeys), leftSortGen.generateNormalizedKeyComputer("LeftComputer"), leftSortGen.generateRecordComparator("LeftComparator"), rightSortGen.generateNormalizedKeyComputer("RightComputer"), rightSortGen.generateRecordComparator("RightComparator"), this.newSortGen(config, keyPositions, keyType).generateRecordComparator("KeyComparator"), this.filterNulls);
        Transformation<?> leftInputTransform = leftInputEdge.translateToPlan(planner);
        Transformation<?> rightInputTransform = rightInputEdge.translateToPlan(planner);
        return ExecNodeUtil.createTwoInputTransformation(leftInputTransform, rightInputTransform, this.getDescription(), SimpleOperatorFactory.of((StreamOperator)operator), InternalTypeInfo.of((LogicalType)this.getOutputType()), rightInputTransform.getParallelism(), managedMemory);
    }

    private SortCodeGenerator newSortGen(TableConfig config, int[] originalKeys, RowType inputType) {
        SortSpec sortSpec = SortUtil.getAscendingSortSpec(originalKeys);
        return new SortCodeGenerator(config, inputType, sortSpec);
    }
}

