/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.time.Duration;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.logical.CumulativeWindowSpec;
import org.apache.flink.table.planner.plan.logical.HoppingWindowSpec;
import org.apache.flink.table.planner.plan.logical.SliceAttachedWindowingStrategy;
import org.apache.flink.table.planner.plan.logical.TimeAttributeWindowingStrategy;
import org.apache.flink.table.planner.plan.logical.TumblingWindowSpec;
import org.apache.flink.table.planner.plan.logical.WindowAttachedWindowingStrategy;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import org.apache.flink.table.planner.plan.logical.WindowingStrategy;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecAggregateBase;
import org.apache.flink.table.runtime.operators.window.slicing.SliceAssigner;
import org.apache.flink.table.runtime.operators.window.slicing.SliceAssigners;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

public abstract class StreamExecWindowAggregateBase
extends StreamExecAggregateBase {
    public static final long WINDOW_AGG_MEMORY_RATIO = 100L;
    public static final String FIELD_NAME_WINDOWING = "windowing";
    public static final String FIELD_NAME_NAMED_WINDOW_PROPERTIES = "namedWindowProperties";

    protected StreamExecWindowAggregateBase(int id, List<InputProperty> inputProperties, LogicalType outputType, String description) {
        super(id, inputProperties, outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
    }

    protected SliceAssigner createSliceAssigner(WindowingStrategy windowingStrategy, ZoneId shiftTimeZone) {
        WindowSpec windowSpec = windowingStrategy.getWindow();
        if (windowingStrategy instanceof WindowAttachedWindowingStrategy) {
            int windowEndIndex = ((WindowAttachedWindowingStrategy)windowingStrategy).getWindowEnd();
            SliceAssigner innerAssigner = this.createSliceAssigner(windowSpec, Integer.MAX_VALUE, shiftTimeZone);
            return SliceAssigners.windowed((int)windowEndIndex, (SliceAssigner)innerAssigner);
        }
        if (windowingStrategy instanceof SliceAttachedWindowingStrategy) {
            int sliceEndIndex = ((SliceAttachedWindowingStrategy)windowingStrategy).getSliceEnd();
            SliceAssigner innerAssigner = this.createSliceAssigner(windowSpec, Integer.MAX_VALUE, shiftTimeZone);
            return SliceAssigners.sliced((int)sliceEndIndex, (SliceAssigner)innerAssigner);
        }
        if (windowingStrategy instanceof TimeAttributeWindowingStrategy) {
            int timeAttributeIndex = windowingStrategy.isRowtime() ? ((TimeAttributeWindowingStrategy)windowingStrategy).getTimeAttributeIndex() : -1;
            return this.createSliceAssigner(windowSpec, timeAttributeIndex, shiftTimeZone);
        }
        throw new UnsupportedOperationException(windowingStrategy + " is not supported yet.");
    }

    protected SliceAssigner createSliceAssigner(WindowSpec windowSpec, int timeAttributeIndex, ZoneId shiftTimeZone) {
        if (windowSpec instanceof TumblingWindowSpec) {
            Duration size = ((TumblingWindowSpec)windowSpec).getSize();
            SliceAssigners.TumblingSliceAssigner assigner = SliceAssigners.tumbling((int)timeAttributeIndex, (ZoneId)shiftTimeZone, (Duration)size);
            Duration offset = ((TumblingWindowSpec)windowSpec).getOffset();
            if (offset != null) {
                assigner = assigner.withOffset(offset);
            }
            return assigner;
        }
        if (windowSpec instanceof HoppingWindowSpec) {
            Duration size = ((HoppingWindowSpec)windowSpec).getSize();
            Duration slide = ((HoppingWindowSpec)windowSpec).getSlide();
            if (size.toMillis() % slide.toMillis() != 0L) {
                throw new TableException(String.format("HOP table function based aggregate requires size must be an integral multiple of slide, but got size %s ms and slide %s ms", size.toMillis(), slide.toMillis()));
            }
            SliceAssigners.HoppingSliceAssigner assigner = SliceAssigners.hopping((int)timeAttributeIndex, (ZoneId)shiftTimeZone, (Duration)size, (Duration)slide);
            Duration offset = ((HoppingWindowSpec)windowSpec).getOffset();
            if (offset != null) {
                assigner = assigner.withOffset(offset);
            }
            return assigner;
        }
        if (windowSpec instanceof CumulativeWindowSpec) {
            Duration maxSize = ((CumulativeWindowSpec)windowSpec).getMaxSize();
            Duration step = ((CumulativeWindowSpec)windowSpec).getStep();
            if (maxSize.toMillis() % step.toMillis() != 0L) {
                throw new TableException(String.format("CUMULATE table function based aggregate requires maxSize must be an integral multiple of step, but got maxSize %s ms and step %s ms", maxSize.toMillis(), step.toMillis()));
            }
            SliceAssigners.CumulativeSliceAssigner assigner = SliceAssigners.cumulative((int)timeAttributeIndex, (ZoneId)shiftTimeZone, (Duration)maxSize, (Duration)step);
            Duration offset = ((CumulativeWindowSpec)windowSpec).getOffset();
            if (offset != null) {
                assigner = assigner.withOffset(offset);
            }
            return assigner;
        }
        throw new UnsupportedOperationException(windowSpec + " is not supported yet.");
    }

    protected LogicalType[] convertToLogicalTypes(DataType[] dataTypes) {
        return (LogicalType[])Arrays.stream(dataTypes).map(LogicalTypeDataTypeConverter::fromDataTypeToLogicalType).toArray(LogicalType[]::new);
    }
}

