/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.util.Optional;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.nodes.ExpressionFormat$;
import org.apache.flink.table.planner.plan.nodes.exec.spec.JoinSpec;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalJoin;
import org.apache.flink.table.planner.plan.trait.RelWindowProperties;
import org.apache.flink.table.planner.plan.utils.JoinUtil$;
import org.apache.flink.table.planner.utils.Logging;
import org.apache.flink.table.types.logical.LogicalType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple7;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class WindowJoinUtil$
implements Logging {
    public static WindowJoinUtil$ MODULE$;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    static {
        new WindowJoinUtil$();
    }

    private Logger LOG$lzycompute() {
        WindowJoinUtil$ windowJoinUtil$ = this;
        synchronized (windowJoinUtil$) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    public Tuple2<RelWindowProperties, RelWindowProperties> getChildWindowProperties(FlinkLogicalJoin join) {
        FlinkRelMetadataQuery fmq = FlinkRelMetadataQuery.reuseOrCreate(join.getCluster().getMetadataQuery());
        return new Tuple2((Object)fmq.getRelWindowProperties(join.getLeft()), (Object)fmq.getRelWindowProperties(join.getRight()));
    }

    public boolean satisfyWindowJoin(FlinkLogicalJoin join) {
        boolean bl;
        Some some;
        Tuple4 tuple4;
        Option<Tuple4<int[], int[], int[], int[]>> option = this.excludeWindowStartEqualityAndEndEqualityFromJoinInfoPairs(join);
        if (option instanceof Some && (tuple4 = (Tuple4)(some = (Some)option).value()) != null) {
            int[] windowStartEqualityLeftKeys = (int[])tuple4._1();
            int[] windowEndEqualityLeftKeys = (int[])tuple4._2();
            bl = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(windowStartEqualityLeftKeys)).nonEmpty() && new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(windowEndEqualityLeftKeys)).nonEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    public Tuple7<int[], int[], int[], int[], int[], int[], RexNode> excludeWindowStartEqualityAndEndEqualityFromWindowJoinCondition(FlinkLogicalJoin join) {
        Tuple3 tuple3;
        Tuple3 tuple32;
        Option<Tuple4<int[], int[], int[], int[]>> analyzeResult = this.excludeWindowStartEqualityAndEndEqualityFromJoinInfoPairs(join);
        if (analyzeResult.isEmpty()) {
            throw new IllegalArgumentException("Pleas give a Join which could be translated to window join!");
        }
        Tuple4 tuple4 = (Tuple4)analyzeResult.get();
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        int[] windowStartEqualityLeftKeys = (int[])tuple4._1();
        int[] windowEndEqualityLeftKeys = (int[])tuple4._2();
        int[] windowStartEqualityRightKeys = (int[])tuple4._3();
        int[] windowEndEqualityRightKeys = (int[])tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)windowStartEqualityLeftKeys, (Object)windowEndEqualityLeftKeys, (Object)windowStartEqualityRightKeys, (Object)windowEndEqualityRightKeys);
        Tuple4 tuple43 = tuple42;
        int[] windowStartEqualityLeftKeys2 = (int[])tuple43._1();
        int[] windowEndEqualityLeftKeys2 = (int[])tuple43._2();
        int[] windowStartEqualityRightKeys2 = (int[])tuple43._3();
        int[] windowEndEqualityRightKeys2 = (int[])tuple43._4();
        JoinSpec joinSpec = JoinUtil$.MODULE$.createJoinSpec(join);
        if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(windowStartEqualityLeftKeys2)).nonEmpty() || new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(windowEndEqualityLeftKeys2)).nonEmpty()) {
            java.util.List<RelDataTypeField> leftChildFieldsType = join.getLeft().getRowType().getFieldList();
            java.util.List<RelDataTypeField> rightChildFieldsType = join.getRight().getRowType().getFieldList();
            int leftFieldCnt = join.getLeft().getRowType().getFieldCount();
            RexBuilder rexBuilder = join.getCluster().getRexBuilder();
            ArrayBuffer remainingConditions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            ArrayBuffer remainLeftKeysArray = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            ArrayBuffer remainRightKeysArray = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(joinSpec.getLeftKeys())).zip((GenIterable)Predef$.MODULE$.wrapIntArray(joinSpec.getRightKeys()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).zip((GenIterable)Predef$.MODULE$.wrapBooleanArray(joinSpec.getFilterNulls()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BoxedUnit boxedUnit;
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                boolean filterNull = tuple2._2$mcZ$sp();
                if (tuple22 == null) throw new MatchError((Object)tuple2);
                int source = tuple22._1$mcI$sp();
                int target = tuple22._2$mcI$sp();
                if (!new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(windowStartEqualityLeftKeys2)).contains((Object)BoxesRunTime.boxToInteger((int)source)) && !new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(windowEndEqualityLeftKeys2)).contains((Object)BoxesRunTime.boxToInteger((int)source))) {
                    RelDataType leftFieldType = ((RelDataTypeField)leftChildFieldsType.get(source)).getType();
                    RexInputRef leftInputRef = new RexInputRef(source, leftFieldType);
                    RelDataType rightFieldType = ((RelDataTypeField)rightChildFieldsType.get(target)).getType();
                    int rightIndex = leftFieldCnt + target;
                    RexInputRef rightInputRef = new RexInputRef(rightIndex, rightFieldType);
                    SqlBinaryOperator op = filterNull ? SqlStdOperatorTable.EQUALS : SqlStdOperatorTable.IS_NOT_DISTINCT_FROM;
                    RexNode remainEqual = rexBuilder.makeCall((SqlOperator)op, leftInputRef, rightInputRef);
                    remainingConditions.$plus$eq((Object)remainEqual);
                    remainLeftKeysArray.$plus$eq((Object)BoxesRunTime.boxToInteger((int)source));
                    boxedUnit = remainRightKeysArray.$plus$eq((Object)BoxesRunTime.boxToInteger((int)target));
                    return boxedUnit;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
            Optional<RexNode> notEquiCondition = joinSpec.getNonEquiCondition();
            Object object = notEquiCondition.isPresent() ? remainingConditions.$plus$eq((Object)notEquiCondition.get()) : BoxedUnit.UNIT;
            tuple32 = new Tuple3(remainLeftKeysArray.toArray(ClassTag$.MODULE$.Int()), remainRightKeysArray.toArray(ClassTag$.MODULE$.Int()), (Object)RexUtil.composeConjunction(rexBuilder, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)remainingConditions.toList())));
        } else {
            tuple32 = tuple3 = new Tuple3((Object)joinSpec.getLeftKeys(), (Object)joinSpec.getRightKeys(), (Object)join.getCondition());
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int[] remainLeftKeys = (int[])tuple3._1();
        int[] remainRightKeys = (int[])tuple3._2();
        RexNode remainCondition = (RexNode)tuple3._3();
        Tuple3 tuple33 = new Tuple3((Object)remainLeftKeys, (Object)remainRightKeys, (Object)remainCondition);
        Tuple3 tuple34 = tuple33;
        int[] remainLeftKeys2 = (int[])tuple34._1();
        int[] remainRightKeys2 = (int[])tuple34._2();
        RexNode remainCondition2 = (RexNode)tuple34._3();
        return new Tuple7((Object)windowStartEqualityLeftKeys2, (Object)windowEndEqualityLeftKeys2, (Object)windowStartEqualityRightKeys2, (Object)windowEndEqualityRightKeys2, (Object)remainLeftKeys2, (Object)remainRightKeys2, (Object)remainCondition2);
    }

    private Option<Tuple4<int[], int[], int[], int[]>> excludeWindowStartEqualityAndEndEqualityFromJoinInfoPairs(FlinkLogicalJoin join) {
        Option option;
        JoinInfo joinInfo = join.analyzeCondition();
        Tuple2<RelWindowProperties, RelWindowProperties> tuple2 = this.getChildWindowProperties(join);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        RelWindowProperties leftWindowProperties = (RelWindowProperties)tuple2._1();
        RelWindowProperties rightWindowProperties = (RelWindowProperties)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)leftWindowProperties, (Object)rightWindowProperties);
        Tuple2 tuple23 = tuple22;
        RelWindowProperties leftWindowProperties2 = (RelWindowProperties)tuple23._1();
        RelWindowProperties rightWindowProperties2 = (RelWindowProperties)tuple23._2();
        if (leftWindowProperties2 == null || rightWindowProperties2 == null) {
            return Option$.MODULE$.empty();
        }
        ArrayBuffer windowStartEqualityLeftKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer windowEndEqualityLeftKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer windowStartEqualityRightKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer windowEndEqualityRightKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ImmutableBitSet leftWindowStartColumns = leftWindowProperties2.getWindowStartColumns();
        ImmutableBitSet rightWindowStartColumns = rightWindowProperties2.getWindowStartColumns();
        ImmutableBitSet leftWindowEndColumns = leftWindowProperties2.getWindowEndColumns();
        ImmutableBitSet rightWindowEndColumns = rightWindowProperties2.getWindowEndColumns();
        JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(joinInfo.pairs()).foreach((Function1 & Serializable & scala.Serializable)pair -> {
            Object object;
            int leftKey = pair.source;
            int rightKey = pair.target;
            if (leftWindowStartColumns.get(leftKey) && rightWindowStartColumns.get(rightKey)) {
                JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)windowStartEqualityLeftKeys).add(BoxesRunTime.boxToInteger((int)leftKey));
                object = BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)windowStartEqualityRightKeys).add(BoxesRunTime.boxToInteger((int)rightKey)));
            } else if (leftWindowEndColumns.get(leftKey) && rightWindowEndColumns.get(rightKey)) {
                JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)windowEndEqualityLeftKeys).add(BoxesRunTime.boxToInteger((int)leftKey));
                object = BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)windowEndEqualityRightKeys).add(BoxesRunTime.boxToInteger((int)rightKey)));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        if (windowStartEqualityLeftKeys.nonEmpty() && windowEndEqualityLeftKeys.nonEmpty()) {
            LogicalType logicalType = leftWindowProperties2.getTimeAttributeType();
            LogicalType logicalType2 = rightWindowProperties2.getTimeAttributeType();
            if (logicalType == null ? logicalType2 != null : !logicalType.equals(logicalType2)) {
                this.LOG().warn(new StringBuilder(160).append("Currently, window join doesn't support different time attribute type of left and right inputs.\n").append("The left time attribute type is ").append(new StringBuilder(2).append(leftWindowProperties2.getTimeAttributeType()).append(".\n").toString()).append("The right time attribute type is ").append(new StringBuilder(1).append(rightWindowProperties2.getTimeAttributeType()).append(".").toString()).toString());
                option = Option$.MODULE$.empty();
            } else {
                WindowSpec windowSpec = leftWindowProperties2.getWindowSpec();
                WindowSpec windowSpec2 = rightWindowProperties2.getWindowSpec();
                if (windowSpec == null ? windowSpec2 != null : !windowSpec.equals(windowSpec2)) {
                    this.LOG().warn(new StringBuilder(97).append("Currently, window join doesn't support different window table function of left and right inputs.\n").append(new StringBuilder(36).append("The left window table function is ").append(leftWindowProperties2.getWindowSpec()).append(".\n").toString()).append(new StringBuilder(36).append("The right window table function is ").append(rightWindowProperties2.getWindowSpec()).append(".").toString()).toString());
                    option = Option$.MODULE$.empty();
                } else {
                    option = Option$.MODULE$.apply((Object)new Tuple4(windowStartEqualityLeftKeys.toArray(ClassTag$.MODULE$.Int()), windowEndEqualityLeftKeys.toArray(ClassTag$.MODULE$.Int()), windowStartEqualityRightKeys.toArray(ClassTag$.MODULE$.Int()), windowEndEqualityRightKeys.toArray(ClassTag$.MODULE$.Int())));
                }
            }
        } else if (windowStartEqualityLeftKeys.nonEmpty() || windowEndEqualityLeftKeys.nonEmpty()) {
            List leftFieldNames = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(join.getLeft().getRowType().getFieldNames()).toList();
            List rightFieldNames = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(join.getRight().getRowType().getFieldNames()).toList();
            List inputFieldNames = (List)leftFieldNames.$plus$plus((GenTraversableOnce)rightFieldNames, List$.MODULE$.canBuildFrom());
            String condition = join.getExpressionString(join.getCondition(), (List<String>)inputFieldNames, (Option<List<RexNode>>)None$.MODULE$, ExpressionFormat$.MODULE$.Infix());
            this.LOG().warn(new StringBuilder(149).append("Currently, window join requires JOIN ON condition must contain both window starts equality of input tables and window ends equality of input tables.\n").append(new StringBuilder(38).append("But the current JOIN ON condition is ").append(condition).append(".").toString()).toString());
            option = Option$.MODULE$.empty();
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    private WindowJoinUtil$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

