/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.lang.management.ManagementFactory;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.junit.Assert;
import org.junit.Test;
import org.mortbay.util.ajax.JSON;

public class TestFSNamesystemMBean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNameNode().namesystem;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
            String snapshotStats = (String)mbs.getAttribute(mxbeanName, "SnapshotStats");
            Map stat = (Map)JSON.parse((String)snapshotStats);
            Assert.assertTrue((stat.containsKey("SnapshottableDirectories") && (Long)stat.get("SnapshottableDirectories") == (long)fsn.getNumSnapshottableDirs() ? 1 : 0) != 0);
            Assert.assertTrue((stat.containsKey("Snapshots") && (Long)stat.get("Snapshots") == (long)fsn.getNumSnapshots() ? 1 : 0) != 0);
            Object pendingDeletionBlocks = mbs.getAttribute(mxbeanName, "PendingDeletionBlocks");
            Assert.assertNotNull((Object)pendingDeletionBlocks);
            Assert.assertTrue((boolean)(pendingDeletionBlocks instanceof Long));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithFSNamesystemWriteLock() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        FSNamesystem fsn = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            fsn = cluster.getNameNode().namesystem;
            fsn.writeLock();
            MBeanClient client = new MBeanClient();
            client.start();
            client.join(20000L);
            Assert.assertTrue((String)"JMX calls are blocked when FSNamesystem's writerlockis owned by another thread", (boolean)client.succeeded);
            client.interrupt();
        }
        finally {
            if (fsn != null && fsn.hasWriteLock()) {
                fsn.writeUnlock();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static class MBeanClient
    extends Thread {
        private boolean succeeded = false;

        private MBeanClient() {
        }

        @Override
        public void run() {
            try {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                ObjectName mxbeanNamefsn = new ObjectName("Hadoop:service=NameNode,name=FSNamesystem");
                Integer blockCapacity = (Integer)mbs.getAttribute(mxbeanNamefsn, "BlockCapacity");
                ObjectName mxbeanNameFsns = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
                String FSState = (String)mbs.getAttribute(mxbeanNameFsns, "FSState");
                Long blocksTotal = (Long)mbs.getAttribute(mxbeanNameFsns, "BlocksTotal");
                Long capacityTotal = (Long)mbs.getAttribute(mxbeanNameFsns, "CapacityTotal");
                Long capacityRemaining = (Long)mbs.getAttribute(mxbeanNameFsns, "CapacityRemaining");
                Long capacityUsed = (Long)mbs.getAttribute(mxbeanNameFsns, "CapacityUsed");
                Long filesTotal = (Long)mbs.getAttribute(mxbeanNameFsns, "FilesTotal");
                Long pendingReplicationBlocks = (Long)mbs.getAttribute(mxbeanNameFsns, "PendingReplicationBlocks");
                Long underReplicatedBlocks = (Long)mbs.getAttribute(mxbeanNameFsns, "UnderReplicatedBlocks");
                Long scheduledReplicationBlocks = (Long)mbs.getAttribute(mxbeanNameFsns, "ScheduledReplicationBlocks");
                Integer totalLoad = (Integer)mbs.getAttribute(mxbeanNameFsns, "TotalLoad");
                Integer numLiveDataNodes = (Integer)mbs.getAttribute(mxbeanNameFsns, "NumLiveDataNodes");
                Integer numDeadDataNodes = (Integer)mbs.getAttribute(mxbeanNameFsns, "NumDeadDataNodes");
                Integer numStaleDataNodes = (Integer)mbs.getAttribute(mxbeanNameFsns, "NumStaleDataNodes");
                Integer numDecomLiveDataNodes = (Integer)mbs.getAttribute(mxbeanNameFsns, "NumDecomLiveDataNodes");
                Integer numDecomDeadDataNodes = (Integer)mbs.getAttribute(mxbeanNameFsns, "NumDecomDeadDataNodes");
                Integer numDecommissioningDataNodes = (Integer)mbs.getAttribute(mxbeanNameFsns, "NumDecommissioningDataNodes");
                String snapshotStats = (String)mbs.getAttribute(mxbeanNameFsns, "SnapshotStats");
                Long MaxObjects = (Long)mbs.getAttribute(mxbeanNameFsns, "MaxObjects");
                Integer numStaleStorages = (Integer)mbs.getAttribute(mxbeanNameFsns, "NumStaleStorages");
                ObjectName mxbeanNameNni = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
                String safemode = (String)mbs.getAttribute(mxbeanNameNni, "Safemode");
                String liveNodes = (String)mbs.getAttribute(mxbeanNameNni, "LiveNodes");
                String deadNodes = (String)mbs.getAttribute(mxbeanNameNni, "DeadNodes");
                String decomNodes = (String)mbs.getAttribute(mxbeanNameNni, "DecomNodes");
                String corruptFiles = (String)mbs.getAttribute(mxbeanNameNni, "CorruptFiles");
                this.succeeded = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

