/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.speculate;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptStatusUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.speculate.ExponentiallySmoothedTaskRuntimeEstimator;
import org.apache.hadoop.mapreduce.v2.app.speculate.StartEndTimesBase;

public class ExponentiallySmoothedTaskRuntimeEstimator
extends StartEndTimesBase {
    private final ConcurrentMap<TaskAttemptId, AtomicReference<EstimateVector>> estimates = new ConcurrentHashMap();
    private SmoothedValue smoothedValue;
    private long lambda;

    ExponentiallySmoothedTaskRuntimeEstimator(long lambda, SmoothedValue smoothedValue) {
        this.smoothedValue = smoothedValue;
        this.lambda = lambda;
    }

    public ExponentiallySmoothedTaskRuntimeEstimator() {
    }

    private void incorporateReading(TaskAttemptId attemptID, float newProgress, long newTime) {
        AtomicReference vectorRef = (AtomicReference)this.estimates.get(attemptID);
        if (vectorRef == null) {
            this.estimates.putIfAbsent(attemptID, new AtomicReference<Object>(null));
            this.incorporateReading(attemptID, newProgress, newTime);
            return;
        }
        EstimateVector oldVector = (EstimateVector)vectorRef.get();
        if (oldVector == null) {
            if (vectorRef.compareAndSet(null, new EstimateVector(this, -1.0, 0.0f, Long.MIN_VALUE))) {
                return;
            }
            this.incorporateReading(attemptID, newProgress, newTime);
            return;
        }
        while (!vectorRef.compareAndSet(oldVector, oldVector.incorporate(newProgress, newTime))) {
            oldVector = (EstimateVector)vectorRef.get();
        }
    }

    private EstimateVector getEstimateVector(TaskAttemptId attemptID) {
        AtomicReference vectorRef = (AtomicReference)this.estimates.get(attemptID);
        if (vectorRef == null) {
            return null;
        }
        return (EstimateVector)vectorRef.get();
    }

    public void contextualize(Configuration conf, AppContext context) {
        super.contextualize(conf, context);
        this.lambda = conf.getLong("yarn.app.mapreduce.am.job.task.estimator.exponential.smooth.lambda-ms", 60000L);
        this.smoothedValue = conf.getBoolean("yarn.app.mapreduce.am.job.task.estimator.exponential.smooth.rate", true) ? SmoothedValue.RATE : SmoothedValue.TIME_PER_UNIT_PROGRESS;
    }

    public long estimatedRuntime(TaskAttemptId id) {
        double rate;
        Long startTime = (Long)this.startTimes.get(id);
        if (startTime == null) {
            return -1L;
        }
        EstimateVector vector = this.getEstimateVector(id);
        if (vector == null) {
            return -1L;
        }
        long sunkTime = vector.atTime - startTime;
        double value = vector.value;
        float progress = vector.basedOnProgress;
        if (value == 0.0) {
            return -1L;
        }
        double d = rate = this.smoothedValue == SmoothedValue.RATE ? value : 1.0 / value;
        if (rate == 0.0) {
            return -1L;
        }
        double remainingTime = (1.0 - (double)progress) / rate;
        return sunkTime + (long)remainingTime;
    }

    public long runtimeEstimateVariance(TaskAttemptId id) {
        return -1L;
    }

    public void updateAttempt(TaskAttemptStatusUpdateEvent.TaskAttemptStatus status, long timestamp) {
        super.updateAttempt(status, timestamp);
        TaskAttemptId attemptID = status.id;
        float progress = status.progress;
        this.incorporateReading(attemptID, progress, timestamp);
    }

    static /* synthetic */ long access$000(ExponentiallySmoothedTaskRuntimeEstimator x0) {
        return x0.lambda;
    }

    static /* synthetic */ SmoothedValue access$100(ExponentiallySmoothedTaskRuntimeEstimator x0) {
        return x0.smoothedValue;
    }
}

