/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.AppController;
import org.apache.hadoop.mapreduce.v2.app.webapp.ViewForTest;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.ResponseInfo;
import org.apache.hadoop.yarn.webapp.View;
import org.mockito.Mockito;

public class AppControllerForTest
extends AppController {
    private static final Map<String, String> properties = new HashMap();
    private ResponseInfo responseInfo = new ResponseInfo();
    private View view = new ViewForTest();
    private Class<?> clazz;
    private HttpServletResponse response;
    OutputStream data = new ByteArrayOutputStream();
    PrintWriter writer = new PrintWriter(this.data);

    protected AppControllerForTest(App app, Configuration configuration, Controller.RequestContext ctx) {
        super(app, configuration, ctx);
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public <T> T getInstance(Class<T> cls) {
        this.clazz = cls;
        if (cls.equals(ResponseInfo.class)) {
            return (T)this.responseInfo;
        }
        return (T)this.view;
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public String get(String key, String defaultValue) {
        String result = (String)properties.get(key);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public void set(String key, String value) {
        properties.put(key, value);
    }

    public HttpServletRequest request() {
        HttpServletRequest result = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)result.getRemoteUser()).thenReturn((Object)"user");
        return result;
    }

    public HttpServletResponse response() {
        if (this.response == null) {
            this.response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        }
        return this.response;
    }

    public Map<String, String> getProperty() {
        return properties;
    }

    public String getData() {
        this.writer.flush();
        return this.data.toString();
    }

    protected PrintWriter writer() {
        if (this.writer == null) {
            this.writer = new PrintWriter(this.data);
        }
        return this.writer;
    }
}

