/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionTask;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.WindowFunctionInfo;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver2;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMacro;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionResolver;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hive.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Registry {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionRegistry.class);
    private static final String WINDOW_FUNC_PREFIX = "@_";
    private final Map<String, FunctionInfo> mFunctions = new LinkedHashMap<String, FunctionInfo>();
    private final Set<Class<?>> builtIns = Collections.synchronizedSet(new HashSet());
    private final Map<Class<?>, Integer> persistent = new ConcurrentHashMap();
    private final Set<ClassLoader> mSessionUDFLoaders = new LinkedHashSet<ClassLoader>();
    private final boolean isNative;
    private final ReentrantLock lock = new ReentrantLock();

    public Registry(boolean isNative) {
        this.isNative = isNative;
    }

    public FunctionInfo registerFunction(String functionName, Class<?> udfClass, FunctionInfo.FunctionResource ... resources) {
        FunctionUtils.UDFClassType udfClassType = FunctionUtils.getUDFClassType(udfClass);
        switch (udfClassType) {
            case UDF: {
                return this.registerUDF(functionName, udfClass, false, resources);
            }
            case GENERIC_UDF: {
                return this.registerGenericUDF(functionName, udfClass, resources);
            }
            case GENERIC_UDTF: {
                return this.registerGenericUDTF(functionName, udfClass, resources);
            }
            case UDAF: {
                return this.registerUDAF(functionName, udfClass, resources);
            }
            case GENERIC_UDAF_RESOLVER: {
                return this.registerGenericUDAF(functionName, (GenericUDAFResolver)ReflectionUtil.newInstance(udfClass, null), resources);
            }
            case TABLE_FUNCTION_RESOLVER: {
                return this.registerTableFunction(functionName, udfClass, resources);
            }
        }
        return null;
    }

    public FunctionInfo registerUDF(String functionName, Class<? extends UDF> UDFClass, boolean isOperator, FunctionInfo.FunctionResource ... resources) {
        return this.registerUDF(functionName, UDFClass, isOperator, functionName.toLowerCase(), resources);
    }

    public FunctionInfo registerUDF(String functionName, Class<? extends UDF> UDFClass, boolean isOperator, String displayName, FunctionInfo.FunctionResource ... resources) {
        this.validateClass(UDFClass, UDF.class);
        FunctionInfo fI = new FunctionInfo(this.isNative, displayName, new GenericUDFBridge(displayName, isOperator, UDFClass.getName()), resources);
        this.addFunction(functionName, fI);
        return fI;
    }

    public FunctionInfo registerGenericUDF(String functionName, Class<? extends GenericUDF> genericUDFClass, FunctionInfo.FunctionResource ... resources) {
        this.validateClass(genericUDFClass, GenericUDF.class);
        FunctionInfo fI = new FunctionInfo(this.isNative, functionName, ReflectionUtil.newInstance(genericUDFClass, null), resources);
        this.addFunction(functionName, fI);
        return fI;
    }

    public void registerHiddenBuiltIn(Class<? extends GenericUDF> functionClass) {
        this.lock.lock();
        try {
            if (!this.isNative) {
                throw new RuntimeException("Builtin is not for this registry");
            }
            this.builtIns.add(functionClass);
        }
        finally {
            this.lock.unlock();
        }
    }

    public FunctionInfo registerGenericUDTF(String functionName, Class<? extends GenericUDTF> genericUDTFClass, FunctionInfo.FunctionResource ... resources) {
        this.validateClass(genericUDTFClass, GenericUDTF.class);
        FunctionInfo fI = new FunctionInfo(this.isNative, functionName, ReflectionUtil.newInstance(genericUDTFClass, null), resources);
        this.addFunction(functionName, fI);
        return fI;
    }

    public FunctionInfo registerGenericUDAF(String functionName, GenericUDAFResolver genericUDAFResolver, FunctionInfo.FunctionResource ... resources) {
        WindowFunctionInfo function = new WindowFunctionInfo(this.isNative, functionName, genericUDAFResolver, resources);
        this.addFunction(functionName, function);
        this.addFunction(WINDOW_FUNC_PREFIX + functionName, function);
        return function;
    }

    public FunctionInfo registerUDAF(String functionName, Class<? extends UDAF> udafClass, FunctionInfo.FunctionResource ... resources) {
        this.validateClass(udafClass, UDAF.class);
        WindowFunctionInfo function = new WindowFunctionInfo(this.isNative, functionName, new GenericUDAFBridge(ReflectionUtil.newInstance(udafClass, null)), resources);
        this.addFunction(functionName, function);
        this.addFunction(WINDOW_FUNC_PREFIX + functionName, function);
        return function;
    }

    public FunctionInfo registerTableFunction(String functionName, Class<? extends TableFunctionResolver> tFnCls, FunctionInfo.FunctionResource ... resources) {
        this.validateClass(tFnCls, TableFunctionResolver.class);
        FunctionInfo function = new FunctionInfo(this.isNative, functionName, tFnCls, resources);
        this.addFunction(functionName, function);
        return function;
    }

    public FunctionInfo registerMacro(String macroName, ExprNodeDesc body, List<String> colNames, List<TypeInfo> colTypes) {
        return this.registerMacro(macroName, body, colNames, colTypes, null);
    }

    public FunctionInfo registerMacro(String macroName, ExprNodeDesc body, List<String> colNames, List<TypeInfo> colTypes, FunctionInfo.FunctionResource ... resources) {
        GenericUDFMacro macro = new GenericUDFMacro(macroName, body, colNames, colTypes);
        FunctionInfo fI = new FunctionInfo(this.isNative, macroName, macro, resources);
        this.addFunction(macroName, fI);
        return fI;
    }

    public FunctionInfo registerPermanentFunction(String functionName, String className, boolean registerToSession, FunctionInfo.FunctionResource ... resources) {
        String qualifiedName;
        FunctionInfo function = new FunctionInfo(functionName, className, resources);
        if (registerToSession && this.registerToSessionRegistry(qualifiedName = FunctionUtils.qualifyFunctionName(functionName, SessionState.get().getCurrentDatabase().toLowerCase()), function) != null) {
            this.addFunction(functionName, function);
            return function;
        }
        this.addFunction(functionName, function);
        return null;
    }

    void registerWindowFunction(String name, GenericUDAFResolver wFn) {
        this.addFunction(WINDOW_FUNC_PREFIX + name, new WindowFunctionInfo(this.isNative, name, wFn, null));
    }

    private void validateClass(Class input, Class expected) {
        if (!expected.isAssignableFrom(input)) {
            throw new RuntimeException("Registering UDF Class " + input + " which does not extend " + expected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionInfo getFunctionInfo(String functionName) throws SemanticException {
        this.lock.lock();
        try {
            functionName = functionName.toLowerCase();
            if (FunctionUtils.isQualifiedFunctionName(functionName)) {
                FunctionInfo functionInfo = this.getQualifiedFunctionInfoUnderLock(functionName);
                return functionInfo;
            }
            FunctionInfo functionInfo = this.mFunctions.get(functionName);
            if (functionInfo != null && functionInfo.isBlockedFunction()) {
                throw new SemanticException("UDF " + functionName + " is not allowed");
            }
            if (functionInfo == null) {
                String qualifiedName = FunctionUtils.qualifyFunctionName(functionName, SessionState.get().getCurrentDatabase().toLowerCase());
                functionInfo = this.getQualifiedFunctionInfoUnderLock(qualifiedName);
            }
            FunctionInfo functionInfo2 = functionInfo;
            return functionInfo2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public WindowFunctionInfo getWindowFunctionInfo(String functionName) throws SemanticException {
        FunctionInfo info = this.getFunctionInfo(WINDOW_FUNC_PREFIX + functionName);
        if (info instanceof WindowFunctionInfo) {
            return (WindowFunctionInfo)info;
        }
        return null;
    }

    public boolean isBuiltInFunc(Class<?> udfClass) {
        return udfClass != null && this.builtIns.contains(udfClass);
    }

    public boolean isPermanentFunc(Class<?> udfClass) {
        return udfClass != null && this.persistent.containsKey(udfClass);
    }

    public Set<String> getCurrentFunctionNames() {
        this.lock.lock();
        try {
            Set<String> set = this.getFunctionNames((Pattern)null);
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getFunctionNames(String funcPatternStr) {
        this.lock.lock();
        try {
            Set<String> set = this.getFunctionNames(Pattern.compile(funcPatternStr));
            return set;
        }
        catch (PatternSyntaxException e) {
            Set<String> set = Collections.emptySet();
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getFunctionNames(Pattern funcPattern) {
        this.lock.lock();
        try {
            TreeSet<String> funcNames = new TreeSet<String>();
            for (String funcName : this.mFunctions.keySet()) {
                if (funcName.contains(WINDOW_FUNC_PREFIX) || funcPattern != null && !funcPattern.matcher(funcName).matches()) continue;
                funcNames.add(funcName);
            }
            TreeSet<String> treeSet = funcNames;
            return treeSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFunctionSynonyms(String funcName, FunctionInfo funcInfo, Set<String> synonyms) throws SemanticException {
        this.lock.lock();
        try {
            Class<?> funcClass = funcInfo.getFunctionClass();
            for (Map.Entry<String, FunctionInfo> entry : this.mFunctions.entrySet()) {
                FunctionInfo function;
                String name = entry.getKey();
                if (name.contains(WINDOW_FUNC_PREFIX) || name.equals(funcName) || (function = entry.getValue()).getFunctionClass() != funcClass) continue;
                synonyms.add(name);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public GenericUDAFEvaluator getGenericUDAFEvaluator(String name, List<ObjectInspector> argumentOIs, boolean isDistinct, boolean isAllColumns) throws SemanticException {
        GenericUDAFResolver udafResolver = this.getGenericUDAFResolver(name);
        if (udafResolver == null) {
            return null;
        }
        ObjectInspector[] args = new ObjectInspector[argumentOIs.size()];
        for (int ii = 0; ii < argumentOIs.size(); ++ii) {
            args[ii] = argumentOIs.get(ii);
        }
        SimpleGenericUDAFParameterInfo paramInfo = new SimpleGenericUDAFParameterInfo(args, isDistinct, isAllColumns);
        GenericUDAFEvaluator udafEvaluator = udafResolver instanceof GenericUDAFResolver2 ? ((GenericUDAFResolver2)udafResolver).getEvaluator(paramInfo) : udafResolver.getEvaluator(paramInfo.getParameters());
        return udafEvaluator;
    }

    public GenericUDAFEvaluator getGenericWindowingEvaluator(String functionName, List<ObjectInspector> argumentOIs, boolean isDistinct, boolean isAllColumns) throws SemanticException {
        WindowFunctionInfo info = this.getWindowFunctionInfo(functionName = functionName.toLowerCase());
        if (info == null) {
            return null;
        }
        if (!functionName.equals("lead") && !functionName.equals("lag")) {
            return this.getGenericUDAFEvaluator(functionName, argumentOIs, isDistinct, isAllColumns);
        }
        ObjectInspector[] args = new ObjectInspector[argumentOIs.size()];
        GenericUDAFResolver udafResolver = info.getGenericUDAFResolver();
        SimpleGenericUDAFParameterInfo paramInfo = new SimpleGenericUDAFParameterInfo(argumentOIs.toArray(args), isDistinct, isAllColumns);
        return ((GenericUDAFResolver2)udafResolver).getEvaluator(paramInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFunction(String functionName, FunctionInfo function) {
        this.lock.lock();
        try {
            if (this.isNative != function.isNative()) {
                throw new RuntimeException("Function " + functionName + " is not for this registry");
            }
            FunctionInfo prev = this.mFunctions.get(functionName = functionName.toLowerCase());
            if (prev != null) {
                if (this.isBuiltInFunc(prev.getFunctionClass())) {
                    throw new RuntimeException("Function " + functionName + " is hive builtin function, which cannot be overriden.");
                }
                prev.discarded();
            }
            this.mFunctions.put(functionName, function);
            if (function.isBuiltIn()) {
                this.builtIns.add(function.getFunctionClass());
            } else if (function.isPersistent()) {
                Class<?> functionClass;
                Integer refCount = this.persistent.get(functionClass = this.getPermanentUdfClass(function));
                this.persistent.put(functionClass, refCount == null ? 1 : refCount + 1);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private Class<?> getPermanentUdfClass(FunctionInfo function) {
        Class<?> functionClass = function.getFunctionClass();
        if (functionClass == null) {
            ClassLoader loader = Utilities.getSessionSpecifiedClassLoader();
            try {
                functionClass = Class.forName(function.getClassName(), true, loader);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        return functionClass;
    }

    public void unregisterFunction(String functionName) throws HiveException {
        this.lock.lock();
        try {
            functionName = functionName.toLowerCase();
            FunctionInfo fi = this.mFunctions.get(functionName);
            if (fi != null) {
                if (fi.isBuiltIn()) {
                    throw new HiveException(ErrorMsg.DROP_NATIVE_FUNCTION.getMsg(functionName));
                }
                this.mFunctions.remove(functionName);
                fi.discarded();
                if (fi.isPersistent()) {
                    this.removePersistentFunctionUnderLock(fi);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void removePersistentFunctionUnderLock(FunctionInfo fi) {
        Class<?> functionClass = this.getPermanentUdfClass(fi);
        Integer refCount = this.persistent.get(functionClass);
        assert (refCount != null);
        if (refCount == 1) {
            this.persistent.remove(functionClass);
        } else {
            this.persistent.put(functionClass, refCount - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctions(String dbName) throws HiveException {
        this.lock.lock();
        try {
            Set<String> funcNames = this.getFunctionNames(dbName.toLowerCase() + "\\..*");
            for (String funcName : funcNames) {
                this.unregisterFunction(funcName);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public GenericUDAFResolver getGenericUDAFResolver(String functionName) throws SemanticException {
        FunctionInfo info = this.getFunctionInfo(functionName);
        if (info != null) {
            return info.getGenericUDAFResolver();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionInfo getQualifiedFunctionInfoUnderLock(String qualifiedName) throws SemanticException {
        HiveConf conf;
        FunctionInfo info = this.mFunctions.get(qualifiedName);
        if (info != null && info.isBlockedFunction()) {
            throw new SemanticException("UDF " + qualifiedName + " is not allowed");
        }
        if (!this.isNative && info != null && info.isDiscarded()) {
            this.mFunctions.remove(qualifiedName);
            return null;
        }
        if (this.isNative && info != null && info.isPersistent()) {
            return this.registerToSessionRegistry(qualifiedName, info);
        }
        if (info != null || !this.isNative) {
            return info;
        }
        SessionState ss = SessionState.get();
        HiveConf hiveConf = conf = ss == null ? null : ss.getConf();
        if (conf == null || !HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_ALLOW_UDF_LOAD_ON_DEMAND)) {
            return null;
        }
        this.lock.unlock();
        try {
            FunctionInfo functionInfo = this.getFunctionInfoFromMetastoreNoLock(qualifiedName, conf);
            return functionInfo;
        }
        finally {
            this.lock.lock();
        }
    }

    private FunctionInfo registerToSessionRegistry(String qualifiedName, FunctionInfo function) {
        FunctionInfo ret = null;
        ClassLoader prev = Utilities.getSessionSpecifiedClassLoader();
        try {
            FunctionInfo.FunctionResource[] resources = function.getResources();
            try {
                FunctionTask.addFunctionResources(resources);
            }
            catch (Exception e) {
                LOG.error("Unable to load resources for " + qualifiedName + ":" + e, (Throwable)e);
                return null;
            }
            ClassLoader loader = Utilities.getSessionSpecifiedClassLoader();
            Class<?> udfClass = Class.forName(function.getClassName(), true, loader);
            ret = FunctionRegistry.registerTemporaryUDF(qualifiedName, udfClass, resources);
            if (ret == null) {
                LOG.error(function.getClassName() + " is not a valid UDF class and was not registered.");
            }
            if (SessionState.get().isHiveServerQuery()) {
                SessionState.getRegistryForWrite().addToUDFLoaders(loader);
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error("Unable to load UDF class: " + e);
            Utilities.restoreSessionSpecifiedClassLoader(prev);
        }
        function.shareStateWith(ret);
        return ret;
    }

    public void clear() {
        this.lock.lock();
        try {
            if (this.isNative) {
                throw new IllegalStateException("System function registry cannot be cleared");
            }
            this.mFunctions.clear();
            this.builtIns.clear();
            this.persistent.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void closeCUDFLoaders() {
        this.lock.lock();
        try {
            try {
                for (ClassLoader loader : this.mSessionUDFLoaders) {
                    JavaUtils.closeClassLoader(loader);
                }
            }
            catch (IOException ie) {
                LOG.error("Error in close loader: " + ie);
            }
            this.mSessionUDFLoaders.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addToUDFLoaders(ClassLoader loader) {
        this.lock.lock();
        try {
            this.mSessionUDFLoaders.add(loader);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeFromUDFLoaders(ClassLoader loader) {
        this.lock.lock();
        try {
            this.mSessionUDFLoaders.remove(loader);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setupPermissionsForUDFs(String whiteListStr, String blackListStr) {
        HashSet<String> whiteList = Sets.newHashSet(Splitter.on(",").trimResults().omitEmptyStrings().split(whiteListStr.toLowerCase()));
        HashSet<String> blackList = Sets.newHashSet(Splitter.on(",").trimResults().omitEmptyStrings().split(blackListStr.toLowerCase()));
        blackList.removeAll(FunctionRegistry.HIVE_OPERATORS);
        for (Map.Entry<String, FunctionInfo> funcEntry : this.mFunctions.entrySet()) {
            funcEntry.getValue().setBlockedFunction(this.isUdfBlocked(funcEntry.getKey(), whiteList, blackList));
        }
    }

    boolean isUdfBlocked(String functionName, Set<String> whiteList, Set<String> blackList) {
        return blackList.contains(functionName = functionName.toLowerCase()) || !whiteList.isEmpty() && !whiteList.contains(functionName);
    }

    private FunctionInfo getFunctionInfoFromMetastoreNoLock(String functionName, HiveConf conf) {
        try {
            String[] parts = FunctionUtils.getQualifiedFunctionNameParts(functionName);
            Function func = Hive.get(conf).getFunction(parts[0].toLowerCase(), parts[1]);
            if (func == null) {
                return null;
            }
            FunctionInfo fi = this.registerPermanentFunction(functionName, func.getClassName(), true, FunctionTask.toFunctionResource(func.getResourceUris()));
            if (fi == null) {
                LOG.error(func.getClassName() + " is not a valid UDF class and was not registered");
                return null;
            }
            return fi;
        }
        catch (Throwable e) {
            LOG.info("Unable to look up " + functionName + " in metastore", e);
            return null;
        }
    }
}

