/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MathExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public abstract class MathFuncDoubleToDouble
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private int outputColumn;

    protected abstract double func(double var1);

    public MathFuncDoubleToDouble(int colNum, int outputColumn) {
        this.colNum = colNum;
        this.outputColumn = outputColumn;
    }

    public MathFuncDoubleToDouble() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            this.evaluateChildren(batch);
        }
        DoubleColumnVector inputColVector = (DoubleColumnVector)batch.cols[this.colNum];
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = inputColVector.noNulls;
        int n = batch.size;
        double[] vector = inputColVector.vector;
        double[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        if (inputColVector.isRepeating) {
            outputVector[0] = this.func(vector[0]);
            outputIsNull[0] = inputIsNull[0];
            outputColVector.isRepeating = true;
        } else if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = this.func(vector[i]);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.func(vector[i]);
                }
            }
            outputColVector.isRepeating = false;
        } else {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = this.func(vector[i]);
                    outputIsNull[i] = inputIsNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.func(vector[i]);
                }
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
            }
            outputColVector.isRepeating = false;
        }
        this.cleanup(outputColVector, sel, batch.selectedInUse, n);
    }

    protected void cleanup(DoubleColumnVector outputColVector, int[] sel, boolean selectedInUse, int n) {
        MathExpr.NaNToNull(outputColVector, sel, selectedInUse, n);
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    @Override
    public String getOutputType() {
        return "double";
    }
}

