/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.AbstractFilterStringColLikeStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterStringColLikeStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class SelectStringColLikeStringScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private int outputColumn;
    private byte[] pattern;
    transient AbstractFilterStringColLikeStringScalar.Checker checker = null;

    public SelectStringColLikeStringScalar() {
    }

    public SelectStringColLikeStringScalar(int colNum, byte[] pattern, int outputColumn) {
        this.colNum = colNum;
        this.pattern = pattern;
        this.outputColumn = outputColumn;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.checker == null) {
            this.checker = this.borrowChecker();
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inputColVector = (BytesColumnVector)batch.cols[this.colNum];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector.isNull;
        int n = batch.size;
        byte[][] vector = inputColVector.vector;
        int[] length = inputColVector.length;
        int[] start = inputColVector.start;
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumn];
        long[] outputVector = outV.vector;
        if (n == 0) {
            return;
        }
        outV.noNulls = inputColVector.noNulls;
        outV.isRepeating = inputColVector.isRepeating;
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                outputVector[0] = this.checker.check(vector[0], start[0], length[0]) ? 1 : 0;
                outV.isNull[0] = false;
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = this.checker.check(vector[i], start[i], length[i]) ? 1 : 0;
                    outV.isNull[i] = false;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.checker.check(vector[i], start[i], length[i]) ? 1 : 0;
                    outV.isNull[i] = false;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!nullPos[0]) {
                outputVector[0] = this.checker.check(vector[0], start[0], length[0]) ? 1 : 0;
                outV.isNull[0] = false;
            } else {
                outputVector[0] = 1L;
                outV.isNull[0] = true;
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!nullPos[i]) {
                    outputVector[i] = this.checker.check(vector[i], start[i], length[i]) ? 1 : 0;
                    outV.isNull[i] = false;
                    continue;
                }
                outputVector[0] = 1L;
                outV.isNull[i] = true;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!nullPos[i]) {
                    outputVector[i] = this.checker.check(vector[i], start[i], length[i]) ? 1 : 0;
                    outV.isNull[i] = false;
                    continue;
                }
                outputVector[0] = 1L;
                outV.isNull[i] = true;
            }
        }
    }

    private AbstractFilterStringColLikeStringScalar.Checker borrowChecker() {
        FilterStringColLikeStringScalar fil = new FilterStringColLikeStringScalar();
        return fil.createChecker(new String(this.pattern, StandardCharsets.UTF_8));
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public byte[] getPattern() {
        return this.pattern;
    }

    public void setPattern(byte[] pattern) {
        this.pattern = pattern;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "String_Family";
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY, VectorExpressionDescriptor.ArgumentType.STRING).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

