/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.parse.QBJoinTree;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;

@Explain(displayName="Join Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class JoinDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    public static final int INNER_JOIN = 0;
    public static final int LEFT_OUTER_JOIN = 1;
    public static final int RIGHT_OUTER_JOIN = 2;
    public static final int FULL_OUTER_JOIN = 3;
    public static final int UNIQUE_JOIN = 4;
    public static final int LEFT_SEMI_JOIN = 5;
    private boolean handleSkewJoin = false;
    private int skewKeyDefinition = -1;
    private Map<Byte, Path> bigKeysDirMap;
    private Map<Byte, Map<Byte, Path>> smallKeysDirMap;
    private Map<Byte, TableDesc> skewKeysValuesTables;
    private Map<Byte, List<ExprNodeDesc>> exprs;
    private Map<Byte, List<ExprNodeDesc>> filters;
    private int[][] filterMap;
    private boolean[] nullsafes;
    protected List<String> outputColumnNames;
    private transient Map<String, Byte> reversedExprs;
    protected boolean noOuterJoin;
    protected JoinCondDesc[] conds;
    protected Byte[] tagOrder;
    private TableDesc keyTableDesc;
    private boolean fixedAsSorted;
    private transient ExprNodeDesc[][] joinKeys;
    private transient String leftAlias;
    private transient String[] leftAliases;
    private transient String[] rightAliases;
    private transient String[] baseSrc;
    private transient String id;
    private transient boolean mapSideJoin;
    private transient List<String> mapAliases;
    private transient Map<String, Operator<? extends OperatorDesc>> aliasToOpInfo;
    private transient boolean leftInputJoin;
    private transient List<String> streamAliases;

    public JoinDesc() {
    }

    public JoinDesc(Map<Byte, List<ExprNodeDesc>> exprs, List<String> outputColumnNames, boolean noOuterJoin, JoinCondDesc[] conds, Map<Byte, List<ExprNodeDesc>> filters, ExprNodeDesc[][] joinKeys) {
        this.exprs = exprs;
        this.outputColumnNames = outputColumnNames;
        this.noOuterJoin = noOuterJoin;
        this.conds = conds;
        this.filters = filters;
        this.joinKeys = joinKeys;
        this.resetOrder();
    }

    public void resetOrder() {
        this.tagOrder = new Byte[this.exprs.size()];
        for (int i = 0; i < this.tagOrder.length; ++i) {
            this.tagOrder[i] = (byte)i;
        }
    }

    @Override
    public Object clone() {
        JoinDesc ret = new JoinDesc();
        HashMap<Byte, List<ExprNodeDesc>> cloneExprs = new HashMap<Byte, List<ExprNodeDesc>>();
        cloneExprs.putAll(this.getExprs());
        ret.setExprs(cloneExprs);
        HashMap<Byte, List<ExprNodeDesc>> cloneFilters = new HashMap<Byte, List<ExprNodeDesc>>();
        cloneFilters.putAll(this.getFilters());
        ret.setFilters(cloneFilters);
        ret.setConds((JoinCondDesc[])this.getConds().clone());
        ret.setNoOuterJoin(this.getNoOuterJoin());
        ret.setNullSafes(this.getNullSafes());
        ret.setHandleSkewJoin(this.handleSkewJoin);
        ret.setSkewKeyDefinition(this.getSkewKeyDefinition());
        ret.setTagOrder((Byte[])this.getTagOrder().clone());
        if (this.getKeyTableDesc() != null) {
            ret.setKeyTableDesc((TableDesc)this.getKeyTableDesc().clone());
        }
        if (this.getBigKeysDirMap() != null) {
            HashMap<Byte, Path> cloneBigKeysDirMap = new HashMap<Byte, Path>();
            cloneBigKeysDirMap.putAll(this.getBigKeysDirMap());
            ret.setBigKeysDirMap(cloneBigKeysDirMap);
        }
        if (this.getSmallKeysDirMap() != null) {
            HashMap<Byte, Map<Byte, Path>> cloneSmallKeysDirMap = new HashMap<Byte, Map<Byte, Path>>();
            cloneSmallKeysDirMap.putAll(this.getSmallKeysDirMap());
            ret.setSmallKeysDirMap(cloneSmallKeysDirMap);
        }
        if (this.getSkewKeysValuesTables() != null) {
            HashMap<Byte, TableDesc> cloneSkewKeysValuesTables = new HashMap<Byte, TableDesc>();
            cloneSkewKeysValuesTables.putAll(this.getSkewKeysValuesTables());
            ret.setSkewKeysValuesTables(cloneSkewKeysValuesTables);
        }
        if (this.getOutputColumnNames() != null) {
            ArrayList<String> cloneOutputColumnNames = new ArrayList<String>();
            cloneOutputColumnNames.addAll(this.getOutputColumnNames());
            ret.setOutputColumnNames(cloneOutputColumnNames);
        }
        if (this.getReversedExprs() != null) {
            HashMap<String, Byte> cloneReversedExprs = new HashMap<String, Byte>();
            cloneReversedExprs.putAll(this.getReversedExprs());
            ret.setReversedExprs(cloneReversedExprs);
        }
        return ret;
    }

    public JoinDesc(JoinDesc clone) {
        this.bigKeysDirMap = clone.bigKeysDirMap;
        this.conds = clone.conds;
        this.exprs = clone.exprs;
        this.nullsafes = clone.nullsafes;
        this.handleSkewJoin = clone.handleSkewJoin;
        this.keyTableDesc = clone.keyTableDesc;
        this.noOuterJoin = clone.noOuterJoin;
        this.outputColumnNames = clone.outputColumnNames;
        this.reversedExprs = clone.reversedExprs;
        this.skewKeyDefinition = clone.skewKeyDefinition;
        this.skewKeysValuesTables = clone.skewKeysValuesTables;
        this.smallKeysDirMap = clone.smallKeysDirMap;
        this.tagOrder = clone.tagOrder;
        this.filters = clone.filters;
        this.filterMap = clone.filterMap;
        this.statistics = clone.statistics;
    }

    public Map<Byte, List<ExprNodeDesc>> getExprs() {
        return this.exprs;
    }

    public Map<String, Byte> getReversedExprs() {
        return this.reversedExprs;
    }

    public void setReversedExprs(Map<String, Byte> reversedExprs) {
        this.reversedExprs = reversedExprs;
    }

    @Explain(displayName="keys")
    public Map<Byte, String> getKeysString() {
        if (this.joinKeys == null) {
            return null;
        }
        LinkedHashMap<Byte, String> keyMap = new LinkedHashMap<Byte, String>();
        for (byte i = 0; i < this.joinKeys.length; i = (byte)(i + 1)) {
            keyMap.put(i, PlanUtils.getExprListString(Arrays.asList(this.joinKeys[i])));
        }
        return keyMap;
    }

    @Explain(displayName="keys", explainLevels={Explain.Level.USER})
    public Map<Byte, String> getUserLevelExplainKeysString() {
        if (this.joinKeys == null) {
            return null;
        }
        LinkedHashMap<Byte, String> keyMap = new LinkedHashMap<Byte, String>();
        for (byte i = 0; i < this.joinKeys.length; i = (byte)(i + 1)) {
            keyMap.put(i, PlanUtils.getExprListString(Arrays.asList(this.joinKeys[i]), true));
        }
        return keyMap;
    }

    public void setExprs(Map<Byte, List<ExprNodeDesc>> exprs) {
        this.exprs = exprs;
    }

    @Explain(displayName="filter predicates")
    public Map<Byte, String> getFiltersStringMap() {
        if (this.getFilters() == null || this.getFilters().size() == 0) {
            return null;
        }
        LinkedHashMap<Byte, String> ret = new LinkedHashMap<Byte, String>();
        boolean filtersPresent = false;
        for (Map.Entry<Byte, List<ExprNodeDesc>> ent : this.getFilters().entrySet()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            if (ent.getValue() != null) {
                if (ent.getValue().size() != 0) {
                    filtersPresent = true;
                }
                for (ExprNodeDesc expr : ent.getValue()) {
                    if (!first) {
                        sb.append(" ");
                    }
                    first = false;
                    sb.append("{");
                    sb.append(expr.getExprString());
                    sb.append("}");
                }
            }
            ret.put(ent.getKey(), sb.toString());
        }
        if (filtersPresent) {
            return ret;
        }
        return null;
    }

    public Map<Byte, List<ExprNodeDesc>> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<Byte, List<ExprNodeDesc>> filters) {
        this.filters = filters;
    }

    @Explain(displayName="outputColumnNames")
    public List<String> getOutputColumnNames() {
        return this.outputColumnNames;
    }

    @Explain(displayName="Output", explainLevels={Explain.Level.USER})
    public List<String> getUserLevelExplainOutputColumnNames() {
        return this.outputColumnNames;
    }

    public void setOutputColumnNames(List<String> outputColumnNames) {
        this.outputColumnNames = outputColumnNames;
    }

    public boolean getNoOuterJoin() {
        return this.noOuterJoin;
    }

    public void setNoOuterJoin(boolean noOuterJoin) {
        this.noOuterJoin = noOuterJoin;
    }

    @Explain(displayName="condition map", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public List<JoinCondDesc> getCondsList() {
        if (this.conds == null) {
            return null;
        }
        ArrayList<JoinCondDesc> l = new ArrayList<JoinCondDesc>();
        for (JoinCondDesc cond : this.conds) {
            l.add(cond);
        }
        return l;
    }

    public ExprNodeDesc[][] getJoinKeys() {
        return this.joinKeys;
    }

    public JoinCondDesc[] getConds() {
        return this.conds;
    }

    public void setConds(JoinCondDesc[] conds) {
        this.conds = conds;
    }

    public Byte[] getTagOrder() {
        return this.tagOrder;
    }

    public void setTagOrder(Byte[] tagOrder) {
        this.tagOrder = tagOrder;
    }

    @Explain(displayName="handleSkewJoin", displayOnlyOnTrue=true)
    public boolean getHandleSkewJoin() {
        return this.handleSkewJoin;
    }

    public void setHandleSkewJoin(boolean handleSkewJoin) {
        this.handleSkewJoin = handleSkewJoin;
    }

    public Map<Byte, Path> getBigKeysDirMap() {
        return this.bigKeysDirMap;
    }

    public void setBigKeysDirMap(Map<Byte, Path> bigKeysDirMap) {
        this.bigKeysDirMap = bigKeysDirMap;
    }

    public Map<Byte, Map<Byte, Path>> getSmallKeysDirMap() {
        return this.smallKeysDirMap;
    }

    public void setSmallKeysDirMap(Map<Byte, Map<Byte, Path>> smallKeysDirMap) {
        this.smallKeysDirMap = smallKeysDirMap;
    }

    public int getSkewKeyDefinition() {
        return this.skewKeyDefinition;
    }

    public void setSkewKeyDefinition(int skewKeyDefinition) {
        this.skewKeyDefinition = skewKeyDefinition;
    }

    public Map<Byte, TableDesc> getSkewKeysValuesTables() {
        return this.skewKeysValuesTables;
    }

    public void setSkewKeysValuesTables(Map<Byte, TableDesc> skewKeysValuesTables) {
        this.skewKeysValuesTables = skewKeysValuesTables;
    }

    public boolean isNoOuterJoin() {
        return this.noOuterJoin;
    }

    public void setKeyTableDesc(TableDesc keyTblDesc) {
        this.keyTableDesc = keyTblDesc;
    }

    public TableDesc getKeyTableDesc() {
        return this.keyTableDesc;
    }

    public boolean[] getNullSafes() {
        return this.nullsafes;
    }

    public void setNullSafes(boolean[] nullSafes) {
        this.nullsafes = nullSafes;
    }

    @Explain(displayName="nullSafes")
    public String getNullSafeString() {
        if (this.nullsafes == null) {
            return null;
        }
        boolean hasNS = false;
        for (boolean ns : this.nullsafes) {
            hasNS |= ns;
        }
        return hasNS ? Arrays.toString(this.nullsafes) : null;
    }

    public int[][] getFilterMap() {
        return this.filterMap;
    }

    public void setFilterMap(int[][] filterMap) {
        this.filterMap = filterMap;
    }

    @Explain(displayName="filter mappings", explainLevels={Explain.Level.EXTENDED})
    public Map<Integer, String> getFilterMapString() {
        return this.toCompactString(this.filterMap);
    }

    protected Map<Integer, String> toCompactString(int[][] filterMap) {
        if (filterMap == null) {
            return null;
        }
        filterMap = this.compactFilter(filterMap);
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        for (int i = 0; i < filterMap.length; ++i) {
            if (filterMap[i] == null) continue;
            result.put(i, Arrays.toString(filterMap[i]));
        }
        return result.isEmpty() ? null : result;
    }

    private int[][] compactFilter(int[][] filterMap) {
        if (filterMap == null) {
            return null;
        }
        for (int i = 0; i < filterMap.length; ++i) {
            if (filterMap[i] == null) continue;
            boolean noFilter = true;
            for (int j = 1; j < filterMap[i].length; j += 2) {
                if (filterMap[i][j] <= 0) continue;
                noFilter = false;
                break;
            }
            if (!noFilter) continue;
            filterMap[i] = null;
        }
        for (int[] mapping : filterMap) {
            if (mapping == null) continue;
            return filterMap;
        }
        return null;
    }

    public int getTagLength() {
        int tagLength = -1;
        for (byte tag : this.getExprs().keySet()) {
            tagLength = Math.max(tagLength, tag + 1);
        }
        return tagLength;
    }

    public <T> T[] convertToArray(Map<Byte, T> source, Class<T> compType) {
        Object[] result = (Object[])Array.newInstance(compType, this.getTagLength());
        for (Map.Entry<Byte, T> entry : source.entrySet()) {
            result[entry.getKey().byteValue()] = entry.getValue();
        }
        return result;
    }

    public boolean isFixedAsSorted() {
        return this.fixedAsSorted;
    }

    public void setFixedAsSorted(boolean fixedAsSorted) {
        this.fixedAsSorted = fixedAsSorted;
    }

    public String[] getLeftAliases() {
        return this.leftAliases;
    }

    public String[] getBaseSrc() {
        return this.baseSrc;
    }

    public void setBaseSrc(String[] baseSrc) {
        this.baseSrc = baseSrc;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getMapAliases() {
        return this.mapAliases;
    }

    public Map<String, Operator<? extends OperatorDesc>> getAliasToOpInfo() {
        return this.aliasToOpInfo;
    }

    public void setAliasToOpInfo(Map<String, Operator<? extends OperatorDesc>> aliasToOpInfo) {
        this.aliasToOpInfo = aliasToOpInfo;
    }

    public boolean isLeftInputJoin() {
        return this.leftInputJoin;
    }

    public String getLeftAlias() {
        return this.leftAlias;
    }

    public void setLeftAlias(String leftAlias) {
        this.leftAlias = leftAlias;
    }

    public String[] getRightAliases() {
        return this.rightAliases;
    }

    public void setRightAliases(String[] rightAliases) {
        this.rightAliases = rightAliases;
    }

    public List<String> getStreamAliases() {
        return this.streamAliases;
    }

    public boolean isMapSideJoin() {
        return this.mapSideJoin;
    }

    public void setQBJoinTreeProps(JoinDesc joinDesc) {
        this.leftAlias = joinDesc.leftAlias;
        this.leftAliases = joinDesc.leftAliases;
        this.rightAliases = joinDesc.rightAliases;
        this.baseSrc = joinDesc.baseSrc;
        this.id = joinDesc.id;
        this.mapSideJoin = joinDesc.mapSideJoin;
        this.mapAliases = joinDesc.mapAliases;
        this.aliasToOpInfo = joinDesc.aliasToOpInfo;
        this.leftInputJoin = joinDesc.leftInputJoin;
        this.streamAliases = joinDesc.streamAliases;
    }

    public void setQBJoinTreeProps(QBJoinTree joinTree) {
        this.leftAlias = joinTree.getLeftAlias();
        this.leftAliases = joinTree.getLeftAliases();
        this.rightAliases = joinTree.getRightAliases();
        this.baseSrc = joinTree.getBaseSrc();
        this.id = joinTree.getId();
        this.mapSideJoin = joinTree.isMapSideJoin();
        this.mapAliases = joinTree.getMapAliases();
        this.aliasToOpInfo = joinTree.getAliasToOpInfo();
        this.leftInputJoin = joinTree.getJoinSrc() != null;
        this.streamAliases = joinTree.getStreamAliases();
    }

    public void cloneQBJoinTreeProps(JoinDesc joinDesc) {
        this.leftAlias = joinDesc.leftAlias;
        this.leftAliases = joinDesc.leftAliases == null ? null : (String[])joinDesc.leftAliases.clone();
        this.rightAliases = joinDesc.rightAliases == null ? null : (String[])joinDesc.rightAliases.clone();
        this.baseSrc = joinDesc.baseSrc == null ? null : (String[])joinDesc.baseSrc.clone();
        this.id = joinDesc.id;
        this.mapSideJoin = joinDesc.mapSideJoin;
        this.mapAliases = joinDesc.mapAliases == null ? null : new ArrayList<String>(joinDesc.mapAliases);
        this.aliasToOpInfo = new HashMap<String, Operator<? extends OperatorDesc>>(joinDesc.aliasToOpInfo);
        this.leftInputJoin = joinDesc.leftInputJoin;
        this.streamAliases = joinDesc.streamAliases == null ? null : new ArrayList<String>(joinDesc.streamAliases);
    }
}

