/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.LoadDesc;

public class LoadFileDesc
extends LoadDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Path targetDir;
    private boolean isDfsDir;
    private String columns;
    private String columnTypes;
    private String destinationCreateTable;

    public LoadFileDesc() {
    }

    public LoadFileDesc(CreateTableDesc createTableDesc, Path sourcePath, Path targetDir, boolean isDfsDir, String columns, String columnTypes) {
        this(sourcePath, targetDir, isDfsDir, columns, columnTypes);
        if (createTableDesc != null && createTableDesc.getDatabaseName() != null && createTableDesc.getTableName() != null) {
            this.destinationCreateTable = (createTableDesc.getTableName().contains(".") ? "" : createTableDesc.getDatabaseName() + ".") + createTableDesc.getTableName();
        }
    }

    public LoadFileDesc(Path sourcePath, Path targetDir, boolean isDfsDir, String columns, String columnTypes) {
        super(sourcePath);
        this.targetDir = targetDir;
        this.isDfsDir = isDfsDir;
        this.columns = columns;
        this.columnTypes = columnTypes;
    }

    @Explain(displayName="destination")
    public Path getTargetDir() {
        return this.targetDir;
    }

    public void setTargetDir(Path targetDir) {
        this.targetDir = targetDir;
    }

    @Explain(displayName="hdfs directory")
    public boolean getIsDfsDir() {
        return this.isDfsDir;
    }

    public void setIsDfsDir(boolean isDfsDir) {
        this.isDfsDir = isDfsDir;
    }

    public String getColumns() {
        return this.columns;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public String getColumnTypes() {
        return this.columnTypes;
    }

    public void setColumnTypes(String columnTypes) {
        this.columnTypes = columnTypes;
    }

    public String getDestinationCreateTable() {
        return this.destinationCreateTable;
    }
}

