/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import org.apache.hadoop.hive.ql.plan.AbstractVectorDesc;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class VectorMapJoinDesc
extends AbstractVectorDesc {
    private static long serialVersionUID = 1L;
    private HashTableImplementationType hashTableImplementationType;
    private HashTableKind hashTableKind;
    private HashTableKeyType hashTableKeyType;
    private boolean minMaxEnabled;

    public VectorMapJoinDesc() {
        this.hashTableImplementationType = HashTableImplementationType.NONE;
        this.hashTableKind = HashTableKind.NONE;
        this.hashTableKeyType = HashTableKeyType.NONE;
        this.minMaxEnabled = false;
    }

    public VectorMapJoinDesc(VectorMapJoinDesc clone) {
        this.hashTableImplementationType = clone.hashTableImplementationType;
        this.hashTableKind = clone.hashTableKind;
        this.hashTableKeyType = clone.hashTableKeyType;
        this.minMaxEnabled = clone.minMaxEnabled;
    }

    public HashTableImplementationType hashTableImplementationType() {
        return this.hashTableImplementationType;
    }

    public void setHashTableImplementationType(HashTableImplementationType hashTableImplementationType) {
        this.hashTableImplementationType = hashTableImplementationType;
    }

    public HashTableKind hashTableKind() {
        return this.hashTableKind;
    }

    public void setHashTableKind(HashTableKind hashTableKind) {
        this.hashTableKind = hashTableKind;
    }

    public HashTableKeyType hashTableKeyType() {
        return this.hashTableKeyType;
    }

    public void setHashTableKeyType(HashTableKeyType hashTableKeyType) {
        this.hashTableKeyType = hashTableKeyType;
    }

    public boolean minMaxEnabled() {
        return this.minMaxEnabled;
    }

    public void setMinMaxEnabled(boolean minMaxEnabled) {
        this.minMaxEnabled = minMaxEnabled;
    }

    public static enum HashTableKeyType {
        NONE,
        BOOLEAN,
        BYTE,
        SHORT,
        INT,
        LONG,
        STRING,
        MULTI_KEY;


        public PrimitiveTypeInfo getPrimitiveTypeInfo() {
            switch (this) {
                case BOOLEAN: {
                    return TypeInfoFactory.booleanTypeInfo;
                }
                case BYTE: {
                    return TypeInfoFactory.byteTypeInfo;
                }
                case INT: {
                    return TypeInfoFactory.intTypeInfo;
                }
                case LONG: {
                    return TypeInfoFactory.longTypeInfo;
                }
                case NONE: {
                    return TypeInfoFactory.voidTypeInfo;
                }
                case SHORT: {
                    return TypeInfoFactory.shortTypeInfo;
                }
                case STRING: {
                    return TypeInfoFactory.stringTypeInfo;
                }
            }
            return null;
        }
    }

    public static enum HashTableKind {
        NONE,
        HASH_SET,
        HASH_MULTISET,
        HASH_MAP;

    }

    public static enum HashTableImplementationType {
        NONE,
        OPTIMIZED,
        FAST;

    }
}

