/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.ptf;

import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;

public class RangeBoundaryDef
extends BoundaryDef {
    private int amt;
    private final int relativeOffset;

    public RangeBoundaryDef(WindowingSpec.Direction direction, int amt) {
        this.direction = direction;
        this.amt = amt;
        switch (this.direction) {
            case PRECEDING: {
                this.relativeOffset = -amt;
                break;
            }
            case FOLLOWING: {
                this.relativeOffset = amt;
                break;
            }
            default: {
                this.relativeOffset = 0;
            }
        }
    }

    public int compareTo(BoundaryDef other) {
        int c = this.getDirection().compareTo(other.getDirection());
        if (c != 0) {
            return c;
        }
        RangeBoundaryDef rb = (RangeBoundaryDef)other;
        return this.direction == WindowingSpec.Direction.PRECEDING ? rb.amt - this.amt : this.amt - rb.amt;
    }

    @Override
    public int getAmt() {
        return this.amt;
    }

    @Override
    public boolean isPreceding() {
        return this.direction == WindowingSpec.Direction.PRECEDING;
    }

    @Override
    public boolean isFollowing() {
        return this.direction == WindowingSpec.Direction.FOLLOWING;
    }

    @Override
    public int getRelativeOffset() {
        return this.relativeOffset;
    }
}

