/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColumnProjectionUtils {
    public static final Logger LOG = LoggerFactory.getLogger(ColumnProjectionUtils.class);
    public static final String READ_COLUMN_IDS_CONF_STR = "hive.io.file.readcolumn.ids";
    public static final String READ_ALL_COLUMNS = "hive.io.file.read.all.columns";
    public static final String READ_COLUMN_NAMES_CONF_STR = "hive.io.file.readcolumn.names";
    private static final String READ_COLUMN_IDS_CONF_STR_DEFAULT = "";
    private static final boolean READ_ALL_COLUMNS_DEFAULT = true;
    private static final Joiner CSV_JOINER = Joiner.on(",").skipNulls();

    @Deprecated
    public static void setFullyReadColumns(Configuration conf) {
        ColumnProjectionUtils.setReadAllColumns(conf);
    }

    @Deprecated
    @VisibleForTesting
    public static void setReadColumnIDs(Configuration conf, List<Integer> ids) {
        ColumnProjectionUtils.setReadColumnIDConf(conf, READ_COLUMN_IDS_CONF_STR_DEFAULT);
        ColumnProjectionUtils.appendReadColumns(conf, ids);
    }

    @Deprecated
    public static void appendReadColumnIDs(Configuration conf, List<Integer> ids) {
        ColumnProjectionUtils.appendReadColumns(conf, ids);
    }

    public static void setReadAllColumns(Configuration conf) {
        conf.setBoolean(READ_ALL_COLUMNS, true);
        ColumnProjectionUtils.setReadColumnIDConf(conf, READ_COLUMN_IDS_CONF_STR_DEFAULT);
    }

    public static boolean isReadAllColumns(Configuration conf) {
        return conf.getBoolean(READ_ALL_COLUMNS, true);
    }

    public static void setReadColumns(Configuration conf, List<Integer> ids) {
        ColumnProjectionUtils.setReadColumnIDConf(conf, READ_COLUMN_IDS_CONF_STR_DEFAULT);
        ColumnProjectionUtils.appendReadColumns(conf, ids);
    }

    public static void appendReadColumns(Configuration conf, List<Integer> ids) {
        String id = ColumnProjectionUtils.toReadColumnIDString(ids);
        String old = conf.get(READ_COLUMN_IDS_CONF_STR, null);
        String newConfStr = id;
        if (old != null && !old.isEmpty()) {
            newConfStr = newConfStr + "," + old;
        }
        ColumnProjectionUtils.setReadColumnIDConf(conf, newConfStr);
        conf.setBoolean(READ_ALL_COLUMNS, false);
    }

    public static void appendReadColumns(Configuration conf, List<Integer> ids, List<String> names) {
        if (ids.size() != names.size()) {
            LOG.warn("Read column counts do not match: " + ids.size() + " ids, " + names.size() + " names");
        }
        ColumnProjectionUtils.appendReadColumns(conf, ids);
        ColumnProjectionUtils.appendReadColumnNames(conf, names);
    }

    public static void appendReadColumns(StringBuilder readColumnsBuffer, StringBuilder readColumnNamesBuffer, List<Integer> ids, List<String> names) {
        CSV_JOINER.appendTo(readColumnsBuffer, (Iterable<?>)ids);
        CSV_JOINER.appendTo(readColumnNamesBuffer, (Iterable<?>)names);
    }

    public static List<Integer> getReadColumnIDs(Configuration conf) {
        String skips = conf.get(READ_COLUMN_IDS_CONF_STR, READ_COLUMN_IDS_CONF_STR_DEFAULT);
        String[] list = StringUtils.split((String)skips);
        ArrayList<Integer> result = new ArrayList<Integer>(list.length);
        for (String element : list) {
            Integer toAdd = Integer.parseInt(element);
            if (result.contains(toAdd)) continue;
            result.add(toAdd);
        }
        return result;
    }

    public static String[] getReadColumnNames(Configuration conf) {
        String colNames = conf.get(READ_COLUMN_NAMES_CONF_STR, READ_COLUMN_IDS_CONF_STR_DEFAULT);
        if (colNames != null && !colNames.isEmpty()) {
            return colNames.split(",");
        }
        return new String[0];
    }

    private static void setReadColumnIDConf(Configuration conf, String id) {
        if (id.trim().isEmpty()) {
            conf.set(READ_COLUMN_IDS_CONF_STR, READ_COLUMN_IDS_CONF_STR_DEFAULT);
        } else {
            conf.set(READ_COLUMN_IDS_CONF_STR, id);
        }
    }

    private static void appendReadColumnNames(Configuration conf, List<String> cols) {
        String old = conf.get(READ_COLUMN_NAMES_CONF_STR, READ_COLUMN_IDS_CONF_STR_DEFAULT);
        StringBuilder result = new StringBuilder(old);
        boolean first = old.isEmpty();
        for (String col : cols) {
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            result.append(col);
        }
        conf.set(READ_COLUMN_NAMES_CONF_STR, result.toString());
    }

    private static String toReadColumnIDString(List<Integer> ids) {
        String id = READ_COLUMN_IDS_CONF_STR_DEFAULT;
        for (int i = 0; i < ids.size(); ++i) {
            id = i == 0 ? id + ids.get(i) : id + "," + ids.get(i);
        }
        return id;
    }

    private ColumnProjectionUtils() {
    }
}

