/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.DelegatedObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;

public class DelegatedUnionObjectInspector
implements UnionObjectInspector {
    private UnionObjectInspector delegate;
    private List<ObjectInspector> children;

    protected DelegatedUnionObjectInspector() {
    }

    public DelegatedUnionObjectInspector(UnionObjectInspector delegate) {
        this.delegate = delegate;
    }

    public void reset(UnionObjectInspector current) {
        this.delegate = current;
        if (this.children != null) {
            int index = 0;
            List<ObjectInspector> newOIs = this.delegate.getObjectInspectors();
            for (ObjectInspector child : this.children) {
                DelegatedObjectInspectorFactory.reset(child, newOIs.get(index++));
            }
        }
    }

    @Override
    public List<ObjectInspector> getObjectInspectors() {
        if (this.children != null || this.delegate.getObjectInspectors() == null) {
            return this.children;
        }
        List<ObjectInspector> inspectors = this.delegate.getObjectInspectors();
        ArrayList<ObjectInspector> delegated = new ArrayList<ObjectInspector>();
        for (ObjectInspector inspector : inspectors) {
            delegated.add(DelegatedObjectInspectorFactory.wrap(inspector));
        }
        this.children = delegated;
        return this.children;
    }

    @Override
    public byte getTag(Object o) {
        return this.delegate.getTag(o);
    }

    @Override
    public Object getField(Object o) {
        return this.delegate.getField(o);
    }

    @Override
    public String getTypeName() {
        return this.delegate.getTypeName();
    }

    @Override
    public ObjectInspector.Category getCategory() {
        return this.delegate.getCategory();
    }
}

