/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaManagerTest$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001\u000f\t12\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013%Q#\u0001\u0003uS6,W#\u0001\f\u0011\u0005]\tS\"\u0001\r\u000b\u0005eQ\u0012!B;uS2\u001c(BA\u000e\u001d\u0003\u0019\u0019w.\\7p]*\u0011Q!\b\u0006\u0003=}\ta!\u00199bG\",'\"\u0001\u0011\u0002\u0007=\u0014x-\u0003\u0002#1\tAQj\\2l)&lW\r\u0003\u0004%\u0001\u0001\u0006IAF\u0001\u0006i&lW\r\t\u0005\bM\u0001\u0011\r\u0011\"\u0003(\u0003\u0019\u0019wN\u001c4jOV\t\u0001\u0006\u0005\u0002\u0013S%\u0011!F\u0001\u0002\u0019\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'oQ8oM&<\u0007B\u0002\u0017\u0001A\u0003%\u0001&A\u0004d_:4\u0017n\u001a\u0011\t\u000f9\u0002\u0001\u0019!C\u0001_\u0005aa.^7DC2d'-Y2lgV\t\u0001\u0007\u0005\u0002\nc%\u0011!G\u0003\u0002\u0004\u0013:$\bb\u0002\u001b\u0001\u0001\u0004%\t!N\u0001\u0011]Vl7)\u00197mE\u0006\u001c7n]0%KF$\"AN\u001d\u0011\u0005%9\u0014B\u0001\u001d\u000b\u0005\u0011)f.\u001b;\t\u000fi\u001a\u0014\u0011!a\u0001a\u0005\u0019\u0001\u0010J\u0019\t\rq\u0002\u0001\u0015)\u00031\u00035qW/\\\"bY2\u0014\u0017mY6tA!)a\b\u0001C\u0001\u007f\u0005A1-\u00197mE\u0006\u001c7\u000e\u0006\u00027\u0001\")\u0011)\u0010a\u0001a\u0005YA-\u001a7bsRKW.Z't\u0011\u0015\u0019\u0005\u0001\"\u0001E\u00031\u0011WMZ8sK6+G\u000f[8e)\u00051\u0004F\u0001\"G!\t9%*D\u0001I\u0015\tIu$A\u0003kk:LG/\u0003\u0002L\u0011\n1!)\u001a4pe\u0016DQ!\u0014\u0001\u0005\u0002\u0011\u000b\u0001\u0003^3tiF+x\u000e^1QCJ\u001c\u0018N\\4)\u00051{\u0005CA$Q\u0013\t\t\u0006J\u0001\u0003UKN$\b\"B*\u0001\t\u0003!\u0015A\u0005;fgR\fVo\u001c;b-&|G.\u0019;j_:D#AU(\t\u000bY\u0003A\u0011A,\u0002\u00159,w/T3ue&\u001c7/F\u0001Y!\tIF,D\u0001[\u0015\tY&$A\u0004nKR\u0014\u0018nY:\n\u0005uS&aB'fiJL7m\u001d")
public class ClientQuotaManagerTest {
    private final MockTime kafka$server$ClientQuotaManagerTest$$time = new MockTime();
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(500L, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
    private int numCallbacks = 0;

    public MockTime kafka$server$ClientQuotaManagerTest$$time() {
        return this.kafka$server$ClientQuotaManagerTest$$time;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    public int numCallbacks() {
        return this.numCallbacks;
    }

    public void numCallbacks_$eq(int x$1) {
        this.numCallbacks = x$1;
    }

    public void callback(int delayTimeMs) {
        this.numCallbacks_$eq(this.numCallbacks() + 1);
    }

    @Before
    public void beforeMethod() {
        this.numCallbacks_$eq(0);
    }

    @Test
    public void testQuotaParsing() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.newMetrics(), "producer", (Time)this.kafka$server$ClientQuotaManagerTest$$time());
        clientMetrics.updateQuota("p1", new Quota(2000.0, true));
        clientMetrics.updateQuota("p2", new Quota(4000.0, true));
        try {
            Assert.assertEquals((String)"Default producer quota should be 500", (Object)new Quota(500.0, true), (Object)clientMetrics.quota("random-client-id"));
            Assert.assertEquals((String)"Should return the overridden value (2000)", (Object)new Quota(2000.0, true), (Object)clientMetrics.quota("p1"));
            Assert.assertEquals((String)"Should return the overridden value (4000)", (Object)new Quota(4000.0, true), (Object)clientMetrics.quota("p2"));
            int throttleTimeMs = clientMetrics.recordAndMaybeThrottle("p1", 2500 * this.config().numQuotaSamples(), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be > 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota("p1", new Quota(3000.0, true));
            Assert.assertEquals((String)"Should return the newly overridden value (3000)", (Object)new Quota(3000.0, true), (Object)clientMetrics.quota("p1"));
            throttleTimeMs = clientMetrics.recordAndMaybeThrottle("p1", 0, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (long)0L, (long)throttleTimeMs);
            clientMetrics.updateQuota("p1", new Quota(500.0, true));
            Assert.assertEquals((String)"Should return the default value (500)", (Object)new Quota(500.0, true), (Object)clientMetrics.quota("p1"));
            throttleTimeMs = clientMetrics.recordAndMaybeThrottle("p1", 0, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be > 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (throttleTimeMs > 0 ? 1 : 0) != 0);
            return;
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testQuotaViolation() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, "producer", (Time)this.kafka$server$ClientQuotaManagerTest$$time());
        KafkaMetric queueSizeMetric = (KafkaMetric)metrics.metrics().get(new MetricName("queue-size", "producer", ""));
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, clientMetrics){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager clientMetrics$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.clientMetrics$1.recordAndMaybeThrottle("unknown", 400, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testQuotaViolation$1 $outer;

                        public final void apply(int delayTimeMs) {
                            this.apply$mcVI$sp(delayTimeMs);
                        }

                        public void apply$mcVI$sp(int delayTimeMs) {
                            this.$outer.kafka$server$ClientQuotaManagerTest$$anonfun$$$outer().callback(delayTimeMs);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }

                public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.clientMetrics$1 = clientMetrics$1;
                }
            });
            Assert.assertEquals((long)10L, (long)this.numCallbacks());
            Assert.assertEquals((long)0L, (long)((int)queueSizeMetric.value()));
            this.kafka$server$ClientQuotaManagerTest$$time().sleep(500L);
            int sleepTime = clientMetrics.recordAndMaybeThrottle("unknown", 2300, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertEquals((String)"Should be throttled", (long)2100L, (long)sleepTime);
            Assert.assertEquals((long)1L, (long)((int)queueSizeMetric.value()));
            clientMetrics.throttledRequestReaper().doWork();
            Assert.assertEquals((long)10L, (long)this.numCallbacks());
            this.kafka$server$ClientQuotaManagerTest$$time().sleep((long)sleepTime);
            clientMetrics.throttledRequestReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)queueSizeMetric.value()));
            Assert.assertEquals((long)11L, (long)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, clientMetrics){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager clientMetrics$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.clientMetrics$1.recordAndMaybeThrottle("unknown", 400, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testQuotaViolation$2 $outer;

                        public final void apply(int delayTimeMs) {
                            this.apply$mcVI$sp(delayTimeMs);
                        }

                        public void apply$mcVI$sp(int delayTimeMs) {
                            this.$outer.kafka$server$ClientQuotaManagerTest$$anonfun$$$outer().callback(delayTimeMs);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }

                public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.clientMetrics$1 = clientMetrics$1;
                }
            });
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)clientMetrics.recordAndMaybeThrottle("unknown", 0, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(int delayTimeMs) {
                    this.apply$mcVI$sp(delayTimeMs);
                }

                public void apply$mcVI$sp(int delayTimeMs) {
                    this.$outer.callback(delayTimeMs);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }));
            return;
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    public Metrics newMetrics() {
        return new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.kafka$server$ClientQuotaManagerTest$$time());
    }
}

