/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import kafka.cluster.Replica;
import kafka.common.TopicAndPartition;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.serializer.StringEncoder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.OffsetCheckpoint;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.utils.CoreUtils$;
import kafka.utils.IntEncoder;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u0001\u0003\u0001\u001d\u0011q\u0002T8h%\u0016\u001cwN^3ssR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\n\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u0011!BS+oSR\u001cV/\u001b;f!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0002{W&\u0011q\u0003\u0006\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u0014e\u0016\u0004H.[2b\u0019\u0006<G+[7f\u001b\u0006DXj]\u000b\u0002AA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t!Aj\u001c8h\u0011\u00199\u0003\u0001)A\u0005A\u0005!\"/\u001a9mS\u000e\fG*Y4US6,W*\u0019=Ng\u0002Bq!\u000b\u0001C\u0002\u0013\u0005q$A\u000bsKBd\u0017nY1MC\u001el\u0015\r_'fgN\fw-Z:\t\r-\u0002\u0001\u0015!\u0003!\u0003Y\u0011X\r\u001d7jG\u0006d\u0015mZ'bq6+7o]1hKN\u0004\u0003bB\u0017\u0001\u0005\u0004%\tAL\u0001\u0016e\u0016\u0004H.[2b\r\u0016$8\r[,bSRl\u0015\r_'t+\u0005y\u0003CA\u00111\u0013\t\t$EA\u0002J]RDaa\r\u0001!\u0002\u0013y\u0013A\u0006:fa2L7-\u0019$fi\u000eDw+Y5u\u001b\u0006DXj\u001d\u0011\t\u000fU\u0002!\u0019!C\u0001]\u0005!\"/\u001a9mS\u000e\fg)\u001a;dQ6KgNQ=uKNDaa\u000e\u0001!\u0002\u0013y\u0013!\u0006:fa2L7-\u0019$fi\u000eDW*\u001b8CsR,7\u000f\t\u0005\bs\u0001\u0011\r\u0011\"\u0001;\u0003=yg/\u001a:sS\u0012Lgn\u001a)s_B\u001cX#A\u001e\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014\u0001B;uS2T\u0011\u0001Q\u0001\u0005U\u00064\u0018-\u0003\u0002C{\tQ\u0001K]8qKJ$\u0018.Z:\t\r\u0011\u0003\u0001\u0015!\u0003<\u0003Ayg/\u001a:sS\u0012Lgn\u001a)s_B\u001c\b\u0005C\u0004G\u0001\u0001\u0007I\u0011A$\u0002\u000f\r|gNZ5hgV\t\u0001\nE\u0002J#Rs!AS(\u000f\u0005-sU\"\u0001'\u000b\u000553\u0011A\u0002\u001fs_>$h(C\u0001$\u0013\t\u0001&%A\u0004qC\u000e\\\u0017mZ3\n\u0005I\u001b&aA*fc*\u0011\u0001K\t\t\u00039UK!A\u0016\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b1\u0002\u0001\r\u0011\"\u0001Z\u0003-\u0019wN\u001c4jON|F%Z9\u0015\u0005ik\u0006CA\u0011\\\u0013\ta&E\u0001\u0003V]&$\bb\u00020X\u0003\u0003\u0005\r\u0001S\u0001\u0004q\u0012\n\u0004B\u00021\u0001A\u0003&\u0001*\u0001\u0005d_:4\u0017nZ:!\u0011\u001d\u0011\u0007A1A\u0005\u0002\r\fQ\u0001^8qS\u000e,\u0012\u0001\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0003O~\nA\u0001\\1oO&\u0011\u0011N\u001a\u0002\u0007'R\u0014\u0018N\\4\t\r-\u0004\u0001\u0015!\u0003e\u0003\u0019!x\u000e]5dA!9Q\u000e\u0001b\u0001\n\u0003q\u0013a\u00039beRLG/[8o\u0013\u0012Daa\u001c\u0001!\u0002\u0013y\u0013\u0001\u00049beRLG/[8o\u0013\u0012\u0004\u0003bB9\u0001\u0001\u0004%\tA]\u0001\bg\u0016\u0014h/\u001a:2+\u0005\u0019\bC\u0001\u000fu\u0013\t)(AA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bbB<\u0001\u0001\u0004%\t\u0001_\u0001\fg\u0016\u0014h/\u001a:2?\u0012*\u0017\u000f\u0006\u0002[s\"9aL^A\u0001\u0002\u0004\u0019\bBB>\u0001A\u0003&1/\u0001\u0005tKJ4XM]\u0019!\u0011\u001di\b\u00011A\u0005\u0002I\fqa]3sm\u0016\u0014(\u0007\u0003\u0005\u0000\u0001\u0001\u0007I\u0011AA\u0001\u0003-\u0019XM\u001d<feJzF%Z9\u0015\u0007i\u000b\u0019\u0001C\u0004_}\u0006\u0005\t\u0019A:\t\u000f\u0005\u001d\u0001\u0001)Q\u0005g\u0006A1/\u001a:wKJ\u0014\u0004\u0005C\u0004\u0002\f\u0001!\t!!\u0004\u0002\u0019\r|gNZ5h!J|\u0007o]\u0019\u0016\u0003QCq!!\u0005\u0001\t\u0003\ti!\u0001\u0007d_:4\u0017n\u001a)s_B\u001c(\u0007\u0003\u0005\u0002\u0016\u0001\u0011\r\u0011\"\u0001d\u0003\u001diWm]:bO\u0016Dq!!\u0007\u0001A\u0003%A-\u0001\u0005nKN\u001c\u0018mZ3!\u0011%\ti\u0002\u0001a\u0001\n\u0003\ty\"\u0001\u0005qe>$WoY3s+\t\t\t\u0003E\u0004\u0002$\u0005\u001dr&a\u000b\u000e\u0005\u0005\u0015\"bAA\u000f\t%!\u0011\u0011FA\u0013\u0005!\u0001&o\u001c3vG\u0016\u0014\b\u0003BA\u0017\u0003gq1!IA\u0018\u0013\r\t\tDI\u0001\u0007!J,G-\u001a4\n\u0007%\f)DC\u0002\u00022\tB\u0011\"!\u000f\u0001\u0001\u0004%\t!a\u000f\u0002\u0019A\u0014x\u000eZ;dKJ|F%Z9\u0015\u0007i\u000bi\u0004C\u0005_\u0003o\t\t\u00111\u0001\u0002\"!A\u0011\u0011\t\u0001!B\u0013\t\t#A\u0005qe>$WoY3sA!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0013a\u00025x\r&dW-M\u000b\u0003\u0003\u0013\u00022\u0001HA&\u0013\r\tiE\u0001\u0002\u0011\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]RDq!!\u0015\u0001\t\u0003\t9%A\u0004io\u001aKG.\u001a\u001a\t\u0013\u0005U\u0003\u00011A\u0005\u0002\u0005]\u0013aB:feZ,'o]\u000b\u0003\u00033\u00022!S)t\u0011%\ti\u0006\u0001a\u0001\n\u0003\ty&A\u0006tKJ4XM]:`I\u0015\fHc\u0001.\u0002b!Ia,a\u0017\u0002\u0002\u0003\u0007\u0011\u0011\f\u0005\t\u0003K\u0002\u0001\u0015)\u0003\u0002Z\u0005A1/\u001a:wKJ\u001c\b\u0005C\u0004\u0002j\u0001!\t!a\u001b\u0002\u001dU\u0004H-\u0019;f!J|G-^2feR\t!\fC\u0004\u0002p\u0001!\t%a\u001b\u0002\u000bM,G/\u00169)\t\u00055\u00141\u000f\t\u0005\u0003k\nI(\u0004\u0002\u0002x)\u00111BD\u0005\u0005\u0003w\n9H\u0001\u0004CK\u001a|'/\u001a\u0005\b\u0003\u007f\u0002A\u0011IA6\u0003!!X-\u0019:E_^t\u0007\u0006BA?\u0003\u0007\u0003B!!\u001e\u0002\u0006&!\u0011qQA<\u0005\u0015\te\r^3s\u0011\u001d\tY\t\u0001C\u0001\u0003\u001b\u000b!\u0006^3ti\";6\t[3dWB|\u0017N\u001c;O_\u001a\u000b\u0017\u000e\\;sKN\u001c\u0016N\\4mK2{wmU3h[\u0016tG/F\u0001[Q\u0011\tI)!%\u0011\t\u0005U\u00141S\u0005\u0005\u0003+\u000b9H\u0001\u0003UKN$\bbBAM\u0001\u0011\u0005\u0011QR\u0001-i\u0016\u001cH\u000fS,DQ\u0016\u001c7\u000e]8j]R<\u0016\u000e\u001e5GC&dWO]3t'&tw\r\\3M_\u001e\u001cVmZ7f]RDC!a&\u0002\u0012\"9\u0011q\u0014\u0001\u0005\u0002\u00055\u0015!\f;fgRDuk\u00115fG.\u0004x.\u001b8u\u001d>4\u0015-\u001b7ve\u0016\u001cX*\u001e7uSBdW\rT8h'\u0016<W.\u001a8ug\"\"\u0011QTAI\u0011\u001d\t)\u000b\u0001C\u0001\u0003\u001b\u000bq\u0006^3ti\";6\t[3dWB|\u0017N\u001c;XSRDg)Y5mkJ,7/T;mi&\u0004H.\u001a'pON+w-\\3oiNDC!a)\u0002\u0012\"9\u00111\u0016\u0001\u0005\n\u00055\u0016\u0001D:f]\u0012lUm]:bO\u0016\u001cHc\u0001.\u00020\"I\u0011\u0011WAU!\u0003\u0005\raL\u0001\u0002]\"I\u0011Q\u0017\u0001\u0012\u0002\u0013%\u0011qW\u0001\u0017g\u0016tG-T3tg\u0006<Wm\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0018\u0016\u0004_\u0005m6FAA_!\u0011\ty,!3\u000e\u0005\u0005\u0005'\u0002BAb\u0003\u000b\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001d'%\u0001\u0006b]:|G/\u0019;j_:LA!a3\u0002B\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class LogRecoveryTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final long replicaLagTimeMaxMs;
    private final long replicaLagMaxMessages;
    private final int replicaFetchWaitMaxMs;
    private final int replicaFetchMinBytes;
    private final Properties overridingProps;
    private Seq<KafkaConfig> configs;
    private final String topic;
    private final int partitionId;
    private KafkaServer server1;
    private KafkaServer server2;
    private final String message;
    private Producer<Object, String> producer;
    private Seq<KafkaServer> servers;
    private EmbeddedZookeeper zookeeper;
    private int zkPort;
    private ZkUtils zkUtils;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public int zkPort() {
        return this.zkPort;
    }

    @Override
    public void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    public String confFile() {
        return ZooKeeperTestHarness$class.confFile(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogRecoveryTest logRecoveryTest = this;
        synchronized (logRecoveryTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public long replicaLagMaxMessages() {
        return this.replicaLagMaxMessages;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int replicaFetchMinBytes() {
        return this.replicaFetchMinBytes;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public KafkaServer server1() {
        return this.server1;
    }

    public void server1_$eq(KafkaServer x$1) {
        this.server1 = x$1;
    }

    public KafkaServer server2() {
        return this.server2;
    }

    public void server2_$eq(KafkaServer x$1) {
        this.server2 = x$1;
    }

    public KafkaConfig configProps1() {
        return (KafkaConfig)this.configs().head();
    }

    public KafkaConfig configProps2() {
        return (KafkaConfig)this.configs().last();
    }

    public String message() {
        return this.message;
    }

    public Producer<Object, String> producer() {
        return this.producer;
    }

    public void producer_$eq(Producer<Object, String> x$1) {
        this.producer = x$1;
    }

    public OffsetCheckpoint hwFile1() {
        return new OffsetCheckpoint(new File((String)this.configProps1().logDirs().apply(0), ReplicaManager$.MODULE$.HighWatermarkFilename()));
    }

    public OffsetCheckpoint hwFile2() {
        return new OffsetCheckpoint(new File((String)this.configProps2().logDirs().apply(0), ReplicaManager$.MODULE$.HighWatermarkFilename()));
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public void updateProducer() {
        if (this.producer() != null) {
            this.producer().close();
        }
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), StringEncoder.class.getName(), IntEncoder.class.getName(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5()));
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        this.configs_$eq((Seq<KafkaConfig>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())));
        this.server1_$eq(TestUtils$.MODULE$.createServer(this.configProps1(), TestUtils$.MODULE$.createServer$default$2()));
        this.server2_$eq(TestUtils$.MODULE$.createServer(this.configProps2(), TestUtils$.MODULE$.createServer$default$2()));
        this.servers_$eq((Seq<KafkaServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1(), this.server2()})));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers());
        this.updateProducer();
    }

    @Override
    @After
    public void tearDown() {
        this.producer().close();
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.shutdown();
                CoreUtils$.MODULE$.rm((String)server.config().logDirs().apply(0));
            }
        });
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void testHWCheckpointNoFailuresSingleLogSegment() {
        long numMessages = 2L;
        this.sendMessages((int)numMessages);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numMessages){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final long numMessages$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                int x$4;
                int x$3;
                String x$2;
                ReplicaManager qual$1 = this.$outer.server2().replicaManager();
                return ((Replica)qual$1.getReplica(x$2 = this.$outer.topic(), x$3 = 0, x$4 = qual$1.getReplica$default$3()).get()).highWatermark().messageOffset() == this.numMessages$1;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.numMessages$1 = numMessages$1;
            }
        }, "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.replicaManager().checkpointHighWatermarks();
            }
        });
        long leaderHW = BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((long)numMessages, (long)leaderHW);
        long followerHW = BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((long)numMessages, (long)followerHW);
    }

    @Test
    public void testHWCheckpointWithFailuresSingleLogSegment() {
        Option<Object> leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.sendMessages(1);
        Thread.sleep(1000L);
        LongRef hw = new LongRef(1L);
        this.server1().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        ZkUtils x$5 = this.zkUtils();
        String x$6 = this.topic();
        int x$7 = this.partitionId();
        Option<Object> x$8 = leader;
        long x$9 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$10 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$5, x$6, x$7, x$9, x$8, x$10);
        Assert.assertEquals((String)"Leader must move to broker 1", (long)1L, (long)BoxesRunTime.unboxToInt((Object)leader.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })));
        this.server1().startup();
        this.updateProducer();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertTrue((String)"Leader must remain on broker 1, in case of zookeeper session expiration it can move to broker 0", (leader.isDefined() && (BoxesRunTime.unboxToInt((Object)leader.get()) == 0 || BoxesRunTime.unboxToInt((Object)leader.get()) == 1) ? 1 : 0) != 0);
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.server2().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.server2().startup();
        this.updateProducer();
        ZkUtils x$11 = this.zkUtils();
        String x$12 = this.topic();
        int x$13 = this.partitionId();
        Option<Object> x$14 = leader;
        long x$15 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$16 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$11, x$12, x$13, x$15, x$14, x$16);
        Assert.assertTrue((String)"Leader must remain on broker 0, in case of zookeeper session expiration it can move to broker 1", (leader.isDefined() && (BoxesRunTime.unboxToInt((Object)leader.get()) == 0 || BoxesRunTime.unboxToInt((Object)leader.get()) == 1) ? 1 : 0) != 0);
        this.sendMessages(1);
        ++hw.elem;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final LongRef hw$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                int x$19;
                int x$18;
                String x$17;
                ReplicaManager qual$2 = this.$outer.server2().replicaManager();
                return ((Replica)qual$2.getReplica(x$17 = this.$outer.topic(), x$18 = 0, x$19 = qual$2.getReplica$default$3()).get()).highWatermark().messageOffset() == this.hw$1.elem;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hw$1 = hw$1;
            }
        }, "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.shutdown();
            }
        });
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
    }

    @Test
    public void testHWCheckpointNoFailuresMultipleLogSegments() {
        this.sendMessages(20);
        long hw = 20L;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final long hw$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                int x$22;
                int x$21;
                String x$20;
                ReplicaManager qual$3 = this.$outer.server2().replicaManager();
                return ((Replica)qual$3.getReplica(x$20 = this.$outer.topic(), x$21 = 0, x$22 = qual$3.getReplica$default$3()).get()).highWatermark().messageOffset() == this.hw$2;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hw$2 = hw$2;
            }
        }, "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.shutdown();
            }
        });
        long leaderHW = BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((long)hw, (long)leaderHW);
        long followerHW = BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((long)hw, (long)followerHW);
    }

    @Test
    public void testHWCheckpointWithFailuresMultipleLogSegments() {
        Option<Object> leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.sendMessages(2);
        LongRef hw = new LongRef(2L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final LongRef hw$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                int x$25;
                int x$24;
                String x$23;
                ReplicaManager qual$4 = this.$outer.server2().replicaManager();
                return ((Replica)qual$4.getReplica(x$23 = this.$outer.topic(), x$24 = 0, x$25 = qual$4.getReplica$default$3()).get()).highWatermark().messageOffset() == this.hw$3.elem;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hw$3 = hw$3;
            }
        }, "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3());
        this.server1().shutdown();
        this.server2().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.server2().startup();
        this.updateProducer();
        ZkUtils x$26 = this.zkUtils();
        String x$27 = this.topic();
        int x$28 = this.partitionId();
        Option<Object> x$29 = leader;
        long x$30 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$31 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$26, x$27, x$28, x$30, x$29, x$31);
        Assert.assertEquals((String)"Leader must move to broker 1", (long)1L, (long)BoxesRunTime.unboxToInt((Object)leader.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.server1().startup();
        this.updateProducer();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.sendMessages(2);
        hw.elem += 2L;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ReplicaManager qual$5 = this.$outer.server1().replicaManager();
                String x$32 = this.$outer.topic();
                int x$33 = 0;
                int x$34 = qual$5.getReplica$default$3();
                return qual$5.getReplica(x$32, x$33, x$34).nonEmpty();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "Failed to create replica in follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final LongRef hw$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                int x$37;
                int x$36;
                String x$35;
                ReplicaManager qual$6 = this.$outer.server1().replicaManager();
                return ((Replica)qual$6.getReplica(x$35 = this.$outer.topic(), x$36 = 0, x$37 = qual$6.getReplica$default$3()).get()).highWatermark().messageOffset() == this.hw$3.elem;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hw$3 = hw$3;
            }
        }, "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.shutdown();
            }
        });
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
    }

    private void sendMessages(int n) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.producer().send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(this.$outer.topic(), (Object)BoxesRunTime.boxToInteger((int)0), (Object)this.$outer.message())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private int sendMessages$default$1() {
        return 1;
    }

    public LogRecoveryTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.replicaLagTimeMaxMs = 5000L;
        this.replicaLagMaxMessages = 10L;
        this.replicaFetchWaitMaxMs = 1000;
        this.replicaFetchMinBytes = 20;
        this.overridingProps = new Properties();
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.replicaLagTimeMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchWaitMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchMinBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchMinBytes())).toString());
        this.configs = null;
        this.topic = "new-topic";
        this.partitionId = 0;
        this.server1 = null;
        this.server2 = null;
        this.message = "hello";
        this.producer = null;
        this.servers = (Seq)Seq$.MODULE$.empty();
    }
}

