/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import kafka.consumer.BaseConsumer;
import kafka.consumer.BaseConsumerRecord;
import kafka.tools.ConsoleConsumer;
import kafka.tools.ConsoleConsumer$;
import kafka.tools.MessageFormatter;
import kafka.utils.TestUtils$;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=2A!\u0001\u0002\u0001\u000f\t\u00192i\u001c8t_2,7i\u001c8tk6,'\u000fV3ti*\u00111\u0001B\u0001\u0006i>|Gn\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!A\u0003&V]&$8+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001\u0005\u00061\u0001!\t!G\u0001\"g\"|W\u000f\u001c3MS6LGOU3bIN$v.T1y\u001b\u0016\u001c8/Y4f\u0019&l\u0017\u000e\u001e\u000b\u00025A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t!QK\\5uQ\t9\u0012\u0005\u0005\u0002#I5\t1E\u0003\u0002\f\u001d%\u0011Qe\t\u0002\u0005)\u0016\u001cH\u000fC\u0003(\u0001\u0011\u0005\u0011$\u0001\u0014tQ>,H\u000e\u001a)beN,g+\u00197jI>cGmQ8ogVlWM\u001d,bY&$7i\u001c8gS\u001eD#AJ\u0011\t\u000b)\u0002A\u0011A\r\u0002MMDw.\u001e7e!\u0006\u00148/\u001a,bY&$g*Z<D_:\u001cX/\\3s-\u0006d\u0017\u000eZ\"p]\u001aLw\r\u000b\u0002*C!)Q\u0006\u0001C\u00013\u0005Q2\u000f[8vY\u0012\u0004\u0016M]:f\u0007>tg-[4t\rJ|WNR5mK\"\u0012A&\t")
public class ConsoleConsumerTest
extends JUnitSuite {
    @Test
    public void shouldLimitReadsToMaxMessageLimit() {
        BaseConsumer consumer = (BaseConsumer)EasyMock.createNiceMock(BaseConsumer.class);
        MessageFormatter formatter = (MessageFormatter)EasyMock.createNiceMock(MessageFormatter.class);
        BaseConsumerRecord record = new BaseConsumerRecord("foo", 1, 1L, (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()));
        int messageLimit = 10;
        formatter.writeTo((byte[])EasyMock.anyObject(), (byte[])EasyMock.anyObject(), (PrintStream)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).times(messageLimit);
        EasyMock.expect((Object)consumer.receive()).andReturn((Object)record).times(messageLimit);
        EasyMock.replay((Object[])new Object[]{consumer});
        EasyMock.replay((Object[])new Object[]{formatter});
        ConsoleConsumer$.MODULE$.process(Predef$.MODULE$.int2Integer(messageLimit), formatter, consumer, true);
    }

    @Test
    public void shouldParseValidOldConsumerValidConfig() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:2181", "--topic", "test", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertFalse((boolean)config.useNewConsumer());
        Assert.assertEquals((Object)"localhost:2181", (Object)config.zkConnectionStr());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldParseValidNewConsumerValidConfig() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning", "--new-consumer"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertTrue((boolean)config.useNewConsumer());
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldParseConfigsFromFile() {
        File propsFile = TestUtils$.MODULE$.tempFile();
        FileOutputStream propsStream = new FileOutputStream(propsFile);
        propsStream.write("consumer.timeout.ms=1000".getBytes());
        propsStream.close();
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:2181", "--topic", "test", "--consumer.config", propsFile.getAbsolutePath()});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertEquals((Object)"1000", (Object)config.consumerProps().getProperty("consumer.timeout.ms"));
    }
}

