/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.testng.TestNGExecutor;
import org.apache.maven.surefire.testng.TestSuite;
import org.apache.maven.surefire.testset.TestSetFailedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TestNGXmlTestSuite
extends TestSuite {
    private final List<File> suiteFiles;
    private List<String> suiteFilePaths;
    private final String testSourceDirectory;
    private final Map<String, String> options;
    private final File reportsDirectory;
    private final int skipAfterFailureCount;

    TestNGXmlTestSuite(List<File> suiteFiles, String testSourceDirectory, Map<String, String> confOptions, File reportsDirectory, int skipAfterFailureCount) {
        this.suiteFiles = suiteFiles;
        this.options = confOptions;
        this.testSourceDirectory = testSourceDirectory;
        this.reportsDirectory = reportsDirectory;
        this.skipAfterFailureCount = skipAfterFailureCount;
    }

    void execute(RunListener reporter) throws TestSetFailedException {
        if (this.suiteFilePaths == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        this.startTestSuite(reporter);
        TestNGExecutor.run(this.suiteFilePaths, this.testSourceDirectory, this.options, reporter, this.reportsDirectory, this.skipAfterFailureCount);
        this.finishTestSuite(reporter);
    }

    void locateTestSets() throws TestSetFailedException {
        if (this.suiteFilePaths != null) {
            throw new IllegalStateException("You can't call locateTestSets twice");
        }
        if (this.suiteFiles.isEmpty()) {
            throw new IllegalStateException("No suite files were specified");
        }
        this.suiteFilePaths = new ArrayList<String>();
        for (File suiteFile : this.suiteFiles) {
            if (!suiteFile.isFile()) {
                throw new TestSetFailedException("Suite file " + suiteFile + " is not a valid file");
            }
            this.suiteFilePaths.add(suiteFile.getAbsolutePath());
        }
    }

    @Override
    Map<String, String> getOptions() {
        return this.options;
    }
}

