/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng.conf;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.surefire.testng.conf.Configurator;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.testng.TestNG;
import org.testng.xml.XmlSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDirectConfigurator
implements Configurator {
    final Map<String, Setter> setters;

    AbstractDirectConfigurator() {
        HashMap<String, Setter> options = new HashMap<String, Setter>();
        options.put("junit", new Setter("setJUnit", Boolean.class));
        options.put("threadcount", new Setter("setThreadCount", Integer.TYPE));
        options.put("usedefaultlisteners", new Setter("setUseDefaultListeners", Boolean.TYPE));
        this.setters = options;
    }

    @Override
    public void configure(TestNG testng, Map<String, String> options) throws TestSetFailedException {
        System.out.println("\n\n\n\nCONFIGURING TESTNG\n\n\n\n");
        String listeners = options.remove("listener");
        testng.setUseDefaultListeners(false);
        this.configureInstance(testng, options);
        testng.setListenerClasses(AbstractDirectConfigurator.loadListenerClasses(listeners));
    }

    @Override
    public void configure(XmlSuite suite, Map<String, String> options) throws TestSetFailedException {
        Map<String, String> filtered = this.filterForSuite(options);
        this.configureInstance(suite, filtered);
    }

    protected Map<String, String> filterForSuite(Map<String, String> options) {
        HashMap<String, String> result = new HashMap<String, String>();
        this.addPropIfNotNull(options, result, "parallel");
        this.addPropIfNotNull(options, result, "threadcount");
        return result;
    }

    private void addPropIfNotNull(Map<String, String> options, Map<String, String> result, String prop) {
        if (options.containsKey(prop)) {
            result.put(prop, options.get(prop));
        }
    }

    private void configureInstance(Object testngInstance, Map<String, String> options) {
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            Setter setter = this.setters.get(key);
            if (setter == null) continue;
            try {
                setter.invoke(testngInstance, val);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot set option " + key + " with value " + val, e);
            }
        }
    }

    static List<Class> loadListenerClasses(String listenerClasses) throws TestSetFailedException {
        String[] classNames;
        if (listenerClasses == null || "".equals(listenerClasses.trim())) {
            return new ArrayList<Class>();
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (String className : classNames = listenerClasses.split("\\s*,\\s*(\\r?\\n)?\\s*")) {
            Class<?> clazz = AbstractDirectConfigurator.loadClass(className);
            classes.add(clazz);
        }
        return classes;
    }

    static Class<?> loadClass(String className) throws TestSetFailedException {
        try {
            return Class.forName(className);
        }
        catch (Exception ex) {
            throw new TestSetFailedException("Cannot find listener class " + className, (Throwable)ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Setter {
        private final String setterName;
        private final Class<?> paramClass;

        public Setter(String name, Class<?> clazz) {
            this.setterName = name;
            this.paramClass = clazz;
        }

        public void invoke(Object target, String value) throws Exception {
            Method setter = target.getClass().getMethod(this.setterName, this.paramClass);
            if (setter != null) {
                setter.invoke(target, this.convertValue(value));
            }
        }

        private Object convertValue(String value) {
            if (value == null) {
                return null;
            }
            if (this.paramClass.isAssignableFrom(value.getClass())) {
                return value;
            }
            if (Boolean.class.equals(this.paramClass) || Boolean.TYPE.equals(this.paramClass)) {
                return Boolean.valueOf(value);
            }
            if (Integer.class.equals(this.paramClass) || Integer.TYPE.equals(this.paramClass)) {
                return Integer.valueOf(value);
            }
            return value;
        }
    }
}

