/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/visibility.proto

package org.apache.rocketmq.shaded.com.google.api;

/**
 *
 *
 * <pre>
 * A visibility rule provides visibility configuration for an individual API
 * element.
 * </pre>
 *
 * Protobuf type {@code google.api.VisibilityRule}
 */
public final class VisibilityRule extends org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.VisibilityRule)
    VisibilityRuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VisibilityRule.newBuilder() to construct.
  private VisibilityRule(org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VisibilityRule() {
    selector_ = "";
    restriction_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VisibilityRule();
  }

  @java.lang.Override
  public final org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private VisibilityRule(
      org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
      org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              selector_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              restriction_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (org.apache.rocketmq.shaded.com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return org.apache.rocketmq.shaded.com.google.api.VisibilityProto.internal_static_google_api_VisibilityRule_descriptor;
  }

  @java.lang.Override
  protected org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return org.apache.rocketmq.shaded.com.google.api.VisibilityProto
        .internal_static_google_api_VisibilityRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            org.apache.rocketmq.shaded.com.google.api.VisibilityRule.class, org.apache.rocketmq.shaded.com.google.api.VisibilityRule.Builder.class);
  }

  public static final int SELECTOR_FIELD_NUMBER = 1;
  private volatile java.lang.Object selector_;
  /**
   *
   *
   * <pre>
   * Selects methods, messages, fields, enums, etc. to which this rule applies.
   * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
   * </pre>
   *
   * <code>string selector = 1;</code>
   *
   * @return The selector.
   */
  @java.lang.Override
  public java.lang.String getSelector() {
    java.lang.Object ref = selector_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString bs = (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selector_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Selects methods, messages, fields, enums, etc. to which this rule applies.
   * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
   * </pre>
   *
   * <code>string selector = 1;</code>
   *
   * @return The bytes for selector.
   */
  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.protobuf.ByteString getSelectorBytes() {
    java.lang.Object ref = selector_;
    if (ref instanceof java.lang.String) {
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString b =
          org.apache.rocketmq.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selector_ = b;
      return b;
    } else {
      return (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESTRICTION_FIELD_NUMBER = 2;
  private volatile java.lang.Object restriction_;
  /**
   *
   *
   * <pre>
   * A comma-separated list of visibility labels that apply to the `selector`.
   * Any of the listed labels can be used to grant the visibility.
   * If a rule has multiple labels, removing one of the labels but not all of
   * them can break clients.
   * Example:
   *     visibility:
   *       rules:
   *       - selector: google.calendar.Calendar.EnhancedSearch
   *         restriction: INTERNAL, PREVIEW
   * Removing INTERNAL from this restriction will break clients that rely on
   * this method and only had access to it through INTERNAL.
   * </pre>
   *
   * <code>string restriction = 2;</code>
   *
   * @return The restriction.
   */
  @java.lang.Override
  public java.lang.String getRestriction() {
    java.lang.Object ref = restriction_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString bs = (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      restriction_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A comma-separated list of visibility labels that apply to the `selector`.
   * Any of the listed labels can be used to grant the visibility.
   * If a rule has multiple labels, removing one of the labels but not all of
   * them can break clients.
   * Example:
   *     visibility:
   *       rules:
   *       - selector: google.calendar.Calendar.EnhancedSearch
   *         restriction: INTERNAL, PREVIEW
   * Removing INTERNAL from this restriction will break clients that rely on
   * this method and only had access to it through INTERNAL.
   * </pre>
   *
   * <code>string restriction = 2;</code>
   *
   * @return The bytes for restriction.
   */
  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.protobuf.ByteString getRestrictionBytes() {
    java.lang.Object ref = restriction_;
    if (ref instanceof java.lang.String) {
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString b =
          org.apache.rocketmq.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      restriction_ = b;
      return b;
    } else {
      return (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(org.apache.rocketmq.shaded.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(selector_)) {
      org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 1, selector_);
    }
    if (!org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(restriction_)) {
      org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 2, restriction_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(selector_)) {
      size += org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(1, selector_);
    }
    if (!org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(restriction_)) {
      size += org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(2, restriction_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof org.apache.rocketmq.shaded.com.google.api.VisibilityRule)) {
      return super.equals(obj);
    }
    org.apache.rocketmq.shaded.com.google.api.VisibilityRule other = (org.apache.rocketmq.shaded.com.google.api.VisibilityRule) obj;

    if (!getSelector().equals(other.getSelector())) return false;
    if (!getRestriction().equals(other.getRestriction())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SELECTOR_FIELD_NUMBER;
    hash = (53 * hash) + getSelector().hashCode();
    hash = (37 * hash) + RESTRICTION_FIELD_NUMBER;
    hash = (53 * hash) + getRestriction().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static org.apache.rocketmq.shaded.com.google.api.VisibilityRule parseFrom(java.nio.ByteBuffer data)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.apache.rocketmq.shaded.com.google.api.VisibilityRule parseFrom(
      java.nio.ByteBuffer data, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.api.VisibilityRule parseFrom(org.apache.rocketmq.shaded.com.google.protobuf.ByteString data)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.apache.rocketmq.shaded.com.google.api.VisibilityRule parseFrom(
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString data,
      org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.api.VisibilityRule parseFrom(byte[] data)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.apache.rocketmq.shaded.com.google.api.VisibilityRule parseFrom(
      byte[] data, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.api.VisibilityRule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.apache.rocketmq.shaded.com.google.api.VisibilityRule parseFrom(
      java.io.InputStream input, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.api.VisibilityRule parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static org.apache.rocketmq.shaded.com.google.api.VisibilityRule parseDelimitedFrom(
      java.io.InputStream input, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.api.VisibilityRule parseFrom(org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.apache.rocketmq.shaded.com.google.api.VisibilityRule parseFrom(
      org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
      org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(org.apache.rocketmq.shaded.com.google.api.VisibilityRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A visibility rule provides visibility configuration for an individual API
   * element.
   * </pre>
   *
   * Protobuf type {@code google.api.VisibilityRule}
   */
  public static final class Builder extends org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.VisibilityRule)
      org.apache.rocketmq.shaded.com.google.api.VisibilityRuleOrBuilder {
    public static final org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return org.apache.rocketmq.shaded.com.google.api.VisibilityProto.internal_static_google_api_VisibilityRule_descriptor;
    }

    @java.lang.Override
    protected org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.rocketmq.shaded.com.google.api.VisibilityProto
          .internal_static_google_api_VisibilityRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.rocketmq.shaded.com.google.api.VisibilityRule.class, org.apache.rocketmq.shaded.com.google.api.VisibilityRule.Builder.class);
    }

    // Construct using org.apache.rocketmq.shaded.com.google.api.VisibilityRule.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      selector_ = "";

      restriction_ = "";

      return this;
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return org.apache.rocketmq.shaded.com.google.api.VisibilityProto.internal_static_google_api_VisibilityRule_descriptor;
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.api.VisibilityRule getDefaultInstanceForType() {
      return org.apache.rocketmq.shaded.com.google.api.VisibilityRule.getDefaultInstance();
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.api.VisibilityRule build() {
      org.apache.rocketmq.shaded.com.google.api.VisibilityRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.api.VisibilityRule buildPartial() {
      org.apache.rocketmq.shaded.com.google.api.VisibilityRule result = new org.apache.rocketmq.shaded.com.google.api.VisibilityRule(this);
      result.selector_ = selector_;
      result.restriction_ = restriction_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(org.apache.rocketmq.shaded.com.google.protobuf.Message other) {
      if (other instanceof org.apache.rocketmq.shaded.com.google.api.VisibilityRule) {
        return mergeFrom((org.apache.rocketmq.shaded.com.google.api.VisibilityRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(org.apache.rocketmq.shaded.com.google.api.VisibilityRule other) {
      if (other == org.apache.rocketmq.shaded.com.google.api.VisibilityRule.getDefaultInstance()) return this;
      if (!other.getSelector().isEmpty()) {
        selector_ = other.selector_;
        onChanged();
      }
      if (!other.getRestriction().isEmpty()) {
        restriction_ = other.restriction_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
        org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      org.apache.rocketmq.shaded.com.google.api.VisibilityRule parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (org.apache.rocketmq.shaded.com.google.api.VisibilityRule) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object selector_ = "";
    /**
     *
     *
     * <pre>
     * Selects methods, messages, fields, enums, etc. to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     *
     * @return The selector.
     */
    public java.lang.String getSelector() {
      java.lang.Object ref = selector_;
      if (!(ref instanceof java.lang.String)) {
        org.apache.rocketmq.shaded.com.google.protobuf.ByteString bs = (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selector_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Selects methods, messages, fields, enums, etc. to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     *
     * @return The bytes for selector.
     */
    public org.apache.rocketmq.shaded.com.google.protobuf.ByteString getSelectorBytes() {
      java.lang.Object ref = selector_;
      if (ref instanceof String) {
        org.apache.rocketmq.shaded.com.google.protobuf.ByteString b =
            org.apache.rocketmq.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selector_ = b;
        return b;
      } else {
        return (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Selects methods, messages, fields, enums, etc. to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     *
     * @param value The selector to set.
     * @return This builder for chaining.
     */
    public Builder setSelector(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      selector_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Selects methods, messages, fields, enums, etc. to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelector() {

      selector_ = getDefaultInstance().getSelector();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Selects methods, messages, fields, enums, etc. to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     *
     * @param value The bytes for selector to set.
     * @return This builder for chaining.
     */
    public Builder setSelectorBytes(org.apache.rocketmq.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      selector_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object restriction_ = "";
    /**
     *
     *
     * <pre>
     * A comma-separated list of visibility labels that apply to the `selector`.
     * Any of the listed labels can be used to grant the visibility.
     * If a rule has multiple labels, removing one of the labels but not all of
     * them can break clients.
     * Example:
     *     visibility:
     *       rules:
     *       - selector: google.calendar.Calendar.EnhancedSearch
     *         restriction: INTERNAL, PREVIEW
     * Removing INTERNAL from this restriction will break clients that rely on
     * this method and only had access to it through INTERNAL.
     * </pre>
     *
     * <code>string restriction = 2;</code>
     *
     * @return The restriction.
     */
    public java.lang.String getRestriction() {
      java.lang.Object ref = restriction_;
      if (!(ref instanceof java.lang.String)) {
        org.apache.rocketmq.shaded.com.google.protobuf.ByteString bs = (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        restriction_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A comma-separated list of visibility labels that apply to the `selector`.
     * Any of the listed labels can be used to grant the visibility.
     * If a rule has multiple labels, removing one of the labels but not all of
     * them can break clients.
     * Example:
     *     visibility:
     *       rules:
     *       - selector: google.calendar.Calendar.EnhancedSearch
     *         restriction: INTERNAL, PREVIEW
     * Removing INTERNAL from this restriction will break clients that rely on
     * this method and only had access to it through INTERNAL.
     * </pre>
     *
     * <code>string restriction = 2;</code>
     *
     * @return The bytes for restriction.
     */
    public org.apache.rocketmq.shaded.com.google.protobuf.ByteString getRestrictionBytes() {
      java.lang.Object ref = restriction_;
      if (ref instanceof String) {
        org.apache.rocketmq.shaded.com.google.protobuf.ByteString b =
            org.apache.rocketmq.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        restriction_ = b;
        return b;
      } else {
        return (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A comma-separated list of visibility labels that apply to the `selector`.
     * Any of the listed labels can be used to grant the visibility.
     * If a rule has multiple labels, removing one of the labels but not all of
     * them can break clients.
     * Example:
     *     visibility:
     *       rules:
     *       - selector: google.calendar.Calendar.EnhancedSearch
     *         restriction: INTERNAL, PREVIEW
     * Removing INTERNAL from this restriction will break clients that rely on
     * this method and only had access to it through INTERNAL.
     * </pre>
     *
     * <code>string restriction = 2;</code>
     *
     * @param value The restriction to set.
     * @return This builder for chaining.
     */
    public Builder setRestriction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      restriction_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A comma-separated list of visibility labels that apply to the `selector`.
     * Any of the listed labels can be used to grant the visibility.
     * If a rule has multiple labels, removing one of the labels but not all of
     * them can break clients.
     * Example:
     *     visibility:
     *       rules:
     *       - selector: google.calendar.Calendar.EnhancedSearch
     *         restriction: INTERNAL, PREVIEW
     * Removing INTERNAL from this restriction will break clients that rely on
     * this method and only had access to it through INTERNAL.
     * </pre>
     *
     * <code>string restriction = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRestriction() {

      restriction_ = getDefaultInstance().getRestriction();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A comma-separated list of visibility labels that apply to the `selector`.
     * Any of the listed labels can be used to grant the visibility.
     * If a rule has multiple labels, removing one of the labels but not all of
     * them can break clients.
     * Example:
     *     visibility:
     *       rules:
     *       - selector: google.calendar.Calendar.EnhancedSearch
     *         restriction: INTERNAL, PREVIEW
     * Removing INTERNAL from this restriction will break clients that rely on
     * this method and only had access to it through INTERNAL.
     * </pre>
     *
     * <code>string restriction = 2;</code>
     *
     * @param value The bytes for restriction to set.
     * @return This builder for chaining.
     */
    public Builder setRestrictionBytes(org.apache.rocketmq.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      restriction_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.VisibilityRule)
  }

  // @@protoc_insertion_point(class_scope:google.api.VisibilityRule)
  private static final org.apache.rocketmq.shaded.com.google.api.VisibilityRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new org.apache.rocketmq.shaded.com.google.api.VisibilityRule();
  }

  public static org.apache.rocketmq.shaded.com.google.api.VisibilityRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final org.apache.rocketmq.shaded.com.google.protobuf.Parser<VisibilityRule> PARSER =
      new org.apache.rocketmq.shaded.com.google.protobuf.AbstractParser<VisibilityRule>() {
        @java.lang.Override
        public VisibilityRule parsePartialFrom(
            org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
            org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
          return new VisibilityRule(input, extensionRegistry);
        }
      };

  public static org.apache.rocketmq.shaded.com.google.protobuf.Parser<VisibilityRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.protobuf.Parser<VisibilityRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.api.VisibilityRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
