/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.log;

import org.apache.rocketmq.logging.InnerLoggerFactory;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.logging.inner.Appender;
import org.apache.rocketmq.logging.inner.Layout;
import org.apache.rocketmq.logging.inner.Level;
import org.apache.rocketmq.logging.inner.Logger;
import org.apache.rocketmq.logging.inner.LoggingBuilder;

public class ClientLogger {
    public static final String CLIENT_LOG_USESLF4J = "rocketmq.client.logUseSlf4j";
    public static final String CLIENT_LOG_ROOT = "rocketmq.client.logRoot";
    public static final String CLIENT_LOG_MAXINDEX = "rocketmq.client.logFileMaxIndex";
    public static final String CLIENT_LOG_FILESIZE = "rocketmq.client.logFileMaxSize";
    public static final String CLIENT_LOG_LEVEL = "rocketmq.client.logLevel";
    public static final String CLIENT_LOG_ADDITIVE = "rocketmq.client.log.additive";
    public static final String CLIENT_LOG_FILENAME = "rocketmq.client.logFileName";
    public static final String CLIENT_LOG_ASYNC_QUEUESIZE = "rocketmq.client.logAsyncQueueSize";
    public static final String ROCKETMQ_CLIENT_APPENDER_NAME = "RocketmqClientAppender";
    private static final InternalLogger CLIENT_LOGGER;
    private static final boolean CLIENT_USE_SLF4J;
    private static Appender rocketmqClientAppender;

    private static synchronized void createClientAppender() {
        String clientLogRoot = System.getProperty(CLIENT_LOG_ROOT, System.getProperty("user.home") + "/logs/rocketmqlogs");
        String clientLogMaxIndex = System.getProperty(CLIENT_LOG_MAXINDEX, "10");
        String clientLogFileName = System.getProperty(CLIENT_LOG_FILENAME, "rocketmq_client.log");
        String maxFileSize = System.getProperty(CLIENT_LOG_FILESIZE, "1073741824");
        String asyncQueueSize = System.getProperty(CLIENT_LOG_ASYNC_QUEUESIZE, "1024");
        String logFileName = clientLogRoot + "/" + clientLogFileName;
        int maxFileIndex = Integer.parseInt(clientLogMaxIndex);
        int queueSize = Integer.parseInt(asyncQueueSize);
        Layout layout = LoggingBuilder.newLayoutBuilder().withDefaultLayout().build();
        rocketmqClientAppender = LoggingBuilder.newAppenderBuilder().withRollingFileAppender(logFileName, maxFileSize, maxFileIndex).withAsync(false, queueSize).withName(ROCKETMQ_CLIENT_APPENDER_NAME).withLayout(layout).build();
        Logger.getRootLogger().addAppender(rocketmqClientAppender);
    }

    private static InternalLogger createLogger(String loggerName) {
        String clientLogLevel = System.getProperty(CLIENT_LOG_LEVEL, "INFO");
        boolean additive = "true".equalsIgnoreCase(System.getProperty(CLIENT_LOG_ADDITIVE));
        InternalLogger logger = InternalLoggerFactory.getLogger((String)loggerName);
        InnerLoggerFactory.InnerLogger innerLogger = (InnerLoggerFactory.InnerLogger)logger;
        Logger realLogger = innerLogger.getLogger();
        if (rocketmqClientAppender == null) {
            ClientLogger.createClientAppender();
        }
        realLogger.addAppender(rocketmqClientAppender);
        realLogger.setLevel(Level.toLevel((String)clientLogLevel));
        realLogger.setAdditivity(additive);
        return logger;
    }

    public static InternalLogger getLog() {
        return CLIENT_LOGGER;
    }

    static {
        rocketmqClientAppender = null;
        CLIENT_USE_SLF4J = Boolean.parseBoolean(System.getProperty(CLIENT_LOG_USESLF4J, "false"));
        if (!CLIENT_USE_SLF4J) {
            InternalLoggerFactory.setCurrentLoggerType((String)"inner");
            CLIENT_LOGGER = ClientLogger.createLogger("RocketmqClient");
            ClientLogger.createLogger("RocketmqCommon");
            ClientLogger.createLogger("RocketmqRemoting");
        } else {
            CLIENT_LOGGER = InternalLoggerFactory.getLogger((String)"RocketmqClient");
        }
    }
}

