/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.insert.values;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;

public final class InsertValueContext {
    private final int parameterCount;
    private final List<ExpressionSegment> valueExpressions;
    private final List<Object> parameters;

    public InsertValueContext(Collection<ExpressionSegment> assignments, List<Object> parameters, int parametersOffset) {
        this.parameterCount = this.calculateParameterCount(assignments);
        this.valueExpressions = this.getValueExpressions(assignments);
        this.parameters = this.getParameters(parameters, parametersOffset);
    }

    private int calculateParameterCount(Collection<ExpressionSegment> assignments) {
        int result = 0;
        for (ExpressionSegment each : assignments) {
            if (!(each instanceof ParameterMarkerExpressionSegment)) continue;
            ++result;
        }
        return result;
    }

    private List<ExpressionSegment> getValueExpressions(Collection<ExpressionSegment> assignments) {
        ArrayList<ExpressionSegment> result = new ArrayList<ExpressionSegment>(assignments.size());
        result.addAll(assignments);
        return result;
    }

    private List<Object> getParameters(List<Object> parameters, int parametersOffset) {
        if (0 == this.parameterCount) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(this.parameterCount);
        result.addAll(parameters.subList(parametersOffset, parametersOffset + this.parameterCount));
        return result;
    }

    public Object getValue(int index) {
        ExpressionSegment valueExpression = this.valueExpressions.get(index);
        return valueExpression instanceof ParameterMarkerExpressionSegment ? this.parameters.get(this.getParameterIndex(valueExpression)) : ((LiteralExpressionSegment)valueExpression).getLiterals();
    }

    public int getParameterIndex(int index) {
        ExpressionSegment valueExpression = this.valueExpressions.get(index);
        return this.getParameterIndex(valueExpression);
    }

    private int getParameterIndex(ExpressionSegment valueExpression) {
        int result = 0;
        for (ExpressionSegment each : this.valueExpressions) {
            if (valueExpression == each) {
                return result;
            }
            if (!(each instanceof ParameterMarkerExpressionSegment)) continue;
            ++result;
        }
        throw new IllegalArgumentException("Can not get parameter index.");
    }

    @Generated
    public int getParameterCount() {
        return this.parameterCount;
    }

    @Generated
    public List<ExpressionSegment> getValueExpressions() {
        return this.valueExpressions;
    }

    @Generated
    public List<Object> getParameters() {
        return this.parameters;
    }

    @Generated
    public String toString() {
        return "InsertValueContext(parameterCount=" + this.getParameterCount() + ", valueExpressions=" + this.getValueExpressions() + ", parameters=" + this.getParameters() + ")";
    }
}

