/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.select.pagination.engine;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.rownum.NumberLiteralRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.rownum.ParameterMarkerRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.rownum.RowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.top.TopProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionBuilder;

public final class TopPaginationContextEngine {
    public PaginationContext createPaginationContext(TopProjectionSegment topProjectionSegment, ExpressionSegment where, List<Object> parameters) {
        Collection andPredicates = new ExpressionBuilder(where).extractAndPredicates().getAndPredicates();
        Optional rowNumberPredicate = null != where ? this.getRowNumberPredicate(andPredicates, topProjectionSegment.getAlias()) : Optional.empty();
        Optional<Object> offset = rowNumberPredicate.isPresent() ? this.createOffsetWithRowNumber((ExpressionSegment)rowNumberPredicate.get()) : Optional.empty();
        RowNumberValueSegment rowCount = topProjectionSegment.getTop();
        return new PaginationContext(offset.orElse(null), (PaginationValueSegment)rowCount, parameters);
    }

    private Optional<ExpressionSegment> getRowNumberPredicate(Collection<AndPredicate> andPredicates, String rowNumberAlias) {
        for (AndPredicate each : andPredicates) {
            for (ExpressionSegment expression : each.getPredicates()) {
                if (!this.isRowNumberColumn(expression, rowNumberAlias) || !this.isCompareCondition(expression)) continue;
                return Optional.of(expression);
            }
        }
        return Optional.empty();
    }

    private boolean isRowNumberColumn(ExpressionSegment predicate, String rowNumberAlias) {
        if (predicate instanceof BinaryOperationExpression) {
            ExpressionSegment left = ((BinaryOperationExpression)predicate).getLeft();
            return left instanceof ColumnSegment ? ((ColumnSegment)left).getIdentifier().getValue().equalsIgnoreCase(rowNumberAlias) : false;
        }
        return false;
    }

    private boolean isCompareCondition(ExpressionSegment predicate) {
        if (predicate instanceof BinaryOperationExpression) {
            String operator = ((BinaryOperationExpression)predicate).getOperator();
            return ">".equals(operator) || ">=".equals(operator);
        }
        return false;
    }

    private Optional<PaginationValueSegment> createOffsetWithRowNumber(ExpressionSegment predicateSegment) {
        String operator;
        if (!(predicateSegment instanceof BinaryOperationExpression)) {
            return Optional.empty();
        }
        switch (operator = ((BinaryOperationExpression)predicateSegment).getOperator()) {
            case ">": {
                return Optional.of(this.createRowNumberValueSegment(((BinaryOperationExpression)predicateSegment).getRight(), false));
            }
            case ">=": {
                return Optional.of(this.createRowNumberValueSegment(((BinaryOperationExpression)predicateSegment).getRight(), true));
            }
        }
        return Optional.empty();
    }

    private RowNumberValueSegment createRowNumberValueSegment(ExpressionSegment expression, boolean boundOpened) {
        int startIndex = expression.getStartIndex();
        int stopIndex = expression.getStopIndex();
        return expression instanceof LiteralExpressionSegment ? new NumberLiteralRowNumberValueSegment(startIndex, stopIndex, (long)((Integer)((LiteralExpressionSegment)expression).getLiterals()).intValue(), boundOpened) : new ParameterMarkerRowNumberValueSegment(startIndex, stopIndex, ((ParameterMarkerExpressionSegment)expression).getParameterMarkerIndex(), boundOpened);
    }
}

