/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.metadata.translatable;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.sqlfederation.optimizer.executor.TableScanExecutor;
import org.apache.shardingsphere.sqlfederation.optimizer.executor.TranslatableScanNodeExecutorContext;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.statistic.FederationStatistic;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.translatable.TranslatableTableScan;
import org.apache.shardingsphere.sqlfederation.optimizer.util.SQLFederationDataTypeUtil;

public final class FederationTranslatableTable
extends AbstractTable
implements QueryableTable,
TranslatableTable {
    private final ShardingSphereTable table;
    private final TableScanExecutor executor;
    private final FederationStatistic statistic;
    private final DatabaseType protocolType;

    public Enumerable<Object> projectAndFilterScalar(DataContext root, String[] filterValues, int[] projects) {
        return this.executor.executeScalar(this.table, new TranslatableScanNodeExecutorContext(root, filterValues, projects));
    }

    public Enumerable<Object> projectScalar(DataContext root, int[] projects) {
        return this.executor.executeScalar(this.table, new TranslatableScanNodeExecutorContext(root, null, projects));
    }

    public Enumerable<Object[]> projectAndFilter(DataContext root, String[] filterValues, int[] projects) {
        return this.executor.execute(this.table, new TranslatableScanNodeExecutorContext(root, filterValues, projects));
    }

    public Enumerable<Object[]> project(DataContext root, int[] projects) {
        return this.executor.execute(this.table, new TranslatableScanNodeExecutorContext(root, null, projects));
    }

    public int getColumnType(int index) {
        List columnNames = this.table.getVisibleColumns();
        Map columnMap = this.table.getColumns();
        ShardingSphereColumn column = (ShardingSphereColumn)columnMap.get(columnNames.get(index));
        return column.getDataType();
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return SQLFederationDataTypeUtil.createRelDataType(this.table, this.protocolType, typeFactory);
    }

    public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
        return Schemas.tableExpression((SchemaPlus)schema, (Type)this.getElementType(), (String)tableName, (Class)clazz);
    }

    public Type getElementType() {
        return Object[].class;
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        throw new UnsupportedSQLOperationException("asQueryable");
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        int[] fields = this.getFieldIndexes(relOptTable.getRowType().getFieldCount());
        return new TranslatableTableScan(context.getCluster(), relOptTable, this, fields);
    }

    public String toString() {
        return "FederationTranslatableTable";
    }

    public Statistic getStatistic() {
        return this.statistic;
    }

    private int[] getFieldIndexes(int fieldCount) {
        int[] result = new int[fieldCount];
        for (int index = 0; index < fieldCount; ++index) {
            result[index] = index;
        }
        return result;
    }

    @Generated
    public FederationTranslatableTable(ShardingSphereTable table, TableScanExecutor executor, FederationStatistic statistic, DatabaseType protocolType) {
        this.table = table;
        this.executor = executor;
        this.statistic = statistic;
        this.protocolType = protocolType;
    }
}

