/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.http.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shenyu.register.client.http.utils.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuntimeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeUtils.class);
    private static final Pattern PID_PATTERN = Pattern.compile("\\d+");

    private RuntimeUtils() {
    }

    public static boolean listenByOther(int port) {
        Optional<String> optionalPid = RuntimeUtils.getPortOwner(port);
        if (optionalPid.isPresent() && !optionalPid.get().equals(SystemUtils.getCurrentPID())) {
            LOGGER.warn("PID {} is listening on port {}.", (Object)optionalPid.get(), (Object)port);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<String> getPortOwner(int port) {
        Process process;
        if (port <= 0) {
            return Optional.empty();
        }
        try {
            process = Runtime.getRuntime().exec(new String[]{"netstat", RuntimeUtils.getNestatOptions()});
        }
        catch (Exception e) {
            LOGGER.warn("exec netstat fail. {}", (Object)e.getMessage());
            return Optional.empty();
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            while (true) {
                String line;
                if ((line = bufferedReader.readLine()) != null) {
                    if (!line.contains("LISTEN") || !line.contains(":" + port + " ")) continue;
                    String[] fields = line.trim().split(" ");
                    Matcher matcher = PID_PATTERN.matcher(fields[fields.length - 1]);
                    if (!matcher.find()) continue;
                    Optional<String> optional = Optional.of(matcher.group(0));
                    return optional;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LOGGER.warn("get netstat input stream fail. {}", (Object)e.getMessage());
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return Optional.empty();
    }

    private static String getNestatOptions() {
        return SystemUtils.isWindows() ? "-ano" : "-anp";
    }
}

