/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.package$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t}d\u0001B\u0017/\u0001uBQa\u0015\u0001\u0005\u0002Q+Aa\u0016\u0001\u00051\"I!\u000e\u0001a\u0001\u0002\u0004%Ia\u001b\u0005\ne\u0002\u0001\r\u00111A\u0005\nMD\u0011B\u001e\u0001A\u0002\u0003\u0005\u000b\u0015\u00027\t\u0013]\u0004\u0001\u0019!a\u0001\n\u0013A\b\"\u0003@\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0000\u0011)\t\u0019\u0001\u0001a\u0001\u0002\u0003\u0006K!\u001f\u0005\f\u0003\u000b\u0001\u0001\u0019!a\u0001\n\u0013\t9\u0001C\u0006\u0002\u0018\u0001\u0001\r\u00111A\u0005\n\u0005e\u0001bCA\u000f\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0013A1\"a\b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\"!Y\u0011\u0011\u0006\u0001A\u0002\u0003\u0007I\u0011BA\u0016\u0011-\ty\u0003\u0001a\u0001\u0002\u0003\u0006K!a\t\t\u0017\u0005E\u0002\u00011AA\u0002\u0013%\u00111\u0007\u0005\f\u0003#\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\u0006C\u0006\u0002X\u0001\u0001\r\u0011!Q!\n\u0005U\u0002\"CA-\u0001\t\u0007I\u0011BA.\u0011!\t)\u0007\u0001Q\u0001\n\u0005u\u0003\"CA4\u0001\t\u0007I\u0011BA.\u0011!\tI\u0007\u0001Q\u0001\n\u0005u\u0003\"CA6\u0001\t\u0007I\u0011BA7\u0011!\t\u0019\n\u0001Q\u0001\n\u0005=\u0004\"CAK\u0001\t\u0007I\u0011BAL\u0011!\ty\n\u0001Q\u0001\n\u0005e\u0005\"CAQ\u0001\t\u0007I\u0011BAR\u0011!\ti\u000b\u0001Q\u0001\n\u0005\u0015\u0006bBAX\u0001\u0011\u0005\u0013\u0011\u0017\u0005\b\u0003?\u0004A\u0011IAq\u0011\u001d\t)\u000f\u0001C!\u0003ODq!!<\u0001\t\u0013\ty\u000fC\u0004\u0002z\u0002!I!a?\t\u000f\t\u001d\u0001\u0001\"\u0003\u0003\n!9!1\u0003\u0001\u0005\u0002\tU\u0001b\u0002B\u0011\u0001\u0011%!1\u0005\u0005\b\u0005_\u0001A\u0011\u0002B\u0019\u0011\u001d\u0011i\u0004\u0001C\u0005\u0005\u007fAqAa\u0011\u0001\t\u0013\u0011)eB\u0004\u0003d9B\tA!\u001a\u0007\r5r\u0003\u0012\u0001B4\u0011\u0019\u0019\u0006\u0006\"\u0001\u0003p!I!\u0011\u000f\u0015C\u0002\u0013\u0005!1\u000f\u0005\t\u0005kB\u0003\u0015!\u0003\u0003P!9!q\u000f\u0015\u0005\u0002\te$a\u0005)beF,X\r^,sSR,7+\u001e9q_J$(BA\u00181\u0003\u001d\u0001\u0018M]9vKRT!!\r\u001a\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003gQ\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005U2\u0014aA:rY*\u0011q\u0007O\u0001\u0006gB\f'o\u001b\u0006\u0003si\na!\u00199bG\",'\"A\u001e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qT\nE\u0002@\u000b\u001ek\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b1!\u00199j\u0015\t\u0019E)\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0003_aJ!A\u0012!\u0003\u0019]\u0013\u0018\u000e^3TkB\u0004xN\u001d;\u0011\u0005![U\"A%\u000b\u0005)#\u0014\u0001C2bi\u0006d\u0017p\u001d;\n\u00051K%aC%oi\u0016\u0014h.\u00197S_^\u0004\"AT)\u000e\u0003=S!\u0001\u0015\u001c\u0002\u0011%tG/\u001a:oC2L!AU(\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012!\u0016\t\u0003-\u0002i\u0011A\f\u0002\f-\u0006dW/Z,sSR,'\u000fE\u0003Z9z#w-D\u0001[\u0015\u0005Y\u0016!B:dC2\f\u0017BA/[\u0005%1UO\\2uS>t'\u0007\u0005\u0002`E6\t\u0001M\u0003\u0002b\u0013\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\t\u0019\u0007M\u0001\nTa\u0016\u001c\u0017.\u00197ju\u0016$w)\u001a;uKJ\u001c\bCA-f\u0013\t1'LA\u0002J]R\u0004\"!\u00175\n\u0005%T&\u0001B+oSR\faa]2iK6\fW#\u00017\u0011\u00055\u0004X\"\u00018\u000b\u0005=$\u0014!\u0002;za\u0016\u001c\u0018BA9o\u0005)\u0019FO];diRK\b/Z\u0001\u000bg\u000eDW-\\1`I\u0015\fHCA4u\u0011\u001d)H!!AA\u00021\f1\u0001\u001f\u00132\u0003\u001d\u00198\r[3nC\u0002\n\u0001C]8pi\u001aKW\r\u001c3Xe&$XM]:\u0016\u0003e\u00042!\u0017>}\u0013\tY(LA\u0003BeJ\f\u0017\u0010\u0005\u0002~\u00055\t\u0001!\u0001\u000bs_>$h)[3mI^\u0013\u0018\u000e^3sg~#S-\u001d\u000b\u0004O\u0006\u0005\u0001bB;\b\u0003\u0003\u0005\r!_\u0001\u0012e>|GOR5fY\u0012<&/\u001b;feN\u0004\u0013A\u0004:fG>\u0014HmQ8ogVlWM]\u000b\u0003\u0003\u0013\u0001B!a\u0003\u0002\u00145\u0011\u0011Q\u0002\u0006\u0004\u0003\u0006=!bAA\t\t\u0006\u0011\u0011n\\\u0005\u0005\u0003+\tiA\u0001\bSK\u000e|'\u000fZ\"p]N,X.\u001a:\u0002%I,7m\u001c:e\u0007>t7/^7fe~#S-\u001d\u000b\u0004O\u0006m\u0001\u0002C;\u000b\u0003\u0003\u0005\r!!\u0003\u0002\u001fI,7m\u001c:e\u0007>t7/^7fe\u0002\n\u0001d\u001e:ji\u0016dUmZ1dsB\u000b'/];fi\u001a{'/\\1u+\t\t\u0019\u0003E\u0002Z\u0003KI1!a\n[\u0005\u001d\u0011un\u001c7fC:\fAd\u001e:ji\u0016dUmZ1dsB\u000b'/];fi\u001a{'/\\1u?\u0012*\u0017\u000fF\u0002h\u0003[A\u0001\"^\u0007\u0002\u0002\u0003\u0007\u00111E\u0001\u001aoJLG/\u001a'fO\u0006\u001c\u0017\u0010U1scV,GOR8s[\u0006$\b%A\npkR\u0004X\u000f\u001e+j[\u0016\u001cH/Y7q)f\u0004X-\u0006\u0002\u00026A!\u0011qGA%\u001d\u0011\tI$a\u0011\u000f\t\u0005m\u0012qH\u0007\u0003\u0003{Q!\u0001\u0015\u001b\n\t\u0005\u0005\u0013QH\u0001\b'Fc5i\u001c8g\u0013\u0011\t)%a\u0012\u00025A\u000b'/];fi>+H\u000f];u)&lWm\u001d;b[B$\u0016\u0010]3\u000b\t\u0005\u0005\u0013QH\u0005\u0005\u0003\u0017\niEA\u0003WC2,X-C\u0002\u0002Pi\u00131\"\u00128v[\u0016\u0014\u0018\r^5p]\u00069r.\u001e;qkR$\u0016.\\3ti\u0006l\u0007\u000fV=qK~#S-\u001d\u000b\u0004O\u0006U\u0003\u0002C;\u0011\u0003\u0003\u0005\r!!\u000e\u0002)=,H\u000f];u)&lWm\u001d;b[B$\u0016\u0010]3!\u0003=!\u0018.\\3ti\u0006l\u0007OQ;gM\u0016\u0014XCAA/!\u0011I&0a\u0018\u0011\u0007e\u000b\t'C\u0002\u0002di\u0013AAQ=uK\u0006\u0001B/[7fgR\fW\u000e\u001d\"vM\u001a,'\u000fI\u0001\u000eI\u0016\u001c\u0017.\\1m\u0005V4g-\u001a:\u0002\u001d\u0011,7-[7bY\n+hMZ3sA\u0005\u0011B-\u0019;fi&lWMU3cCN,Wj\u001c3f+\t\ty\u0007\u0005\u0003\u0002r\u0005%c\u0002BA:\u0003\u001fsA!!\u001e\u0002@9!\u0011qOAG\u001d\u0011\tI(a#\u000f\t\u0005m\u0014\u0011\u0012\b\u0005\u0003{\n9I\u0004\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\r\t\u0019\tP\u0001\u0007yI|w\u000e\u001e \n\u0003mJ!!\u000f\u001e\n\u0005]B\u0014BA\u001b7\u0013\t\u0001F'\u0003\u0003\u0002\u0012\u0006\u001d\u0013\u0001\u0006'fO\u0006\u001c\u0017PQ3iCZLwN\u001d)pY&\u001c\u00170A\neCR,G/[7f%\u0016\u0014\u0017m]3N_\u0012,\u0007%\u0001\beCR,'+\u001a2bg\u00164UO\\2\u0016\u0005\u0005e\u0005#B-\u0002\u001c\u0012$\u0017bAAO5\nIa)\u001e8di&|g.M\u0001\u0010I\u0006$XMU3cCN,g)\u001e8dA\u0005\u0019B/[7fgR\fW\u000e\u001d*fE\u0006\u001cXMR;oGV\u0011\u0011Q\u0015\t\b3\u0006m\u0015qUAT!\rI\u0016\u0011V\u0005\u0004\u0003WS&\u0001\u0002'p]\u001e\fA\u0003^5nKN$\u0018-\u001c9SK\n\f7/\u001a$v]\u000e\u0004\u0013\u0001B5oSR$B!a-\u0002NB!\u0011QWAd\u001d\u0011\t9,a1\u000f\t\u0005e\u0016\u0011\u0019\b\u0005\u0003w\u000byL\u0004\u0003\u0002|\u0005u\u0016BA\u00189\u0013\t\u0019E)\u0003\u0002B\u0005&\u0019\u0011Q\u0019!\u0002\u0019]\u0013\u0018\u000e^3TkB\u0004xN\u001d;\n\t\u0005%\u00171\u001a\u0002\r/JLG/Z\"p]R,\u0007\u0010\u001e\u0006\u0004\u0003\u000b\u0004\u0005bBAh9\u0001\u0007\u0011\u0011[\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\t\u0005M\u00171\\\u0007\u0003\u0003+TA!a6\u0002Z\u0006!1m\u001c8g\u0015\t\u0019\u0005(\u0003\u0003\u0002^\u0006U'!D\"p]\u001aLw-\u001e:bi&|g.A\bqe\u0016\u0004\u0018M]3G_J<&/\u001b;f)\r9\u00171\u001d\u0005\b\u0003\u000bi\u0002\u0019AA\u0005\u0003\u00159(/\u001b;f)\r9\u0017\u0011\u001e\u0005\u0007\u0003Wt\u0002\u0019A$\u0002\u0007I|w/A\u0006xe&$XMR5fY\u0012\u001cHcB4\u0002r\u0006M\u0018Q\u001f\u0005\u0007\u0003W|\u0002\u0019A$\t\u000b)|\u0002\u0019\u00017\t\r\u0005]x\u00041\u0001z\u000311\u0017.\u001a7e/JLG/\u001a:t\u0003)i\u0017m[3Xe&$XM\u001d\u000b\u0004y\u0006u\bbBA\u0000A\u0001\u0007!\u0011A\u0001\tI\u0006$\u0018\rV=qKB\u0019QNa\u0001\n\u0007\t\u0015aN\u0001\u0005ECR\fG+\u001f9f\u0003Ei\u0017m[3EK\u000eLW.\u00197Xe&$XM\u001d\u000b\u0006y\n-!q\u0002\u0005\u0007\u0005\u001b\t\u0003\u0019\u00013\u0002\u0013A\u0014XmY5tS>t\u0007B\u0002B\tC\u0001\u0007A-A\u0003tG\u0006dW-A\bnC.,\u0017I\u001d:bs^\u0013\u0018\u000e^3s)\ra(q\u0003\u0005\b\u00053\u0011\u0003\u0019\u0001B\u000e\u0003%\t'O]1z)f\u0004X\rE\u0002n\u0005;I1Aa\bo\u0005%\t%O]1z)f\u0004X-A\u0007nC.,W*\u00199Xe&$XM\u001d\u000b\u0004y\n\u0015\u0002b\u0002B\u0014G\u0001\u0007!\u0011F\u0001\b[\u0006\u0004H+\u001f9f!\ri'1F\u0005\u0004\u0005[q'aB'baRK\b/Z\u0001\u000fG>t7/^7f\u001b\u0016\u001c8/Y4f)\r9'1\u0007\u0005\t\u0005k!C\u00111\u0001\u00038\u0005\ta\r\u0005\u0003Z\u0005s9\u0017b\u0001B\u001e5\nAAHY=oC6,g(\u0001\u0007d_:\u001cX/\\3He>,\b\u000fF\u0002h\u0005\u0003B\u0001B!\u000e&\t\u0003\u0007!qG\u0001\rG>t7/^7f\r&,G\u000e\u001a\u000b\u0007\u0005\u000f\u0012YEa\u0018\u0015\u0007\u001d\u0014I\u0005\u0003\u0005\u00036\u0019\"\t\u0019\u0001B\u001c\u0011\u001d\u0011iE\na\u0001\u0005\u001f\nQAZ5fY\u0012\u0004BA!\u0015\u0003Z9!!1\u000bB+!\r\tyHW\u0005\u0004\u0005/R\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0003\\\tu#AB*ue&twMC\u0002\u0003XiCaA!\u0019'\u0001\u0004!\u0017!B5oI\u0016D\u0018a\u0005)beF,X\r^,sSR,7+\u001e9q_J$\bC\u0001,)'\rA#\u0011\u000e\t\u00043\n-\u0014b\u0001B75\n1\u0011I\\=SK\u001a$\"A!\u001a\u0002!M\u0003\u0016IU&`%>;vlU\"I\u000b6\u000bUC\u0001B(\u0003E\u0019\u0006+\u0011*L?J{ukX*D\u0011\u0016k\u0015\tI\u0001\ng\u0016$8k\u00195f[\u0006$Ra\u001aB>\u0005{BQA\u001b\u0017A\u00021Dq!a4-\u0001\u0004\t\t\u000e")
public class ParquetWriteSupport
extends WriteSupport<InternalRow>
implements Logging {
    private StructType schema;
    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters;
    private RecordConsumer recordConsumer;
    private boolean writeLegacyParquetFormat;
    private Enumeration.Value outputTimestampType;
    private final byte[] timestampBuffer;
    private final byte[] decimalBuffer;
    private final Enumeration.Value datetimeRebaseMode;
    private final Function1<Object, Object> dateRebaseFunc;
    private final Function1<Object, Object> timestampRebaseFunc;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void setSchema(StructType structType, Configuration configuration) {
        ParquetWriteSupport$.MODULE$.setSchema(structType, configuration);
    }

    public static String SPARK_ROW_SCHEMA() {
        return ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StructType schema() {
        return this.schema;
    }

    private void schema_$eq(StructType x$1) {
        this.schema = x$1;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters() {
        return this.rootFieldWriters;
    }

    private void rootFieldWriters_$eq(Function2<SpecializedGetters, Object, BoxedUnit>[] x$1) {
        this.rootFieldWriters = x$1;
    }

    private RecordConsumer recordConsumer() {
        return this.recordConsumer;
    }

    private void recordConsumer_$eq(RecordConsumer x$1) {
        this.recordConsumer = x$1;
    }

    private boolean writeLegacyParquetFormat() {
        return this.writeLegacyParquetFormat;
    }

    private void writeLegacyParquetFormat_$eq(boolean x$1) {
        this.writeLegacyParquetFormat = x$1;
    }

    private Enumeration.Value outputTimestampType() {
        return this.outputTimestampType;
    }

    private void outputTimestampType_$eq(Enumeration.Value x$1) {
        this.outputTimestampType = x$1;
    }

    private byte[] timestampBuffer() {
        return this.timestampBuffer;
    }

    private byte[] decimalBuffer() {
        return this.decimalBuffer;
    }

    private Enumeration.Value datetimeRebaseMode() {
        return this.datetimeRebaseMode;
    }

    private Function1<Object, Object> dateRebaseFunc() {
        return this.dateRebaseFunc;
    }

    private Function1<Object, Object> timestampRebaseFunc() {
        return this.timestampRebaseFunc;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        String schemaString = configuration.get(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA());
        this.schema_$eq(StructType$.MODULE$.fromString(schemaString));
        Predef$.MODULE$.assert(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()) != null);
        this.writeLegacyParquetFormat_$eq(new StringOps(Predef$.MODULE$.augmentString(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()))).toBoolean());
        String key = SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key();
        Predef$.MODULE$.assert(configuration.get(key) != null);
        this.outputTimestampType_$eq(SQLConf.ParquetOutputTimestampType$.MODULE$.withName(configuration.get(key)));
        this.rootFieldWriters_$eq((Function2[])((TraversableOnce)((TraversableLike)this.schema().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> this.makeWriter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function2.class)));
        MessageType messageType = new SparkToParquetSchemaConverter(configuration).convert(this.schema());
        Enumeration.Value value = this.datetimeRebaseMode();
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        scala.collection.immutable.Map metadata = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.SPARK_VERSION_METADATA_KEY()), (Object)org.apache.spark.package$.MODULE$.SPARK_VERSION_SHORT()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY()), (Object)schemaString)}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable((Option)(!(value != null ? !value.equals(value2) : value2 != null) ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.SPARK_LEGACY_DATETIME()), (Object)"")) : None$.MODULE$)));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(134).append("Initialized Parquet WriteSupport with Catalyst schema:\n         |").append(this.schema().prettyJson()).append("\n         |and corresponding Parquet message type:\n         |").append(messageType).append("\n       ").toString())).stripMargin());
        return new WriteSupport.WriteContext(messageType, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)metadata).asJava());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer_$eq(recordConsumer);
    }

    public void write(InternalRow row) {
        this.consumeMessage((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.writeFields(row, this.schema(), this.rootFieldWriters()));
    }

    private void writeFields(InternalRow row, StructType schema, Function2<SpecializedGetters, Object, BoxedUnit>[] fieldWriters) {
        IntRef i = IntRef.create((int)0);
        while (i.elem < row.numFields()) {
            if (!row.isNullAt(i.elem)) {
                this.consumeField(schema.apply(i.elem).name(), i.elem, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fieldWriters[i$1.elem].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i$1.elem)));
            }
            ++i.elem;
        }
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeWriter(DataType dataType2) {
        Function2 & Serializable & scala.Serializable intersect;
        block22: {
            while (true) {
                DecimalType decimalType;
                Option option;
                DataType dataType3;
                if (BooleanType$.MODULE$.equals(dataType3 = dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$1(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (ByteType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$2(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (ShortType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$3(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (DateType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$4(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (IntegerType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$5(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (LongType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$6(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (FloatType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$7(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (DoubleType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$8(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (StringType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$9(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (TimestampType$.MODULE$.equals(dataType3)) {
                    Function2 & Serializable & scala.Serializable intersect2;
                    Enumeration.Value value = this.outputTimestampType();
                    Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        intersect2 = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                            ParquetWriteSupport.$anonfun$makeWriter$10(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                            return BoxedUnit.UNIT;
                        };
                    } else {
                        Enumeration.Value value4 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            intersect2 = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                                ParquetWriteSupport.$anonfun$makeWriter$11(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                                return BoxedUnit.UNIT;
                            };
                        } else {
                            Enumeration.Value value6 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
                            Enumeration.Value value7 = value;
                            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                                intersect2 = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                                    ParquetWriteSupport.$anonfun$makeWriter$12(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                                    return BoxedUnit.UNIT;
                                };
                            } else {
                                throw new MatchError((Object)value);
                            }
                        }
                    }
                    intersect = intersect2;
                    break block22;
                }
                if (BinaryType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$13(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (dataType3 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType3)).isEmpty()) {
                    int precision = ((Tuple2)option.get())._1$mcI$sp();
                    int scale = ((Tuple2)option.get())._2$mcI$sp();
                    intersect = this.makeDecimalWriter(precision, scale);
                    break block22;
                }
                if (dataType3 instanceof StructType) {
                    StructType structType = (StructType)dataType3;
                    Function2[] fieldWriters = (Function2[])((TraversableOnce)((TraversableLike)structType.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> this.makeWriter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function2.class));
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.writeFields(row.getStruct(BoxesRunTime.unboxToInt((Object)ordinal), structType.length()), structType, fieldWriters));
                        return BoxedUnit.UNIT;
                    };
                    break block22;
                }
                if (dataType3 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType3;
                    intersect = this.makeArrayWriter(arrayType);
                    break block22;
                }
                if (dataType3 instanceof MapType) {
                    MapType mapType = (MapType)dataType3;
                    intersect = this.makeMapWriter(mapType);
                    break block22;
                }
                if (!(dataType3 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType3;
                dataType2 = userDefinedType.sqlType();
            }
            throw scala.sys.package$.MODULE$.error(new StringBuilder(23).append("Unsupported data type ").append(dataType2).append(".").toString());
        }
        return intersect;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function2<SpecializedGetters, Object, BoxedUnit> makeDecimalWriter(int precision, int scale) {
        Predef$.MODULE$.assert(precision <= DecimalType$.MODULE$.MAX_PRECISION(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Decimal precision ").append(precision).append(" exceeds max precision ").append(DecimalType$.MODULE$.MAX_PRECISION()).toString());
        int numBytes = Decimal$.MODULE$.minBytesForPrecision()[precision];
        Function2 & Serializable & scala.Serializable int32Writer = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$2(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable int64Writer = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$3(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable binaryWriterUsingUnscaledLong = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$4(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable binaryWriterUsingUnscaledBytes = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$5(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.writeLegacyParquetFormat();
        if (!bl3) {
            bl = true;
            bl2 = bl3;
            if (precision <= Decimal$.MODULE$.MAX_INT_DIGITS()) {
                return int32Writer;
            }
        }
        if (bl && precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return int64Writer;
        }
        if (true != bl3) return binaryWriterUsingUnscaledBytes;
        if (precision > Decimal$.MODULE$.MAX_LONG_DIGITS()) return binaryWriterUsingUnscaledBytes;
        return binaryWriterUsingUnscaledLong;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Function2<SpecializedGetters, Object, BoxedUnit> makeArrayWriter(ArrayType arrayType) {
        boolean bl;
        Function2<SpecializedGetters, Object, BoxedUnit> elementWriter = this.makeWriter(arrayType.elementType());
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(this.writeLegacyParquetFormat(), arrayType.containsNull());
        if (sp2 != null && !(bl = sp2._1$mcZ$sp())) {
            return this.threeLevelArrayWriter$1("list", "element", elementWriter);
        }
        if (sp2 != null) {
            boolean bl2 = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl2 && bl3) {
                return this.threeLevelArrayWriter$1("bag", "array", elementWriter);
            }
        }
        if (sp2 == null) throw new MatchError((Object)sp2);
        boolean bl4 = sp2._1$mcZ$sp();
        boolean bl5 = sp2._2$mcZ$sp();
        if (true != bl4) throw new MatchError((Object)sp2);
        if (false != bl5) throw new MatchError((Object)sp2);
        return this.twoLevelArrayWriter$1("array", elementWriter);
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeMapWriter(MapType mapType) {
        Function2<SpecializedGetters, Object, BoxedUnit> keyWriter = this.makeWriter(mapType.keyType());
        Function2<SpecializedGetters, Object, BoxedUnit> valueWriter = this.makeWriter(mapType.valueType());
        String repeatedGroupName = this.writeLegacyParquetFormat() ? "map" : "key_value";
        return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeMapWriter$1(this, repeatedGroupName, keyWriter, valueWriter, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    private void consumeMessage(Function0<BoxedUnit> f) {
        this.recordConsumer().startMessage();
        f.apply$mcV$sp();
        this.recordConsumer().endMessage();
    }

    private void consumeGroup(Function0<BoxedUnit> f) {
        this.recordConsumer().startGroup();
        f.apply$mcV$sp();
        this.recordConsumer().endGroup();
    }

    private void consumeField(String field, int index, Function0<BoxedUnit> f) {
        this.recordConsumer().startField(field, index);
        f.apply$mcV$sp();
        this.recordConsumer().endField(field, index);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$1(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBoolean(row.getBoolean(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$2(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getByte(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$3(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getShort(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$4(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger($this.dateRebaseFunc().apply$mcII$sp(row.getInt(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$5(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger(row.getInt(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$6(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addLong(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$7(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addFloat(row.getFloat(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$8(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addDouble(row.getDouble(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$9(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getUTF8String(ordinal).getBytes()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$10(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        Tuple2 tuple2 = DateTimeUtils$.MODULE$.toJulianDay(row.getLong(ordinal));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int julianDay = tuple2._1$mcI$sp();
        long timeOfDayNanos = tuple2._2$mcJ$sp();
        Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(julianDay, timeOfDayNanos);
        Tuple2.mcIJ.sp sp3 = sp2;
        int julianDay2 = sp3._1$mcI$sp();
        long timeOfDayNanos2 = sp3._2$mcJ$sp();
        ByteBuffer buf = ByteBuffer.wrap($this.timestampBuffer());
        buf.order(ByteOrder.LITTLE_ENDIAN).putLong(timeOfDayNanos2).putInt(julianDay2);
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.timestampBuffer()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$11(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = row.getLong(ordinal);
        $this.recordConsumer().addLong($this.timestampRebaseFunc().apply$mcJJ$sp(micros));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$12(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = row.getLong(ordinal);
        long millis = DateTimeUtils$.MODULE$.toMillis($this.timestampRebaseFunc().apply$mcJJ$sp(micros));
        $this.recordConsumer().addLong(millis);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$13(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getBinary(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$2(ParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addInteger((int)unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$3(ParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addLong(unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$4(ParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        long unscaled = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        int i = 0;
        int shift = 8 * (numBytes$1 - 1);
        while (i < numBytes$1) {
            $this.decimalBuffer()[i] = (byte)(unscaled >> shift);
            ++i;
            shift -= 8;
        }
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.decimalBuffer(), (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$5(ParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        byte[] byArray;
        Decimal decimal = row.getDecimal(ordinal, precision$1, scale$1);
        byte[] bytes = decimal.toJavaBigDecimal().unscaledValue().toByteArray();
        if (bytes.length == numBytes$1) {
            byArray = bytes;
        } else {
            byte signByte = BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).head()) < 0 ? (byte)-1 : 0;
            Arrays.fill($this.decimalBuffer(), 0, numBytes$1 - bytes.length, signByte);
            System.arraycopy(bytes, 0, $this.decimalBuffer(), numBytes$1 - bytes.length, bytes.length);
            byArray = $this.decimalBuffer();
        }
        byte[] fixedLengthBytes = byArray;
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])fixedLengthBytes, (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$1(ParquetWriteSupport $this, String repeatedGroupName$1, String elementFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (array.numElements() <= 0) break block0;
                $this.consumeField(repeatedGroupName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < array.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            block0: {
                                if (array.isNullAt(i$2.elem)) break block0;
                                $this.consumeField(elementFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i$2.elem)));
                            }
                        });
                        ++i.elem;
                    }
                });
            }
        });
    }

    private final Function2 threeLevelArrayWriter$1(String repeatedGroupName, String elementFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeArrayWriter$1(this, repeatedGroupName, elementFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$6(ParquetWriteSupport $this, String repeatedFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (array.numElements() <= 0) break block0;
                $this.consumeField(repeatedFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    for (int i = 0; i < array.numElements(); ++i) {
                        elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i));
                    }
                });
            }
        });
    }

    private final Function2 twoLevelArrayWriter$1(String repeatedFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeArrayWriter$6(this, repeatedFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeMapWriter$1(ParquetWriteSupport $this, String repeatedGroupName$2, Function2 keyWriter$1, Function2 valueWriter$1, SpecializedGetters row, int ordinal) {
        MapData map = row.getMap(ordinal);
        ArrayData keyArray = map.keyArray();
        ArrayData valueArray = map.valueArray();
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (map.numElements() <= 0) break block0;
                $this.consumeField(repeatedGroupName$2, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < map.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            block0: {
                                $this.consumeField("key", 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> keyWriter$1.apply((Object)keyArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                                if (map.valueArray().isNullAt(i$3.elem)) break block0;
                                $this.consumeField("value", 1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> valueWriter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                            }
                        });
                        ++i.elem;
                    }
                });
            }
        });
    }

    public ParquetWriteSupport() {
        Logging.$init$((Logging)this);
        this.timestampBuffer = new byte[12];
        this.decimalBuffer = new byte[Decimal$.MODULE$.minBytesForPrecision()[DecimalType$.MODULE$.MAX_PRECISION()]];
        this.datetimeRebaseMode = SQLConf.LegacyBehaviorPolicy$.MODULE$.withName((String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_PARQUET_REBASE_MODE_IN_WRITE()));
        this.dateRebaseFunc = DataSourceUtils$.MODULE$.creteDateRebaseFuncInWrite(this.datetimeRebaseMode(), "Parquet");
        this.timestampRebaseFunc = DataSourceUtils$.MODULE$.creteTimestampRebaseFuncInWrite(this.datetimeRebaseMode(), "Parquet");
    }
}

