/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.IGenericInstance;
import com.strobel.assembler.metadata.IGenericParameterProvider;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.ParameterDefinitionCollection;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.VerifyArgument;
import java.util.Collection;
import java.util.List;

final class GenericMethodInstance
extends MethodReference
implements IGenericInstance {
    private final MethodReference _genericDefinition;
    private final TypeReference _returnType;
    private final ParameterDefinitionCollection _parameters;
    private final List<TypeReference> _typeArguments;
    private TypeReference _declaringType;

    GenericMethodInstance(TypeReference declaringType, MethodReference definition, TypeReference returnType, List<ParameterDefinition> parameters, List<TypeReference> typeArguments) {
        this._declaringType = (TypeReference)VerifyArgument.notNull((Object)declaringType, (String)"declaringType");
        this._genericDefinition = (MethodReference)VerifyArgument.notNull((Object)definition, (String)"definition");
        VerifyArgument.notNull((Object)returnType, (String)"returnType");
        this._returnType = returnType;
        this._parameters = new ParameterDefinitionCollection(this);
        this._typeArguments = (List)VerifyArgument.notNull(typeArguments, (String)"typeArguments");
        this._parameters.addAll((Collection)VerifyArgument.notNull(parameters, (String)"parameters"));
        this._parameters.freeze();
    }

    @Override
    public final boolean hasTypeArguments() {
        return !this._typeArguments.isEmpty();
    }

    @Override
    public final List<TypeReference> getTypeArguments() {
        return this._typeArguments;
    }

    @Override
    public final IGenericParameterProvider getGenericDefinition() {
        return this._genericDefinition;
    }

    @Override
    public final List<GenericParameter> getGenericParameters() {
        return this._genericDefinition.getGenericParameters();
    }

    @Override
    public final TypeReference getReturnType() {
        return this._returnType;
    }

    @Override
    public final List<ParameterDefinition> getParameters() {
        return this._parameters;
    }

    @Override
    public boolean isGenericMethod() {
        return this.hasTypeArguments();
    }

    @Override
    public MethodDefinition resolve() {
        return this._genericDefinition.resolve();
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        return this._genericDefinition.appendErasedSignature(sb);
    }

    @Override
    public final TypeReference getDeclaringType() {
        return this._declaringType;
    }

    final void setDeclaringType(TypeReference declaringType) {
        this._declaringType = declaringType;
    }

    @Override
    public final String getName() {
        return this._genericDefinition.getName();
    }
}

