/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh.term.inline;

import java.io.IOException;
import java.io.PrintStream;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.server.Environment;
import org.crsh.plugin.PluginContext;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellFactory;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.ssh.term.AbstractCommand;
import org.crsh.ssh.term.SSHContext;
import org.crsh.ssh.term.SSHLifeCycle;
import org.crsh.ssh.term.inline.SSHInlineShellProcessContext;

public class SSHInlineCommand
extends AbstractCommand
implements Runnable {
    protected static final Logger log = Logger.getLogger(SSHInlineCommand.class.getName());
    protected static final int OK = 0;
    protected static final int ERROR = 2;
    private Thread thread;
    private String command;
    private PluginContext pluginContext;
    private Environment env;

    public SSHInlineCommand(String command, PluginContext pluginContext) {
        this.command = command;
        this.pluginContext = pluginContext;
    }

    public void start(Environment environment) throws IOException {
        this.env = environment;
        this.thread = new Thread((Runnable)this, "CRaSH");
        this.thread.start();
    }

    public void destroy() {
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PrintStream err = new PrintStream(this.err);
        PrintStream out = new PrintStream(this.out);
        final String userName = (String)this.session.getAttribute(SSHLifeCycle.USERNAME);
        Principal user = new Principal(){

            @Override
            public String getName() {
                return userName;
            }
        };
        Shell shell = ((ShellFactory)this.pluginContext.getPlugin(ShellFactory.class)).create(user);
        ShellProcess shellProcess = shell.createProcess(this.command);
        SSHInlineShellProcessContext context = new SSHInlineShellProcessContext(new SSHContext(this.env), shellProcess, out, err);
        int exitStatus = 0;
        String exitMsg = null;
        try {
            shellProcess.execute((ShellProcessContext)context);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error during command execution", e);
            exitMsg = e.getMessage();
            exitStatus = 2;
        }
        finally {
            ShellResponse response = context.getResponse();
            if (!(response instanceof ShellResponse.Ok)) {
                exitStatus = 2;
                String errorMsg = response != null ? "Error during command execution : " + response.getMessage() : "Error during command execution";
                err.println(errorMsg);
                if (response instanceof ShellResponse.Error) {
                    ShellResponse.Error error = (ShellResponse.Error)response;
                    log.log(Level.SEVERE, errorMsg, error.getThrowable());
                } else {
                    log.log(Level.SEVERE, errorMsg);
                }
            }
            if (this.callback != null) {
                this.callback.onExit(exitStatus, exitMsg);
            }
        }
    }
}

