/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.entity.ByteArrayRef;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.CountingExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.BpmnLoggingSessionUtil;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.impl.util.EntityLinkUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.identitylink.service.event.impl.FlowableIdentityLinkEventBuilder;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.api.DelegationState;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskLogEntryBuilder;
import org.flowable.task.api.history.HistoricTaskLogEntryType;
import org.flowable.task.service.HistoricTaskService;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.TaskServiceConfiguration;
import org.flowable.task.service.impl.BaseHistoricTaskLogEntryBuilderImpl;
import org.flowable.task.service.impl.persistence.CountingTaskEntity;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.event.impl.FlowableVariableEventBuilder;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class TaskHelper {
    public static void completeTask(TaskEntity taskEntity, Map<String, Object> variables, Map<String, Object> localVariables, Map<String, Object> transientVariables, Map<String, Object> localTransientVariables, CommandContext commandContext) {
        boolean bpmnErrorPropagated;
        ProcessEngineConfigurationImpl processEngineConfiguration;
        block20: {
            ExecutionEntity execution;
            if (taskEntity.getDelegationState() != null && taskEntity.getDelegationState() == DelegationState.PENDING) {
                throw new FlowableException("A delegated task cannot be completed, but should be resolved instead.");
            }
            if (localVariables != null && !localVariables.isEmpty()) {
                taskEntity.setVariablesLocal(localVariables);
            }
            if (variables != null && !variables.isEmpty()) {
                if (taskEntity.getExecutionId() != null) {
                    execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(taskEntity.getExecutionId());
                    if (execution != null) {
                        execution.setVariables(variables);
                    }
                } else {
                    taskEntity.setVariables(variables);
                }
            }
            if (localTransientVariables != null && !localTransientVariables.isEmpty()) {
                taskEntity.setTransientVariablesLocal(localTransientVariables);
            }
            if (transientVariables != null && !transientVariables.isEmpty()) {
                if (taskEntity.getExecutionId() != null) {
                    execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(taskEntity.getExecutionId());
                    if (execution != null) {
                        execution.setTransientVariables(transientVariables);
                    }
                } else {
                    taskEntity.setTransientVariables(transientVariables);
                }
            }
            processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
            bpmnErrorPropagated = false;
            try {
                processEngineConfiguration.getListenerNotificationHelper().executeTaskListeners(taskEntity, "complete");
            }
            catch (BpmnError bpmnError) {
                ExecutionEntity execution2;
                if (taskEntity.getExecutionId() == null || (execution2 = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(taskEntity.getExecutionId())) == null) break block20;
                ErrorPropagation.propagateError(bpmnError, (DelegateExecution)execution2);
                bpmnErrorPropagated = true;
            }
        }
        if (processEngineConfiguration.getIdentityLinkInterceptor() != null) {
            processEngineConfiguration.getIdentityLinkInterceptor().handleCompleteTask(taskEntity);
        }
        TaskHelper.logUserTaskCompleted(taskEntity);
        FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            if (variables != null) {
                boolean local = localVariables != null && !localVariables.isEmpty();
                Map<String, Object> eventVariables = null;
                eventVariables = local ? localVariables : variables;
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityWithVariablesEvent(FlowableEngineEventType.TASK_COMPLETED, taskEntity, eventVariables, local), processEngineConfiguration.getEngineCfgKey());
            } else {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_COMPLETED, taskEntity), processEngineConfiguration.getEngineCfgKey());
            }
        }
        if (processEngineConfiguration.isLoggingSessionEnabled() && taskEntity.getExecutionId() != null) {
            String taskLabel = null;
            taskLabel = StringUtils.isNotEmpty((CharSequence)taskEntity.getName()) ? taskEntity.getName() : taskEntity.getId();
            ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(taskEntity.getExecutionId());
            if (execution != null) {
                BpmnLoggingSessionUtil.addLoggingData("userTaskComplete", "User task '" + taskLabel + "' completed", taskEntity, execution);
            }
        }
        TaskHelper.deleteTask(taskEntity, null, false, true, true);
        if (taskEntity.getExecutionId() != null && !bpmnErrorPropagated) {
            ExecutionEntity executionEntity = (ExecutionEntity)processEngineConfiguration.getExecutionEntityManager().findById(taskEntity.getExecutionId());
            CommandContextUtil.getAgenda(commandContext).planTriggerExecutionOperation(executionEntity);
        }
    }

    protected static void logUserTaskCompleted(TaskEntity taskEntity) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        TaskServiceConfiguration taskServiceConfiguration = processEngineConfiguration.getTaskServiceConfiguration();
        if (taskServiceConfiguration.isEnableHistoricTaskLogging()) {
            BaseHistoricTaskLogEntryBuilderImpl taskLogEntryBuilder = new BaseHistoricTaskLogEntryBuilderImpl((TaskInfo)taskEntity);
            ObjectNode data = taskServiceConfiguration.getObjectMapper().createObjectNode();
            taskLogEntryBuilder.timeStamp(taskServiceConfiguration.getClock().getCurrentTime());
            taskLogEntryBuilder.userId(Authentication.getAuthenticatedUserId());
            taskLogEntryBuilder.data(data.toString());
            taskLogEntryBuilder.type(HistoricTaskLogEntryType.USER_TASK_COMPLETED.name());
            taskServiceConfiguration.getInternalHistoryTaskManager().recordHistoryUserTaskLog((HistoricTaskLogEntryBuilder)taskLogEntryBuilder);
        }
    }

    public static void changeTaskAssignee(TaskEntity taskEntity, String assignee) {
        if (taskEntity.getAssignee() != null && !taskEntity.getAssignee().equals(assignee) || taskEntity.getAssignee() == null && assignee != null) {
            ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
            processEngineConfiguration.getTaskServiceConfiguration().getTaskService().changeTaskAssignee(taskEntity, assignee);
            TaskHelper.fireAssignmentEvents(taskEntity);
            if (taskEntity.getId() != null) {
                TaskHelper.addAssigneeIdentityLinks(taskEntity);
            }
        }
    }

    public static void changeTaskOwner(TaskEntity taskEntity, String owner) {
        if (taskEntity.getOwner() != null && !taskEntity.getOwner().equals(owner) || taskEntity.getOwner() == null && owner != null) {
            ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
            processEngineConfiguration.getTaskServiceConfiguration().getTaskService().changeTaskOwner(taskEntity, owner);
            if (taskEntity.getId() != null) {
                TaskHelper.addOwnerIdentityLink(taskEntity, taskEntity.getOwner());
            }
        }
    }

    public static void insertTask(TaskEntity taskEntity, ExecutionEntity execution, boolean fireCreateEvent, boolean addEntityLinks) {
        if (execution != null && execution.getTenantId() != null) {
            taskEntity.setTenantId(execution.getTenantId());
        }
        if (execution != null) {
            taskEntity.setExecutionId(execution.getId());
            taskEntity.setProcessInstanceId(execution.getProcessInstanceId());
            taskEntity.setProcessDefinitionId(execution.getProcessDefinitionId());
        }
        TaskHelper.insertTask(taskEntity, fireCreateEvent);
        if (execution != null) {
            if (CountingEntityUtil.isExecutionRelatedEntityCountEnabled(execution)) {
                CountingExecutionEntity countingExecutionEntity = (CountingExecutionEntity)((Object)execution);
                countingExecutionEntity.setTaskCount(countingExecutionEntity.getTaskCount() + 1);
            }
            if (addEntityLinks) {
                EntityLinkUtil.createEntityLinks(execution.getProcessInstanceId(), execution.getId(), taskEntity.getTaskDefinitionKey(), taskEntity.getId(), "task");
            }
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
        if (fireCreateEvent && eventDispatcher != null && eventDispatcher.isEnabled() && taskEntity.getAssignee() != null) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_ASSIGNED, taskEntity), processEngineConfiguration.getEngineCfgKey());
        }
        processEngineConfiguration.getActivityInstanceEntityManager().recordTaskCreated(taskEntity, execution);
    }

    public static void insertTask(TaskEntity taskEntity, boolean fireCreateEvent) {
        if (taskEntity.getOwner() != null) {
            TaskHelper.addOwnerIdentityLink(taskEntity, taskEntity.getOwner());
        }
        if (taskEntity.getAssignee() != null) {
            TaskHelper.addAssigneeIdentityLinks(taskEntity);
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        processEngineConfiguration.getTaskServiceConfiguration().getTaskService().insertTask(taskEntity, fireCreateEvent);
    }

    public static void addAssigneeIdentityLinks(TaskEntity taskEntity) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        if (processEngineConfiguration.getIdentityLinkInterceptor() != null) {
            processEngineConfiguration.getIdentityLinkInterceptor().handleAddAssigneeIdentityLinkToTask(taskEntity, taskEntity.getAssignee());
        }
    }

    public static void addOwnerIdentityLink(TaskEntity taskEntity, String owner) {
        if (owner == null && taskEntity.getOwner() == null) {
            return;
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        if (processEngineConfiguration.getIdentityLinkInterceptor() != null) {
            processEngineConfiguration.getIdentityLinkInterceptor().handleAddOwnerIdentityLinkToTask(taskEntity, owner);
        }
    }

    public static void deleteTasksForExecution(ExecutionEntity executionEntity, Collection<TaskEntity> taskEntities, String deleteReason) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        for (TaskEntity taskEntity : taskEntities) {
            TaskHelper.internalDeleteTask(taskEntity, deleteReason, false, false, true, true);
        }
        processEngineConfiguration.getTaskServiceConfiguration().getTaskService().deleteTasksByExecutionId(executionEntity.getId());
    }

    public static void deleteTask(TaskEntity task, String deleteReason, boolean cascade, boolean fireTaskListener, boolean fireEvents) {
        TaskHelper.internalDeleteTask(task, deleteReason, cascade, true, fireTaskListener, fireEvents);
    }

    protected static void internalDeleteTask(TaskEntity task, String deleteReason, boolean cascade, boolean executeTaskDelete, boolean fireTaskListener, boolean fireEvents) {
        if (!task.isDeleted()) {
            FlowableEventDispatcher eventDispatcher;
            CommandContext commandContext;
            block6: {
                commandContext = CommandContextUtil.getCommandContext();
                eventDispatcher = CommandContextUtil.getEventDispatcher(commandContext);
                boolean bl = fireEvents = fireEvents && eventDispatcher != null && eventDispatcher.isEnabled();
                if (fireTaskListener) {
                    try {
                        CommandContextUtil.getProcessEngineConfiguration(commandContext).getListenerNotificationHelper().executeTaskListeners(task, "delete");
                    }
                    catch (BpmnError bpmnError) {
                        ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(task.getExecutionId());
                        if (execution == null) break block6;
                        ErrorPropagation.propagateError(bpmnError, (DelegateExecution)execution);
                    }
                }
            }
            task.setDeleted(true);
            TaskHelper.handleRelatedEntities(commandContext, task, deleteReason, cascade, fireTaskListener, fireEvents, eventDispatcher);
            TaskHelper.handleTaskHistory(commandContext, task, deleteReason, cascade);
            if (executeTaskDelete) {
                TaskHelper.executeTaskDelete(task, commandContext);
            }
            if (fireEvents) {
                TaskHelper.fireTaskDeletedEvent(task, commandContext, eventDispatcher);
            }
        }
    }

    protected static void handleRelatedEntities(CommandContext commandContext, TaskEntity task, String deleteReason, boolean cascade, boolean fireTaskListener, boolean fireEvents, FlowableEventDispatcher eventDispatcher) {
        boolean isTaskRelatedEntityCountEnabled = CountingEntityUtil.isTaskRelatedEntityCountEnabled(task);
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        if (!isTaskRelatedEntityCountEnabled || isTaskRelatedEntityCountEnabled && ((CountingTaskEntity)task).getSubTaskCount() > 0) {
            TaskService taskService = processEngineConfiguration.getTaskServiceConfiguration().getTaskService();
            List subTasks = taskService.findTasksByParentTaskId(task.getId());
            for (Task subTask : subTasks) {
                TaskHelper.internalDeleteTask((TaskEntity)subTask, deleteReason, cascade, true, fireTaskListener, fireEvents);
            }
        }
        if (!isTaskRelatedEntityCountEnabled || isTaskRelatedEntityCountEnabled && ((CountingTaskEntity)task).getIdentityLinkCount() > 0) {
            boolean deleteIdentityLinks = true;
            if (fireEvents) {
                List identityLinks = processEngineConfiguration.getIdentityLinkServiceConfiguration().getIdentityLinkService().findIdentityLinksByTaskId(task.getId());
                for (IdentityLinkEntity identityLinkEntity : identityLinks) {
                    eventDispatcher.dispatchEvent((FlowableEvent)FlowableIdentityLinkEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.ENTITY_DELETED, (Object)identityLinkEntity), processEngineConfiguration.getEngineCfgKey());
                }
                boolean bl = deleteIdentityLinks = !identityLinks.isEmpty();
            }
            if (deleteIdentityLinks) {
                processEngineConfiguration.getIdentityLinkServiceConfiguration().getIdentityLinkService().deleteIdentityLinksByTaskId(task.getId());
            }
        }
        if (!isTaskRelatedEntityCountEnabled || isTaskRelatedEntityCountEnabled && ((CountingTaskEntity)task).getVariableCount() > 0) {
            Map taskVariables = task.getVariableInstanceEntities();
            ArrayList<ByteArrayRef> variableByteArrayRefs = new ArrayList<ByteArrayRef>();
            for (VariableInstanceEntity variableInstanceEntity : taskVariables.values()) {
                if (fireEvents) {
                    eventDispatcher.dispatchEvent((FlowableEvent)FlowableVariableEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.ENTITY_DELETED, (Object)variableInstanceEntity), processEngineConfiguration.getEngineCfgKey());
                }
                if (variableInstanceEntity.getByteArrayRef() == null || variableInstanceEntity.getByteArrayRef().getId() == null) continue;
                variableByteArrayRefs.add(variableInstanceEntity.getByteArrayRef());
            }
            for (ByteArrayRef variableByteArrayRef : variableByteArrayRefs) {
                processEngineConfiguration.getByteArrayEntityManager().deleteByteArrayById(variableByteArrayRef.getId());
            }
            if (!taskVariables.isEmpty()) {
                processEngineConfiguration.getVariableServiceConfiguration().getVariableService().deleteVariablesByTaskId(task.getId());
            }
        }
    }

    protected static void handleTaskHistory(CommandContext commandContext, TaskEntity task, String deleteReason, boolean cascade) {
        if (cascade) {
            TaskHelper.deleteHistoricTask(task.getId());
        } else {
            ExecutionEntity execution = null;
            if (task.getExecutionId() != null) {
                execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(task.getExecutionId());
            }
            CommandContextUtil.getHistoryManager(commandContext).recordTaskEnd(task, execution, deleteReason, CommandContextUtil.getProcessEngineConfiguration(commandContext).getClock().getCurrentTime());
        }
    }

    protected static void executeTaskDelete(TaskEntity task, CommandContext commandContext) {
        CountingExecutionEntity countingExecutionEntity;
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        processEngineConfiguration.getTaskServiceConfiguration().getTaskService().deleteTask(task, false);
        if (task.getExecutionId() != null && CountingEntityUtil.isExecutionRelatedEntityCountEnabledGlobally() && CountingEntityUtil.isExecutionRelatedEntityCountEnabled(countingExecutionEntity = (CountingExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(task.getExecutionId()))) {
            countingExecutionEntity.setTaskCount(countingExecutionEntity.getTaskCount() - 1);
        }
    }

    protected static void fireTaskDeletedEvent(TaskEntity task, CommandContext commandContext, FlowableEventDispatcher eventDispatcher) {
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
            CommandContextUtil.getEventDispatcher(commandContext).dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, task), processEngineConfiguration.getEngineCfgKey());
        }
    }

    public static void deleteTask(String taskId, String deleteReason, boolean cascade) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        TaskEntity task = processEngineConfiguration.getTaskServiceConfiguration().getTaskService().getTask(taskId);
        if (task != null) {
            if (task.getExecutionId() != null) {
                throw new FlowableException("The task cannot be deleted because is part of a running process");
            }
            if (task.getScopeId() != null && "cmmn".equals(task.getScopeType())) {
                throw new FlowableException("The task cannot be deleted because is part of a running case");
            }
            if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, task.getProcessDefinitionId())) {
                Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                compatibilityHandler.deleteTask(taskId, deleteReason, cascade);
                return;
            }
            TaskHelper.deleteTask(task, deleteReason, cascade, true, true);
        } else if (cascade) {
            TaskHelper.deleteHistoricTask(taskId);
        }
    }

    public static void deleteTasksByProcessInstanceId(String processInstanceId, String deleteReason, boolean cascade) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        List tasks = processEngineConfiguration.getTaskServiceConfiguration().getTaskService().findTasksByProcessInstanceId(processInstanceId);
        for (TaskEntity task : tasks) {
            FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
            if (eventDispatcher != null && eventDispatcher.isEnabled() && !task.isCanceled()) {
                task.setCanceled(true);
                ExecutionEntity execution = (ExecutionEntity)processEngineConfiguration.getExecutionEntityManager().findById(task.getExecutionId());
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityCancelledEvent(execution.getActivityId(), task.getName(), task.getExecutionId(), task.getProcessInstanceId(), task.getProcessDefinitionId(), "userTask", deleteReason), processEngineConfiguration.getEngineCfgKey());
            }
            TaskHelper.deleteTask(task, deleteReason, cascade, true, true);
        }
    }

    public static void deleteHistoricTaskInstancesByProcessInstanceId(String processInstanceId) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        if (processEngineConfiguration.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            HistoricTaskService historicTaskService = processEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService();
            List taskInstances = historicTaskService.findHistoricTasksByProcessInstanceId(processInstanceId);
            for (HistoricTaskInstanceEntity historicTaskInstanceEntity : taskInstances) {
                TaskHelper.deleteHistoricTask(historicTaskInstanceEntity.getId());
            }
        }
    }

    public static void bulkDeleteHistoricTaskInstancesForProcessInstanceIds(Collection<String> processInstanceIds) {
        List taskIds;
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        if (processEngineConfiguration.getHistoryManager().isHistoryEnabled() && (taskIds = processEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskInstanceEntityManager().findHistoricTaskIdsForProcessInstanceIds(processInstanceIds)) != null && !taskIds.isEmpty()) {
            TaskHelper.bulkDeleteHistoricTaskInstances(taskIds, processEngineConfiguration);
        }
    }

    public static void deleteHistoricTask(String taskId) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        if (processEngineConfiguration.getHistoryManager().isHistoryEnabled()) {
            processEngineConfiguration.getCommentEntityManager().deleteCommentsByTaskId(taskId);
            processEngineConfiguration.getAttachmentEntityManager().deleteAttachmentsByTaskId(taskId);
            HistoricTaskService historicTaskService = processEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService();
            HistoricTaskInstanceEntity historicTaskInstance = historicTaskService.getHistoricTask(taskId);
            if (historicTaskInstance != null) {
                if (historicTaskInstance.getProcessDefinitionId() != null && Flowable5Util.isFlowable5ProcessDefinitionId(CommandContextUtil.getCommandContext(), historicTaskInstance.getProcessDefinitionId())) {
                    Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                    compatibilityHandler.deleteHistoricTask(taskId);
                    return;
                }
                List subTasks = historicTaskService.findHistoricTasksByParentTaskId(historicTaskInstance.getId());
                for (HistoricTaskInstance subTask : subTasks) {
                    TaskHelper.deleteHistoricTask(subTask.getId());
                }
                processEngineConfiguration.getHistoricDetailEntityManager().deleteHistoricDetailsByTaskId(taskId);
                processEngineConfiguration.getVariableServiceConfiguration().getHistoricVariableService().deleteHistoricVariableInstancesByTaskId(taskId);
                processEngineConfiguration.getIdentityLinkServiceConfiguration().getHistoricIdentityLinkService().deleteHistoricIdentityLinksByTaskId(taskId);
                historicTaskService.deleteHistoricTask(historicTaskInstance);
            }
        }
        TaskHelper.deleteHistoricTaskEventLogEntries(taskId);
    }

    public static void deleteHistoricTaskEventLogEntries(String taskId) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        TaskServiceConfiguration taskServiceConfiguration = processEngineConfiguration.getTaskServiceConfiguration();
        if (taskServiceConfiguration.isEnableHistoricTaskLogging()) {
            taskServiceConfiguration.getHistoricTaskService().deleteHistoricTaskLogEntriesForTaskId(taskId);
        }
    }

    public static boolean isFormFieldValidationEnabled(VariableContainer variableContainer, ProcessEngineConfigurationImpl processEngineConfiguration, String formFieldValidationExpression) {
        if (StringUtils.isNotEmpty((CharSequence)formFieldValidationExpression)) {
            Boolean formFieldValidation = TaskHelper.getBoolean(formFieldValidationExpression);
            if (formFieldValidation != null) {
                return formFieldValidation;
            }
            if (variableContainer != null) {
                ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
                Boolean formFieldValidationValue = TaskHelper.getBoolean(expressionManager.createExpression(formFieldValidationExpression).getValue(variableContainer));
                if (formFieldValidationValue == null) {
                    throw new FlowableException("Unable to resolve formFieldValidationExpression to boolean value");
                }
                return formFieldValidationValue;
            }
            throw new FlowableException("Unable to resolve formFieldValidationExpression without variable container");
        }
        return true;
    }

    protected static void bulkDeleteHistoricTaskInstances(Collection<String> taskIds, ProcessEngineConfigurationImpl processEngineConfiguration) {
        HistoricTaskService historicTaskService = processEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService();
        List subTaskIds = historicTaskService.findHistoricTaskIdsByParentTaskIds(taskIds);
        if (subTaskIds != null && !subTaskIds.isEmpty()) {
            TaskHelper.bulkDeleteHistoricTaskInstances(subTaskIds, processEngineConfiguration);
        }
        processEngineConfiguration.getCommentEntityManager().bulkDeleteCommentsForTaskIds(taskIds);
        processEngineConfiguration.getAttachmentEntityManager().bulkDeleteAttachmentsByTaskId(taskIds);
        processEngineConfiguration.getHistoricDetailEntityManager().bulkDeleteHistoricDetailsByTaskIds(taskIds);
        processEngineConfiguration.getVariableServiceConfiguration().getHistoricVariableService().bulkDeleteHistoricVariableInstancesByTaskIds(taskIds);
        processEngineConfiguration.getIdentityLinkServiceConfiguration().getHistoricIdentityLinkService().bulkDeleteHistoricIdentityLinksForTaskIds(taskIds);
        historicTaskService.bulkDeleteHistoricTaskInstances(taskIds);
        historicTaskService.bulkDeleteHistoricTaskLogEntriesForTaskIds(taskIds);
    }

    protected static Boolean getBoolean(Object booleanObject) {
        if (booleanObject instanceof Boolean) {
            return (Boolean)booleanObject;
        }
        if (booleanObject instanceof String) {
            if ("true".equalsIgnoreCase((String)booleanObject)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase((String)booleanObject)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected static void fireAssignmentEvents(TaskEntity taskEntity) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        try {
            processEngineConfiguration.getListenerNotificationHelper().executeTaskListeners(taskEntity, "assignment");
        }
        catch (BpmnError e) {
            ErrorPropagation.propagateError(e, (DelegateExecution)CommandContextUtil.getExecutionEntityManager().findById(taskEntity.getExecutionId()));
        }
        FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_ASSIGNED, taskEntity), processEngineConfiguration.getEngineCfgKey());
        }
    }
}

