/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.variable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;
import org.flowable.bpmn.model.VariableAggregationDefinition;
import org.flowable.bpmn.model.VariableAggregationDefinitions;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.variable.VariableAggregator;
import org.flowable.engine.delegate.variable.VariableAggregatorContext;
import org.flowable.engine.impl.bpmn.helper.ClassDelegateUtil;
import org.flowable.engine.impl.bpmn.helper.DelegateExpressionUtil;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.delegate.BaseVariableAggregatorContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.service.VariableService;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class BpmnAggregation {
    public static final String COUNTER_VAR_PREFIX = "__flowableCounter__";
    public static final String COUNTER_VAR_VALUE_SEPARATOR = "###";
    protected final String executionId;

    public BpmnAggregation(String executionId) {
        this.executionId = executionId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public static VariableInstanceEntity aggregateComplete(DelegateExecution execution, DelegateExecution parentExecution, VariableAggregationDefinition aggregation, ProcessEngineConfigurationImpl processEngineConfiguration) {
        return BpmnAggregation.aggregate(execution, parentExecution, BaseVariableAggregatorContext.complete(aggregation), processEngineConfiguration);
    }

    public static VariableInstanceEntity aggregate(DelegateExecution execution, DelegateExecution parentExecution, VariableAggregatorContext aggregationContext, ProcessEngineConfigurationImpl processEngineConfiguration) {
        VariableAggregationDefinition aggregation = aggregationContext.getDefinition();
        VariableAggregator aggregator = BpmnAggregation.resolveVariableAggregator(aggregation, execution);
        String targetVarName = BpmnAggregation.getAggregationTargetVarName(aggregation, execution, processEngineConfiguration);
        if (targetVarName != null) {
            return BpmnAggregation.aggregate(execution, parentExecution, aggregationContext, processEngineConfiguration, aggregator, targetVarName);
        }
        return null;
    }

    public static VariableInstanceEntity aggregate(DelegateExecution execution, DelegateExecution parentExecution, VariableAggregatorContext aggregationContext, ProcessEngineConfigurationImpl processEngineConfiguration, VariableAggregator aggregator, String targetVarName) {
        VariableServiceConfiguration variableServiceConfiguration = processEngineConfiguration.getVariableServiceConfiguration();
        Object aggregatedValue = aggregator.aggregateSingleVariable(execution, aggregationContext);
        String processInstanceId = execution.getProcessInstanceId();
        String parentExecutionId = parentExecution.getId();
        return BpmnAggregation.createScopedVariableAggregationVariableInstance(targetVarName, processInstanceId, parentExecutionId, aggregatedValue, variableServiceConfiguration);
    }

    public static Object aggregateOverview(String parentExecutionId, String targetVarName, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        ExecutionEntity parentExecution = (ExecutionEntity)processEngineConfiguration.getExecutionEntityManager().findById(parentExecutionId);
        if (parentExecution.isMultiInstanceRoot()) {
            return BpmnAggregation.aggregateOverviewForMultiInstance(parentExecution, targetVarName, processEngineConfiguration);
        }
        return null;
    }

    public static Object aggregateOverviewForMultiInstance(ExecutionEntity parentExecution, String targetVarName, ProcessEngineConfigurationImpl processEngineConfiguration) {
        FlowElement currentFlowElement = parentExecution.getCurrentFlowElement();
        if (!(currentFlowElement instanceof Activity)) {
            return null;
        }
        Activity activity = (Activity)currentFlowElement;
        MultiInstanceLoopCharacteristics loopCharacteristics = activity.getLoopCharacteristics();
        if (loopCharacteristics == null) {
            return null;
        }
        VariableAggregationDefinitions aggregations = loopCharacteristics.getAggregations();
        if (aggregations == null) {
            return null;
        }
        VariableServiceConfiguration variableServiceConfiguration = processEngineConfiguration.getVariableServiceConfiguration();
        VariableService variableService = variableServiceConfiguration.getVariableService();
        List instances = variableService.createInternalVariableInstanceQuery().subScopeId(parentExecution.getId()).scopeType("bpmnVariableAggregation").names(Arrays.asList(targetVarName, COUNTER_VAR_PREFIX + targetVarName)).list();
        String elementIndexVariable = (String)StringUtils.defaultIfBlank((CharSequence)loopCharacteristics.getElementIndexVariable(), (CharSequence)"loopCounter");
        Map<String, VariableAggregationDefinition> aggregationsByTarget = BpmnAggregation.groupAggregationsByTarget(parentExecution, aggregations.getOverviewAggregations(), processEngineConfiguration);
        VariableAggregationDefinition aggregation = aggregationsByTarget.get(targetVarName);
        VariableAggregator aggregator = BpmnAggregation.resolveVariableAggregator(aggregation, parentExecution);
        VariableAggregatorContext aggregationContext = BaseVariableAggregatorContext.overview(aggregation);
        for (ExecutionEntity executionEntity : parentExecution.getExecutions()) {
            if (!executionEntity.isActive() || executionEntity.getCurrentFlowElement() instanceof BoundaryEvent) continue;
            VariableInstanceEntity aggregatedVarInstance = BpmnAggregation.aggregate(executionEntity, parentExecution, aggregationContext, processEngineConfiguration, aggregator, targetVarName);
            aggregatedVarInstance.setId(executionEntity.getId() + targetVarName);
            instances.add(aggregatedVarInstance);
            Integer elementIndexValue = (Integer)executionEntity.getVariable(elementIndexVariable, Integer.class);
            if (elementIndexValue == null) {
                elementIndexValue = 0;
            }
            String counterValue = aggregatedVarInstance.getId() + COUNTER_VAR_VALUE_SEPARATOR + elementIndexValue;
            VariableInstanceEntity counterVarInstance = BpmnAggregation.createScopedVariableAggregationVariableInstance(COUNTER_VAR_PREFIX + targetVarName, aggregatedVarInstance.getScopeId(), aggregatedVarInstance.getSubScopeId(), counterValue, variableServiceConfiguration);
            instances.add(counterVarInstance);
        }
        if (!instances.isEmpty()) {
            Map<String, List<VariableInstance>> instancesByName = BpmnAggregation.groupVariableInstancesByName(instances);
            List<VariableInstance> list = instancesByName.get(targetVarName);
            List<VariableInstance> counterVariables = instancesByName.getOrDefault(COUNTER_VAR_PREFIX + targetVarName, Collections.emptyList());
            BpmnAggregation.sortVariablesByCounter(list, counterVariables);
            return aggregator.aggregateMultiVariables(parentExecution, list, aggregationContext);
        }
        return null;
    }

    public static VariableInstanceEntity createScopedVariableAggregationVariableInstance(String varName, String scopeId, String subScopeId, Object value, VariableServiceConfiguration variableServiceConfiguration) {
        VariableService variableService = variableServiceConfiguration.getVariableService();
        VariableType variableType = variableServiceConfiguration.getVariableTypes().findVariableType(value);
        VariableInstanceEntity variableInstance = variableService.createVariableInstance(varName, variableType, value);
        variableInstance.setScopeId(scopeId);
        variableInstance.setSubScopeId(subScopeId);
        variableInstance.setScopeType("bpmnVariableAggregation");
        return variableInstance;
    }

    public static Map<String, List<VariableInstance>> groupVariableInstancesByName(List<? extends VariableInstance> instances) {
        return instances.stream().collect(Collectors.groupingBy(ValueFields::getName));
    }

    public static VariableAggregator resolveVariableAggregator(VariableAggregationDefinition aggregation, DelegateExecution execution) {
        if ("class".equalsIgnoreCase(aggregation.getImplementationType())) {
            Object delegate = ClassDelegateUtil.instantiateDelegate(aggregation.getImplementation(), null);
            if (delegate instanceof VariableAggregator) {
                return (VariableAggregator)delegate;
            }
            throw new FlowableIllegalArgumentException("Class " + aggregation.getImplementation() + " does not implement " + VariableAggregator.class);
        }
        if ("delegateExpression".equalsIgnoreCase(aggregation.getImplementationType())) {
            Object delegate = DelegateExpressionUtil.resolveDelegateExpression(CommandContextUtil.getProcessEngineConfiguration().getExpressionManager().createExpression(aggregation.getImplementation()), execution);
            if (delegate instanceof VariableAggregator) {
                return (VariableAggregator)delegate;
            }
            throw new FlowableIllegalArgumentException("Delegate expression " + aggregation.getImplementation() + " did not resolve to an implementation of " + VariableAggregator.class);
        }
        return CommandContextUtil.getProcessEngineConfiguration().getVariableAggregator();
    }

    public static void sortVariablesByCounter(List<VariableInstance> variableInstances, List<VariableInstance> counterVariableInstances) {
        if (counterVariableInstances == null || counterVariableInstances.isEmpty()) {
            return;
        }
        HashMap<String, Integer> sortOrder = new HashMap<String, Integer>();
        for (VariableInstance counterVariable : counterVariableInstances) {
            Object value = counterVariable.getValue();
            String[] values = value.toString().split(COUNTER_VAR_VALUE_SEPARATOR);
            String variableInstanceId = values[0];
            int order = Integer.parseInt(values[1]);
            sortOrder.put(variableInstanceId, order);
        }
        variableInstances.sort(Comparator.comparingInt(o -> sortOrder.getOrDefault(o.getId(), 0)));
    }

    public static Map<String, VariableAggregationDefinition> groupAggregationsByTarget(DelegateExecution multiInstanceRootExecution, Collection<VariableAggregationDefinition> aggregations, ProcessEngineConfigurationImpl processEngineConfiguration) {
        HashMap<String, VariableAggregationDefinition> aggregationsByTarget = new HashMap<String, VariableAggregationDefinition>();
        for (VariableAggregationDefinition aggregation : aggregations) {
            String targetVarName = BpmnAggregation.getAggregationTargetVarName(aggregation, multiInstanceRootExecution, processEngineConfiguration);
            aggregationsByTarget.put(targetVarName, aggregation);
        }
        return aggregationsByTarget;
    }

    public static String getAggregationTargetVarName(VariableAggregationDefinition aggregation, DelegateExecution execution, ProcessEngineConfigurationImpl processEngineConfiguration) {
        String targetVarName = null;
        if (StringUtils.isNotEmpty((CharSequence)aggregation.getTargetExpression())) {
            Object value = processEngineConfiguration.getExpressionManager().createExpression(aggregation.getTargetExpression()).getValue((VariableContainer)execution);
            if (value != null) {
                targetVarName = value.toString();
            }
        } else if (StringUtils.isNotEmpty((CharSequence)aggregation.getTarget())) {
            targetVarName = aggregation.getTarget();
        }
        return targetVarName;
    }
}

