/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.stack.StackFrameVisitor;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

public class FramePointerMapWalker
implements StackFrameVisitor {
    private final ObjectReferenceVisitor visitor;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected FramePointerMapWalker(ObjectReferenceVisitor objRefVisitor) {
        this.visitor = objRefVisitor;
    }

    @Override
    public boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame) {
        if (DeoptimizationSupport.enabled() && FramePointerMapWalker.isRuntimeCompiledCode(codeInfo)) {
            RuntimeCodeInfoAccess.walkStrongReferences(codeInfo, this.visitor);
            RuntimeCodeInfoAccess.walkWeakReferences(codeInfo, this.visitor);
        }
        return CodeInfoTable.visitObjectReferences(sp, ip, codeInfo, deoptimizedFrame, this.visitor);
    }

    private static boolean isRuntimeCompiledCode(CodeInfo codeInfo) {
        return codeInfo != CodeInfoTable.getImageCodeInfo();
    }
}

